/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.gui.tabs;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.table.TableColumn;
import jpdftweak.core.PdfTweak;
import jpdftweak.core.ViewerPreference;
import jpdftweak.gui.MainForm;
import jpdftweak.gui.TableComponent;
import jpdftweak.gui.tabs.Tab;

public class InteractionTab
extends Tab {
    private JCheckBox[] optionalPrefCheck = new JCheckBox[ViewerPreference.SUPPORTED_VIEWER_PREFERENCES.length];
    private JComboBox[] optionalPrefValue = new JComboBox[ViewerPreference.SUPPORTED_VIEWER_PREFERENCES.length];
    private TableComponent transitions;
    private JCheckBox addTransitions;
    private JCheckBox addPrefs;
    private JComboBox pageMode;
    private JComboBox pageLayout;

    public InteractionTab(MainForm mainForm) {
        super(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.addTransitions = new JCheckBox("Add page transitions");
        jPanel.add((Component)this.addTransitions, "North");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InteractionTab.this.updateEnabledState();
            }
        };
        this.addTransitions.addActionListener(actionListener);
        this.transitions = new TableComponent(new String[]{"First Page", "Last Page", "Transition", "TransDur.", "PageDur."}, new Class[]{Integer.class, Integer.class, String.class, Integer.class, Integer.class}, new Object[]{1, -1, "None", 0, -1});
        jPanel.add((Component)this.transitions, "Center");
        this.transitions.getScrollPane().setPreferredSize(new Dimension(200, 300));
        TableColumn tableColumn = this.transitions.getTable().getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(200);
        tableColumn.setCellEditor(new DefaultCellEditor(new JComboBox<String>(PdfTweak.TRANSITION_NAMES)));
        FormLayout formLayout = new FormLayout("f:p, f:p:g", "f:p, f:p, f:p, 10dlu");
        JPanel jPanel2 = new JPanel((LayoutManager)formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.addPrefs = new JCheckBox("Set Viewer Preferences");
        jPanel2.add((Component)this.addPrefs, cellConstraints.xyw(1, 1, 2));
        this.addPrefs.addActionListener(actionListener);
        jPanel2.add((Component)new JLabel("Page Mode: "), cellConstraints.xy(1, 2));
        this.pageMode = new JComboBox<Object>(new Object[]{"None", "Outline", "Thumbnails", "Full Screen", "Optional Content", "Attachments"});
        jPanel2.add(this.pageMode, cellConstraints.xy(2, 2));
        jPanel2.add((Component)new JLabel("Page Layout: "), cellConstraints.xy(1, 3));
        this.pageLayout = new JComboBox<Object>(new Object[]{"Single Page", "One Column", "Two Columns Left", "Two Columns Right", "Two Pages Left", "Two Pages Right"});
        jPanel2.add(this.pageLayout, cellConstraints.xy(2, 3));
        jPanel2.add((Component)new JSeparator(), cellConstraints.xyw(1, 4, 2));
        for (int i = 0; i < ViewerPreference.SUPPORTED_VIEWER_PREFERENCES.length; ++i) {
            ViewerPreference viewerPreference = ViewerPreference.SUPPORTED_VIEWER_PREFERENCES[i];
            formLayout.appendRow(RowSpec.decode((String)"f:p"));
            this.optionalPrefCheck[i] = new JCheckBox(viewerPreference.getName() + ": ");
            jPanel2.add((Component)this.optionalPrefCheck[i], cellConstraints.xy(1, i + 5));
            this.optionalPrefValue[i] = new JComboBox<PdfObject>(viewerPreference.getPossibleValues());
            jPanel2.add(this.optionalPrefValue[i], cellConstraints.xy(2, i + 5));
            this.optionalPrefCheck[i].addActionListener(actionListener);
        }
        JSplitPane jSplitPane = new JSplitPane(1, jPanel, jPanel2);
        jSplitPane.setResizeWeight(0.5);
        this.add((Component)jSplitPane, "Center");
        this.updateEnabledState();
    }

    protected void updateEnabledState() {
        this.transitions.setEnabled(this.addTransitions.isSelected());
        boolean bl = this.addPrefs.isSelected();
        this.pageMode.setEnabled(bl);
        this.pageLayout.setEnabled(bl);
        for (int i = 0; i < this.optionalPrefCheck.length; ++i) {
            this.optionalPrefCheck[i].setEnabled(bl);
            this.optionalPrefValue[i].setEnabled(bl && this.optionalPrefCheck[i].isSelected());
        }
    }

    public String getTabName() {
        return "Interaction";
    }

    public void checkRun() throws IOException {
        this.transitions.checkRun("page transition");
    }

    public PdfTweak run(PdfTweak pdfTweak) throws IOException, DocumentException {
        int n;
        Object object;
        int n2;
        if (this.addTransitions.isSelected()) {
            for (n2 = 0; n2 < this.transitions.getRowCount(); ++n2) {
                object = this.transitions.getRow(n2);
                n = (Integer)object[0];
                int n3 = (Integer)object[1];
                String string = (String)object[2];
                int n4 = Arrays.asList(PdfTweak.TRANSITION_NAMES).indexOf(string);
                if (n4 == -1) {
                    throw new RuntimeException();
                }
                int n5 = (Integer)object[3];
                int n6 = (Integer)object[4];
                if (n < 0) {
                    n += pdfTweak.getPageCount() + 1;
                }
                if (n3 < 0) {
                    n3 += pdfTweak.getPageCount() + 1;
                }
                for (int i = n; i <= n3; ++i) {
                    pdfTweak.setTransition(i, n4, n5, n6);
                }
            }
        }
        if (this.addPrefs.isSelected()) {
            n2 = (1 << this.pageLayout.getSelectedIndex()) + (64 << this.pageMode.getSelectedIndex());
            object = new HashMap();
            for (n = 0; n < this.optionalPrefCheck.length; ++n) {
                if (!this.optionalPrefCheck[n].isSelected()) continue;
                object.put(ViewerPreference.SUPPORTED_VIEWER_PREFERENCES[n].getInternalName(), (PdfObject)this.optionalPrefValue[n].getSelectedItem());
            }
            pdfTweak.setViewerPreferences(n2, (Map<PdfName, PdfObject>)object);
        }
        return pdfTweak;
    }
}

