/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.gui.tabs;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfPageLabels;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import jpdftweak.core.PdfTweak;
import jpdftweak.gui.MainForm;
import jpdftweak.gui.TableComponent;
import jpdftweak.gui.tabs.Tab;

public class PageNumberTab
extends Tab {
    private JButton load;
    private TableComponent pageNumberRanges;
    private JCheckBox changePageNumbers;
    private static final String[] NUMBER_STYLES = new String[]{"1, 2, 3", "I, II, III", "i, ii, iii", "A, B, C", "a, b, c", "Empty"};

    public PageNumberTab(MainForm mainForm) {
        super((LayoutManager)new FormLayout("f:p:g, f:p", "f:p, f:p, f:p:g"));
        CellConstraints cellConstraints = new CellConstraints();
        this.changePageNumbers = new JCheckBox("Change page numbers");
        this.add((Component)this.changePageNumbers, cellConstraints.xy(1, 1));
        this.changePageNumbers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PageNumberTab.this.updateEnabledState();
            }
        });
        this.load = new JButton("Load from document");
        this.add((Component)this.load, cellConstraints.xy(2, 1));
        this.pageNumberRanges = PageNumberTab.buildPageNumberRanges();
        this.add((Component)this.pageNumberRanges, cellConstraints.xyw(1, 3, 2));
        this.load.addActionListener(new PageNumberLoadAction(mainForm, this.pageNumberRanges));
        this.updateEnabledState();
    }

    public static TableComponent buildPageNumberRanges() {
        TableComponent tableComponent = new TableComponent(new String[]{"Start Page", "Style", "Prefix", "Logical Page"}, new Class[]{Integer.class, String.class, String.class, Integer.class}, new Object[]{1, NUMBER_STYLES[0], "", 1});
        JComboBox<String> jComboBox = new JComboBox<String>(NUMBER_STYLES);
        tableComponent.getTable().getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(jComboBox));
        return tableComponent;
    }

    protected void updateEnabledState() {
        this.load.setEnabled(this.changePageNumbers.isSelected());
        this.pageNumberRanges.setEnabled(this.changePageNumbers.isSelected());
    }

    public String getTabName() {
        return "Page Numbers";
    }

    public void checkRun() throws IOException {
        this.pageNumberRanges.checkRun("page number");
    }

    public PdfTweak run(PdfTweak pdfTweak) throws IOException, DocumentException {
        if (this.changePageNumbers.isSelected()) {
            PageNumberTab.updatePageNumberRanges(pdfTweak, this.pageNumberRanges);
        }
        return pdfTweak;
    }

    public static void updatePageNumberRanges(PdfTweak pdfTweak, TableComponent tableComponent) throws DocumentException, IOException {
        PdfPageLabels.PdfPageLabelFormat[] pdfPageLabelFormatArray = new PdfPageLabels.PdfPageLabelFormat[tableComponent.getRowCount()];
        for (int i = 0; i < pdfPageLabelFormatArray.length; ++i) {
            Object[] objectArray = tableComponent.getRow(i);
            int n = Arrays.asList(NUMBER_STYLES).indexOf(objectArray[1]);
            if (n == -1) {
                n = 0;
            }
            pdfPageLabelFormatArray[i] = new PdfPageLabels.PdfPageLabelFormat(((Integer)objectArray[0]).intValue(), n, (String)objectArray[2], ((Integer)objectArray[3]).intValue());
        }
        pdfTweak.setPageNumbers(pdfPageLabelFormatArray);
    }

    public static class PageNumberLoadAction
    implements ActionListener {
        private final TableComponent pageNumberRanges;
        private final MainForm mainForm;

        public PageNumberLoadAction(MainForm mainForm, TableComponent tableComponent) {
            this.mainForm = mainForm;
            this.pageNumberRanges = tableComponent;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.pageNumberRanges.clear();
            if (this.mainForm.getInputFile() == null) {
                return;
            }
            PdfPageLabels.PdfPageLabelFormat[] pdfPageLabelFormatArray = this.mainForm.getInputFile().getPageLabels();
            if (pdfPageLabelFormatArray != null) {
                for (PdfPageLabels.PdfPageLabelFormat pdfPageLabelFormat : pdfPageLabelFormatArray) {
                    this.pageNumberRanges.addRow(pdfPageLabelFormat.physicalPage, NUMBER_STYLES[pdfPageLabelFormat.numberStyle], pdfPageLabelFormat.prefix, pdfPageLabelFormat.logicalPage);
                }
            }
        }
    }
}

