/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.app;

import com.cyberfox.util.config.JConfig;
import com.cyberfox.util.platform.Path;
import com.cyberfox.util.platform.Platform;
import com.cyberfox.util.platform.osx.NoNap;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.jbidwatcher.UpdateManager;
import com.jbidwatcher.Upgrader;
import com.jbidwatcher.app.JBidwatcherModule;
import com.jbidwatcher.app.MacFriendlyFrame;
import com.jbidwatcher.app.UIBackbone;
import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.EntryCorral;
import com.jbidwatcher.auction.EntryFactory;
import com.jbidwatcher.auction.MultiSnipe;
import com.jbidwatcher.auction.ThumbnailLoader;
import com.jbidwatcher.auction.server.AuctionServer;
import com.jbidwatcher.auction.server.AuctionServerFactory;
import com.jbidwatcher.auction.server.AuctionServerManager;
import com.jbidwatcher.auction.server.AuctionStats;
import com.jbidwatcher.my.MyJBidwatcher;
import com.jbidwatcher.platform.Browser;
import com.jbidwatcher.platform.Sparkle;
import com.jbidwatcher.platform.Tray;
import com.jbidwatcher.scripting.JRubyPreloader;
import com.jbidwatcher.scripting.Scripting;
import com.jbidwatcher.search.SearchManager;
import com.jbidwatcher.ui.AuctionsManager;
import com.jbidwatcher.ui.FilterManager;
import com.jbidwatcher.ui.Initializer;
import com.jbidwatcher.ui.JBWDropHandler;
import com.jbidwatcher.ui.JBidFrameMouse;
import com.jbidwatcher.ui.JBidMenuBar;
import com.jbidwatcher.ui.JBidToolBar;
import com.jbidwatcher.ui.JSplashScreen;
import com.jbidwatcher.ui.JTabManager;
import com.jbidwatcher.ui.ListManager;
import com.jbidwatcher.ui.PopupMenuFactory;
import com.jbidwatcher.ui.UISnapshot;
import com.jbidwatcher.ui.commands.UserActions;
import com.jbidwatcher.ui.config.JConfigFrame;
import com.jbidwatcher.ui.util.JBidFrame;
import com.jbidwatcher.ui.util.JMouseAdapter;
import com.jbidwatcher.ui.util.RuntimeInfo;
import com.jbidwatcher.util.Constants;
import com.jbidwatcher.util.ErrorMonitor;
import com.jbidwatcher.util.config.JBErrorManagement;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.db.ActiveRecord;
import com.jbidwatcher.util.queue.AuctionQObject;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;
import com.jbidwatcher.util.queue.SuperQueue;
import com.jbidwatcher.util.queue.TimerHandler;
import com.jbidwatcher.util.services.ActivityMonitor;
import com.jbidwatcher.util.services.AudioPlayer;
import com.jbidwatcher.util.services.SyncService;
import com.jbidwatcher.util.xml.XMLElement;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.Security;
import java.util.Calendar;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public final class JBidWatch
implements JConfig.ConfigListener {
    private static ClassLoader urlCL = JBidWatch.class.getClassLoader();
    private final MyJBidwatcher myJBidwatcher;
    private final JBWDropHandler dropHandler;
    private final Provider<UIBackbone> backboneProvider;
    private final Provider<JConfigFrame> configFrameProvider;
    @Inject
    private AuctionServerFactory serverFactory;
    @Inject
    private PopupMenuFactory menuFactory;
    private final FilterManager filters;
    private final ListManager listManager;
    private final AuctionsManager auctionsManager;
    private SearchManager searchManager;
    private EntryFactory entryFactory;
    private EntryCorral corral;
    private AuctionServerManager serverManager;
    private ErrorMonitor errorMonitor;
    private Injector injector;
    private final Object memInfoSynch = new Object();
    private MacFriendlyFrame mainFrame;
    private JTabManager jtmAuctions;
    private static Sparkle mSparkle = null;
    private SyncService mServiceAdvertiser;
    private RuntimeInfo _rti = null;
    private static final int HOURS_IN_DAY = 24;
    private static final int MINUTES_IN_HOUR = 60;
    private static boolean sUSB = false;
    private boolean ebayLoaded = false;
    private final Object mScriptCompletion = new Object();
    private UserActions userActions;
    private static boolean sProxyAuthenticatorAlreadySet = false;

    private static String makeSaveDirectory(String inPath) {
        return Path.makeStandardDirectory(inPath, "auctionsave", "jbidwatcher");
    }

    private static String makePlatformDirectory(String inPath) {
        return Path.makeStandardDirectory(inPath, "platform", "jbidwatcher");
    }

    private void getUserSetup() {
        JConfig.setConfiguration("config.firstrun", "true");
        ((JConfigFrame)this.configFrameProvider.get()).spinWait();
    }

    private static InputStream checkConfig(String inConfig) {
        JConfig.setConfigurationFile(inConfig);
        return JConfig.bestSource(urlCL, inConfig);
    }

    private static void loadConfig(InputStream configStream) {
        String platform;
        String aucSave;
        JConfig.load(configStream);
        Platform.setupMacUI();
        if (Platform.isMac()) {
            NoNap.dontNapMeBro();
        }
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        String dispFile = Path.getCanonicalFile("display.cfg", "jbidwatcher", true);
        JConfig.loadDisplayConfig(dispFile, urlCL, screensize.width, screensize.height);
        if (sUSB) {
            JConfig.fixupPaths(JConfig.getHomeDirectory());
        }
        if ((aucSave = JBidWatch.makeSaveDirectory(JConfig.queryConfiguration("auctions.savepath"))) != null) {
            JConfig.setConfiguration("auctions.savepath", aucSave);
        }
        if ((platform = JBidWatch.makePlatformDirectory(JConfig.queryConfiguration("platform.path"))) != null) {
            JConfig.setConfiguration("platform.path", platform);
            if (Platform.supportsTray()) {
                Platform.setTrayEnabled(true);
            }
        }
    }

    private static boolean checkArguments(String[] inArgs) {
        boolean rval = false;
        for (String arg : inArgs) {
            rval |= JBidWatch.handleArgument(arg);
        }
        return rval;
    }

    private static boolean handleArgument(String arg) {
        if (arg.startsWith("--help") || arg.startsWith("-h")) {
            System.out.println("usage: java JBidWatch [{cfg-file}]");
            JOptionPane.showMessageDialog(null, "<html><body>usage:<br><center>java JBidWatch [{cfg-file}]</center><br>Default user home: " + Path.getHome() + "</body></html>", "Help display", -1);
            return true;
        }
        if (arg.startsWith("--usb")) {
            Path.setHome(System.getProperty("user.dir"));
            sUSB = true;
        } else if (arg.startsWith("--testImpl")) {
            System.out.println("Impl Version: " + Constants.REVISION());
            System.exit(1);
        }
        return false;
    }

    private static boolean EstablishProxy(Properties inProps) {
        String webProxyHost = JConfig.queryConfiguration("proxy.host", null);
        String webProxyPort = JConfig.queryConfiguration("proxy.port", null);
        if (JConfig.queryConfiguration("proxyfirewall", "none").equals("proxy") && webProxyHost != null && webProxyPort != null) {
            inProps.setProperty("http.proxySet", "true");
            inProps.setProperty("http.proxyHost", webProxyHost);
            inProps.setProperty("http.proxyPort", webProxyPort);
            inProps.setProperty("proxySet", "true");
            inProps.setProperty("proxyHost", webProxyHost);
            inProps.setProperty("proxyPort", webProxyPort);
            JBidWatch.setProxyAuthenticator();
            return true;
        }
        return false;
    }

    private static boolean EstablishHTTPSProxy(Properties inProps) {
        if (JConfig.queryConfiguration("proxy.https.set", "false").equals("true")) {
            String secureProxyHost = JConfig.queryConfiguration("proxy.https.host");
            String secureProxyPort = JConfig.queryConfiguration("proxy.https.port");
            if (secureProxyHost != null && secureProxyPort != null) {
                inProps.setProperty("https.proxySet", "true");
                inProps.setProperty("https.proxyHost", secureProxyHost);
                inProps.setProperty("https.proxyPort", secureProxyPort);
                JBidWatch.setProxyAuthenticator();
                return true;
            }
        }
        return false;
    }

    private static boolean EstablishFirewall(Properties inProps) {
        if (JConfig.queryConfiguration("proxyfirewall", "none").equals("firewall")) {
            String socksHost = JConfig.queryConfiguration("firewall.host", null);
            String socksPort = JConfig.queryConfiguration("firewall.port", "1080");
            if (socksHost != null) {
                inProps.setProperty("socksProxyHost", socksHost);
                inProps.setProperty("socksProxyPort", socksPort);
                JBidWatch.setProxyAuthenticator();
                return true;
            }
        }
        return false;
    }

    private static void setProxyAuthenticator() {
        if (!sProxyAuthenticatorAlreadySet) {
            final String user = JConfig.queryConfiguration("proxy.user", null);
            final String pass = JConfig.queryConfiguration("proxy.pass", null);
            if (user != null && pass != null) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        String host = this.getRequestingHost();
                        if (host == null || !host.contains("jbidwatcher")) {
                            return new PasswordAuthentication(user, pass.toCharArray());
                        }
                        return null;
                    }
                });
                sProxyAuthenticatorAlreadySet = true;
            }
        }
    }

    private static void setUI(String whichUI, JFrame inFrame, UIManager.LookAndFeelInfo[] lafList) {
        String whatLaF = null;
        if (whichUI != null) {
            for (UIManager.LookAndFeelInfo aLafList : lafList) {
                if (!whichUI.equals(aLafList.getName())) continue;
                whatLaF = aLafList.getClassName();
            }
        }
        if (whatLaF == null && (whatLaF = System.getProperty("swing.defaultlaf")) == null) {
            whatLaF = UIManager.getSystemLookAndFeelClassName();
        }
        Platform.checkLaF(whatLaF);
        if (Platform.isMac() && Platform.setQuaquaFeel(inFrame)) {
            whatLaF = null;
        }
        if (whatLaF != null) {
            try {
                UIManager.setLookAndFeel(whatLaF);
            }
            catch (Exception exMe) {
                JConfig.log().handleException("Exception in setUI, failure to set " + whatLaF + ": " + exMe, exMe);
                inFrame = null;
            }
        }
        if (inFrame != null) {
            SwingUtilities.updateComponentTreeUI(inFrame);
        }
    }

    public static void main(String[] args) {
        JConfig.setLogger(new JBErrorManagement());
        if (JBidWatch.checkArguments(args)) {
            System.exit(0);
        }
        Path.setHomeDirectory("jbidwatcher");
        JConfig.setVersion("2.99pre5");
        System.setProperty("sun.net.client.defaultConnectTimeout", "5000");
        System.setProperty("sun.net.client.defaultReadTimeout", "15000");
        Security.setProperty("networkaddress.cache.ttl", "-1");
        JBidWatch program = JBidWatch.getApplication();
        program.configure(args);
        program.startDatabase();
        program.setupSearches();
        program.loadProxySettings();
        JSplashScreen splashScreen = JBidWatch.prepSplashScreen();
        try {
            program.run(splashScreen);
            Thread.currentThread().join();
            program.repaint();
        }
        catch (Exception e) {
            JConfig.log().handleException("JBidwatcher: " + e, e);
        }
    }

    private static JBidWatch getApplication() {
        JBidwatcherModule guiceModule = new JBidwatcherModule();
        Injector inject = Guice.createInjector((Module[])new Module[]{guiceModule});
        return (JBidWatch)inject.getInstance(JBidWatch.class);
    }

    private void configure(String[] args) {
        String logFileName;
        boolean firstRun;
        boolean needUserSetup;
        String cfgLoad = "JBidWatch.cfg";
        if (args.length != 0 && args[0].charAt(0) != '-') {
            cfgLoad = args[0];
        }
        cfgLoad = Path.getCanonicalFile(cfgLoad, "jbidwatcher", false);
        InputStream configStream = JBidWatch.checkConfig(cfgLoad = JBidWatch.lookForNewerMacConfig(cfgLoad));
        boolean bl = needUserSetup = configStream == null;
        if (needUserSetup) {
            JBidWatch.setUI(null, null, UIManager.getInstalledLookAndFeels());
            this.eBayServerSetup();
            this.ebayLoaded = true;
            Platform.setupMacUI();
            JConfig.setConfiguration("first.run", "true");
            firstRun = true;
            this.getUserSetup();
            configStream = JBidWatch.checkConfig(cfgLoad);
        } else {
            JConfig.setConfiguration("first.run", "false");
            firstRun = false;
        }
        JConfig.setConfiguration("temp.cfg.load", cfgLoad);
        JBidWatch.loadConfig(configStream);
        JConfig.setConfiguration("first.run", firstRun ? "true" : "false");
        JBidWatch.setUI(null, null, UIManager.getInstalledLookAndFeels());
        JConfig.log().logMessage("JBidwatcher 2.99pre5-" + Constants.REVISION());
        JConfig.log().logMessage(System.getProperty("java.vendor") + " Java, version " + System.getProperty("java.version") + " on " + System.getProperty("os.name"));
        if (JConfig.queryConfiguration("mac", "false").equals("true")) {
            JConfig.setConfiguration("temp.cfg.load", Path.getCanonicalFile("JBidWatch.cfg", "jbidwatcher", false));
        }
        if ((logFileName = JConfig.log().getLog()) != null) {
            JConfig.log().logMessage("Logging to " + logFileName);
        }
        if (JConfig.queryConfiguration("show.badhtml", "false").equals("true")) {
            XMLElement.rejectBadHTML(true);
        }
    }

    private void startDatabase() {
        try {
            Upgrader.upgrade();
        }
        catch (Exception e) {
            if (e.getMessage().matches("^Failed to start database.*")) {
                JConfig.log().handleException("JBidwatcher can't access it's database.", e);
                JOptionPane.showMessageDialog(null, "JBidwatcher can't access its database.\nPlease check to see if you are running another instance.", "Can't access auction database", -1);
                JConfig.stopMetrics("2.99pre5");
                System.exit(0);
            }
            JConfig.log().handleException("Upgrading error", e);
        }
    }

    @Inject
    public JBidWatch(ErrorMonitor monitor, SearchManager searcher, EntryFactory entryMaker, EntryCorral holdingCell, AuctionServerManager serverManager, MyJBidwatcher myInstance, JBWDropHandler dropHandler, FilterManager filterManager, JTabManager tabManager, ListManager listManager, AuctionsManager auctionsManager, UserActions userActions, Injector inject, Provider<UIBackbone> uiBackboneProvider, Provider<JConfigFrame> configFrameProvider) {
        this.searchManager = searcher;
        this.corral = holdingCell;
        this.entryFactory = entryMaker;
        this.serverManager = serverManager;
        this.errorMonitor = monitor;
        this.myJBidwatcher = myInstance;
        this.dropHandler = dropHandler;
        this.filters = filterManager;
        this.jtmAuctions = tabManager;
        this.listManager = listManager;
        this.auctionsManager = auctionsManager;
        this.backboneProvider = uiBackboneProvider;
        this.userActions = userActions;
        this.injector = inject;
        this.configFrameProvider = configFrameProvider;
        AuctionEntry.addObserver(this.entryFactory);
        MultiSnipe.setCorral(this.corral);
    }

    private void setupSearches() {
        this.searchManager.loadSearches();
        if (!this.ebayLoaded) {
            this.eBayServerSetup();
        }
        this.searchManager.setDestinationQueue(this.serverManager.getServer().getFriendlyName());
    }

    private static JSplashScreen prepSplashScreen() {
        URL imageURL;
        Calendar rightNow = Calendar.getInstance();
        int _mon = rightNow.get(2);
        int _day = rightNow.get(5);
        if (_day == 1 && _mon == 3 && !JConfig.queryConfiguration("sniperkitty", "false").equals("true")) {
            imageURL = JConfig.getResource("/jbidwatch_apr1.jpg");
            JConfig.setConfiguration("sniperkitty", "true");
        } else {
            imageURL = JConfig.getResource(JConfig.queryConfiguration("splash", "jbidwatch.jpg"));
        }
        return new JSplashScreen(new ImageIcon(imageURL));
    }

    private static String lookForNewerMacConfig(String cfgLoad) {
        if (System.getProperty("mrj.version") != null) {
            String sep = System.getProperty("file.separator");
            String macHome = Path.getMacHomeDirectory("jbidwatcher");
            String macCfg = macHome + sep + "JBidWatch.cfg";
            File mac = new File(macCfg);
            File cfg = new File(cfgLoad);
            if (mac.lastModified() > cfg.lastModified()) {
                cfgLoad = macCfg;
            }
        }
        return cfgLoad;
    }

    private void eBayServerSetup() {
        boolean nonUS = JConfig.queryConfiguration("ebay.non_us", Boolean.toString(!Platform.isUSBased())).equals("true");
        String homeSite = nonUS ? JConfig.queryConfiguration("ebay.alternate", "ebay.co.uk") : "ebay.com";
        AuctionServer ebay = this.serverFactory.create(homeSite, null, null);
        this.serverManager.setServer(ebay);
    }

    private void repaint() {
        this.mainFrame.repaint();
    }

    private void loadProxySettings() {
        boolean sysPropsChanged;
        Properties sysProps = System.getProperties();
        boolean proxied = JBidWatch.EstablishProxy(sysProps);
        boolean firewalled = JBidWatch.EstablishFirewall(sysProps);
        boolean secured = JBidWatch.EstablishHTTPSProxy(sysProps);
        boolean bl = sysPropsChanged = proxied || firewalled || secured;
        if (sysPropsChanged) {
            System.setProperties(sysProps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void updateConfiguration() {
        String savedBGColor = JConfig.queryConfiguration("background", "false");
        if (!savedBGColor.equals("false")) {
            this.listManager.setBackground(Color.decode('#' + savedBGColor));
        }
        if (JConfig.queryConfiguration("server.enabled", "false").equals("true")) {
            this.mServiceAdvertiser = new SyncService(9099);
            this.mServiceAdvertiser.advertise();
        } else if (this.mServiceAdvertiser != null) {
            this.mServiceAdvertiser.stopAdvertising();
        }
        this.loadProxySettings();
        Object object = this.memInfoSynch;
        synchronized (object) {
            if (JConfig.queryConfiguration("debug.memory", "false").equals("true")) {
                if (this._rti == null) {
                    this._rti = new RuntimeInfo();
                } else {
                    this._rti.setVisible(true);
                }
            } else if (this._rti != null) {
                this._rti.setVisible(false);
            }
        }
    }

    private MacFriendlyFrame buildFrame() {
        URL iconURL = JConfig.getResource(JConfig.queryConfiguration("icon", "jbidwatch64.jpg"));
        JMouseAdapter myFrameAdapter = (JMouseAdapter)this.injector.getInstance(JBidFrameMouse.class);
        return new MacFriendlyFrame((JBidToolBar)this.injector.getInstance(JBidToolBar.class), "JBidwatcher", myFrameAdapter, iconURL, this.jtmAuctions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(JSplashScreen inSplash) {
        Object updateTimer;
        inSplash.message("Initializing Monitors");
        ActivityMonitor.start();
        MQFactory.getConcrete("login").registerListener(new MessageQueue.Listener(){

            @Override
            public void messageAction(Object deQ) {
                MQFactory.getConcrete("Swing").enqueue("LOGINSTATUS " + deQ.toString());
            }
        });
        ThumbnailLoader.start();
        inSplash.message("Initializing Scripting");
        JRubyPreloader preloader = new JRubyPreloader(this.mScriptCompletion);
        Thread scriptLoading = new Thread(preloader);
        scriptLoading.start();
        inSplash.message("Initializing Database");
        Initializer.setup(this.jtmAuctions, this.listManager, this.menuFactory);
        this.filters.loadFilters();
        inSplash.message("Loading Auctions");
        this.auctionsManager.loadAuctionsFromDatabase();
        this.serverManager.getDefaultServerTime();
        JConfig.registerListener(this);
        Browser.start();
        MQFactory.getConcrete("user").registerListener(this.userActions);
        inSplash.message("Building Interface");
        JBidFrame.setDefaultMenuBar(JBidMenuBar.getInstance(this.menuFactory, this.jtmAuctions.getTabs(), this.jtmAuctions, "Search Editor"));
        this.mainFrame = this.buildFrame();
        this.mainFrame.setLocation(JConfig.screenx, JConfig.screeny);
        this.mainFrame.setSize(JConfig.width, JConfig.height);
        ((UIBackbone)this.backboneProvider.get()).setMainFrame(this.mainFrame);
        Object object = this.mScriptCompletion;
        synchronized (object) {
            if (JConfig.scriptingEnabled()) {
                inSplash.message("Starting scripts");
                Scripting.setGlobalVariable("$auction_server_manager", this.serverManager);
                Scripting.setGlobalVariable("$auctions_manager", this.auctionsManager);
                Scripting.setGlobalVariable("$filter_manager", this.filters);
                Scripting.require("utilities");
            } else {
                JOptionPane.showMessageDialog(null, "<html><body>JBidwatcher is unable to load its scripting layer;<br>as of 3.0 and later, scripting is a core part of JBidwatcher<br>and it will not run without it.</body</html>", "Scripting Error", 0);
            }
        }
        inSplash.close();
        inSplash = null;
        this.jtmAuctions.sortDefault();
        this.mainFrame.setVisible(true);
        if (Platform.supportsTray()) {
            Tray.start();
            if (JConfig.queryConfiguration("windows.tray", "true").equals("true")) {
                MQFactory.getConcrete("tray").enqueue("TRAY on");
            }
        }
        this.updateConfiguration();
        MQFactory.getConcrete("run-script").registerListener(new MessageQueue.Listener(){

            @Override
            public void messageAction(Object deQ) {
                Scripting.ruby((String)deQ);
            }
        });
        SuperQueue sq = SuperQueue.getInstance();
        this.preQueueServices(sq);
        final TimerHandler timeQueue = sq.start();
        MQFactory.getConcrete("jbidwatcher").registerListener(new MessageQueue.Listener(){

            @Override
            public void messageAction(Object deQ) {
                timeQueue.interrupt();
            }
        });
        boolean updaterStarted = false;
        if (Platform.isMac()) {
            try {
                mSparkle = new Sparkle();
                mSparkle.start();
                updaterStarted = true;
                JConfig.setConfiguration("temp.sparkle", "true");
            }
            catch (Throwable e) {
                JConfig.log().handleDebugException("Couldn't start Sparkle - This message is normal under OS X 10.4", e);
                updaterStarted = false;
                JConfig.setConfiguration("temp.sparkle", "false");
            }
        }
        if (!updaterStarted) {
            updateTimer = new TimerHandler(UpdateManager.getInstance(), 86400000L);
            ((Thread)updateTimer).setName("VersionChecker");
            ((Thread)updateTimer).start();
        }
        AudioPlayer.start();
        updateTimer = this.memInfoSynch;
        synchronized (updateTimer) {
            if (this._rti == null && JConfig.queryConfiguration("debug.memory", "false").equals("true")) {
                this._rti = new RuntimeInfo();
            }
        }
        try {
            timeQueue.join();
        }
        catch (InterruptedException e) {
            JConfig.log().handleException("timeQueue interrupted", e);
        }
        this.internal_shutdown();
        JConfig.stopMetrics("2.99pre5");
        System.exit(0);
    }

    private void preQueueServices(SuperQueue q) {
        long now = System.currentTimeMillis();
        if (JConfig.queryConfiguration("updates.enabled", "true").equals("true")) {
            q.preQueue("AUTOMATIC", "update", now + 10000L);
        }
        if (JConfig.queryConfiguration("timesync.enabled", "true").equals("true")) {
            q.preQueue("TIMECHECK", "auction_manager", now + 2000L, 1800000L);
        }
        q.preQueue(new AuctionQObject(4, "Update login cookie", null), this.serverManager.getServer().getFriendlyName(), now + 3000L, 28877000L);
        q.preQueue("ALLOW_UPDATES", "Swing", now + 20000L);
        this.establishMetrics(q, now);
        q.preQueue("JBidwatcher.after_startup", "run-script", now + 2000L);
    }

    private void establishMetrics(SuperQueue q, long now) {
        if (JConfig.queryConfiguration("metrics.optin", "ask").equals("ask")) {
            q.preQueue("Metrics", "user", now + 5000L);
        }
        MQFactory.getConcrete("metrics").registerListener(new MessageQueue.Listener(){

            @Override
            public void messageAction(Object deQ) {
                if (JConfig.sendMetricsAllowed("2.99pre5")) {
                    try {
                        JConfig.getMetrics().flush();
                    }
                    catch (IOException e) {
                        JConfig.log().handleDebugException("Couldn't flush analytics to the server.", e);
                    }
                }
            }
        });
        q.preQueue("Flush Metrics", "metrics", now + 86400000L, 86400000L);
    }

    public Properties getColumnProperties() {
        Properties colProps = new Properties();
        colProps = this.listManager.extractProperties(colProps);
        return colProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internal_shutdown() {
        try {
            if (this.mServiceAdvertiser != null) {
                this.mServiceAdvertiser.stop();
            }
            for (Object o : JConfig.getTimers()) {
                ((TimerHandler)o).interrupt();
                try {
                    ((TimerHandler)o).join();
                }
                catch (InterruptedException interruptedException) {}
            }
            Properties colProps = this.getColumnProperties();
            this.searchManager.saveSearchDisplay();
            Properties displayProps = UISnapshot.snapshotLocation(this.mainFrame);
            String dispFile = Path.getCanonicalFile("display.cfg", "jbidwatcher", false);
            JConfig.saveDisplayConfig(dispFile, displayProps, colProps);
            String cfgLoad = JConfig.queryConfiguration("temp.cfg.load", "JBidWatch.cfg");
            String cfgFilename = cfgLoad.equals("JBidWatch.cfg") ? Path.getCanonicalFile(cfgLoad, "jbidwatcher", false) : cfgLoad;
            this.searchManager.saveSearches();
            AuctionStats as = this.serverManager.getStats();
            JConfig.setConfiguration("last.auctioncount", Integer.toString(as.getCount()));
            JConfig.saveConfiguration(cfgFilename);
            ActiveRecord.shutdown();
        }
        catch (Exception e) {
            JConfig.log().handleException("Threw an error during shutdown!  Shutting down anyway!", e);
        }
        finally {
            JConfig.log().logMessage("Shutting down JBidwatcher.");
            JConfig.log().closeLog();
        }
    }
}

