/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction;

import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.BadBidException;
import com.jbidwatcher.auction.Bidder;
import com.jbidwatcher.auction.LoginManager;
import com.jbidwatcher.auction.MultiSnipe;
import com.jbidwatcher.auction.MultiSnipeManager;
import com.jbidwatcher.util.UpdateBlocker;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.html.JHTML;
import com.jbidwatcher.util.http.CookieJar;
import com.jbidwatcher.util.queue.MQFactory;

public class Snipe {
    public static final int SUCCESSFUL = 0;
    public static final int RESNIPE = 1;
    public static final int FAIL = 2;
    public static final int DONE = 3;
    private final MultiSnipeManager mMultiManager;
    private CookieJar mCJ = null;
    private AuctionEntry mEntry;
    private JHTML.Form mBidForm = null;
    private LoginManager mLogin;
    private Bidder mBidder;

    public Snipe(MultiSnipeManager multiManager, LoginManager login, Bidder bidder, AuctionEntry ae) {
        this.mLogin = login;
        this.mEntry = ae;
        this.mBidder = bidder;
        this.mMultiManager = multiManager;
    }

    public int fire() {
        if (this.mEntry.getSnipeAmount().getValue() < 0.0) {
            this.mEntry.setLastStatus("Snipe amount is negative.  Not sniping.");
            return 2;
        }
        if (this.mCJ == null) {
            return this.preSnipe();
        }
        return this.doSnipe();
    }

    private int doSnipe() {
        boolean success;
        if (this.mBidForm == null) {
            return 2;
        }
        UpdateBlocker.startBlocking();
        MultiSnipe ms = this.mMultiManager.getForAuctionIdentifier(this.mEntry.getIdentifier());
        if (ms != null && ms.anyEarlier(this.mEntry)) {
            this.mEntry.setLastStatus("An earlier snipe in this multisnipe group has not ended, or has not been updated after ending.");
            this.mEntry.setLastStatus("This snipe is NOT being fired, as it could end up winning two items.");
            UpdateBlocker.endBlocking();
            return 1;
        }
        MQFactory.getConcrete("Swing").enqueue("Sniping on " + this.mEntry.getTitle());
        this.mEntry.setLastStatus("Firing actual snipe.");
        JConfig.getMetrics().trackEvent("snipe", "fired");
        int rval = this.mBidder.placeFinalBid(this.mCJ, this.mBidForm, this.mEntry, this.mEntry.getSnipeAmount(), this.mEntry.getSnipeQuantity());
        boolean bl = success = rval == 4 || rval == 5;
        if (success) {
            JConfig.getMetrics().trackEvent("snipe", "success");
        } else {
            JConfig.getMetrics().trackEventValue("snipe", "fail", Integer.toString(rval));
        }
        JConfig.increment("stats.sniped");
        String snipeResult = Snipe.getSnipeResult(rval, this.mEntry.getTitle(), this.mEntry);
        this.mEntry.setLastStatus(snipeResult);
        MQFactory.getConcrete("Swing").enqueue("NOTIFY " + snipeResult);
        JConfig.log().logDebug(snipeResult);
        this.mEntry.snipeCompleted();
        UpdateBlocker.endBlocking();
        return 3;
    }

    private int preSnipe() {
        UpdateBlocker.startBlocking();
        this.mEntry.setLastStatus("Preparing snipe.");
        this.mCJ = this.mLogin.getSignInCookie(null);
        if (this.mCJ == null) {
            this.mEntry.setLastStatus("Pre-snipe login failed.  Snipe will be retried, but is unlikely to fire.");
            MQFactory.getConcrete("Swing").enqueue("NOTIFY Pre-snipe login failed.");
            JConfig.log().logDebug("Pre-snipe login failed.");
            UpdateBlocker.endBlocking();
            return 1;
        }
        int presnipeResult = 0;
        try {
            JConfig.increment("stats.presniped");
            this.mBidForm = this.mBidder.getBidForm(this.mCJ, this.mEntry, this.mEntry.getSnipeAmount());
            if (this.mBidForm.getInputValue("maxbid").length() == 0) {
                this.mBidForm.setText("maxbid", this.mEntry.getSnipeAmount().getValueString());
            }
            JConfig.getMetrics().trackEvent("presnipe", "success");
        }
        catch (BadBidException bbe) {
            String result = Snipe.getSnipeResult(bbe.getResult(), this.mEntry.getTitle(), this.mEntry);
            this.mEntry.setLastStatus(result);
            MQFactory.getConcrete("Swing").enqueue("NOTIFY " + result);
            JConfig.log().logDebug(result);
            presnipeResult = 2;
            JConfig.getMetrics().trackEventValue("presnipe", "fail", Integer.toString(bbe.getResult()));
        }
        UpdateBlocker.endBlocking();
        return presnipeResult;
    }

    public static String getSnipeResult(int snipeResult, String aucTitle, AuctionEntry aeFire) {
        String snipeOutput;
        if (snipeResult == 4 || snipeResult == 5) {
            snipeOutput = "Successfully sniped a high bid on " + aucTitle + '!';
            JConfig.increment("stats.sniped.success");
        } else {
            switch (snipeResult) {
                case -1: {
                    snipeOutput = "Unknown error sniping on " + aucTitle + " (" + aeFire.getIdentifier() + ")";
                    JConfig.increment("stats.sniped.unknown_error");
                    break;
                }
                case 1: 
                case 9: {
                    snipeOutput = "Snipe apparently failed, as the auction cannot be bid on anymore: " + aucTitle;
                    JConfig.increment("stats.sniped.too_late");
                    break;
                }
                case 10: {
                    snipeOutput = "Snipe failed, as you are disallowed from bidding on " + aeFire.getSellerName() + "'s items.";
                    JConfig.increment("stats.sniped.banned");
                    break;
                }
                case 8: {
                    snipeOutput = "Snipe was too low, and was not accepted.";
                    JConfig.increment("stats.sniped.too_low");
                    break;
                }
                case 13: {
                    snipeOutput = "Your bid was below or equal to your previous high bid, and was not accepted.";
                    JConfig.increment("stats.sniped.too_low");
                    break;
                }
                case 11: {
                    snipeOutput = "Your snipe was successful, but it did not meet the reserve price.";
                    JConfig.increment("stats.sniped.too_low");
                    break;
                }
                case 2: {
                    snipeOutput = "There is an error with the amount for the snipe on " + aucTitle + " (Probably snipe too low vs. current bids).";
                    JConfig.increment("stats.sniped.too_low");
                    break;
                }
                case 3: {
                    snipeOutput = "You have been outbid in your snipe on " + aucTitle;
                    JConfig.increment("stats.sniped.outbid");
                    break;
                }
                case 12: {
                    snipeOutput = "Snipe failed due to connection problem.  Probably a timeout trying to reach eBay.";
                    JConfig.increment("stats.sniped.connection_error");
                    break;
                }
                case 14: {
                    snipeOutput = "Your snipe failed because the item was removed from JBidwatcher before the bid executed.";
                    JConfig.increment("stats.sniped.removed");
                    break;
                }
                case 17: {
                    snipeOutput = "You cannot interact with any auctions, your account has been suspended.";
                    JConfig.increment("stats.sniped.suspended");
                    break;
                }
                case 18: {
                    snipeOutput = "Sign in failed repeatedly during bid.  Check your username and password information in the Configuration Manager.";
                    JConfig.increment("stats.sniped.sign_in");
                    break;
                }
                case 19: {
                    snipeOutput = "You are registered in a country to which the seller doesn't ship.";
                    JConfig.increment("stats.sniped.wont_ship");
                    break;
                }
                case 20: {
                    snipeOutput = "You don't meet some requirement the seller has set for the item.  Check the item details for more information.";
                    JConfig.increment("stats.sniped.requirement_not_met");
                    break;
                }
                case 21: {
                    snipeOutput = "Sellers are not allowed to bid on their own items.";
                    break;
                }
                case 7: {
                    snipeOutput = "There is a problem with the multisnipe, an earlier entry hasn't finished updating.  Trying again shortly.";
                    JConfig.increment("stats.sniped.multisnipe_problem");
                    break;
                }
                default: {
                    snipeOutput = "Something really bad happened, and I don't know what.";
                    JConfig.increment("stats.sniped.really_bad");
                }
            }
        }
        return snipeOutput;
    }

    public AuctionEntry getItem() {
        return this.mEntry;
    }
}

