/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.table;

import com.jbidwatcher.scripting.Scripting;
import com.jbidwatcher.util.config.JConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class TableColumnController {
    private static TableColumnController m_instance = new TableColumnController();
    public static final int ID = 0;
    public static final int CUR_BID = 1;
    public static final int SNIPE_OR_MAX = 2;
    public static final int TIME_LEFT = 3;
    public static final int TITLE = 4;
    public static final int STATUS = 5;
    public static final int SELLER = 6;
    public static final int SHIPPING_INSURANCE = 7;
    public static final int BIDDER = 8;
    public static final int MAX = 9;
    public static final int SNIPE = 10;
    public static final int COMMENT = 11;
    public static final int END_DATE = 12;
    public static final int FIXED_PRICE = 13;
    public static final int SELLER_FEEDBACK = 14;
    public static final int SELLER_POSITIVE_FEEDBACK = 15;
    public static final int ITEM_LOCATION = 16;
    public static final int BIDCOUNT = 17;
    public static final int JUSTPRICE = 18;
    public static final int CUR_TOTAL = 19;
    public static final int SNIPE_TOTAL = 20;
    public static final int THUMBNAIL = 21;
    public static final int MAX_FIXED_COLUMN = 21;
    private static int columnCount = 22;
    private static Map<Integer, String> m_column_map;

    public static int columnCount() {
        return columnCount;
    }

    private TableColumnController() {
        m_column_map = new HashMap<Integer, String>(columnCount * 3);
        m_column_map.put(0, "Number");
        m_column_map.put(1, "Current");
        m_column_map.put(2, "Max");
        m_column_map.put(3, "Time left");
        m_column_map.put(4, "Description");
        m_column_map.put(5, "Status");
        m_column_map.put(6, "Seller");
        m_column_map.put(7, "Shipping");
        m_column_map.put(8, "High Bidder");
        m_column_map.put(9, "Max Bid");
        m_column_map.put(10, "Snipe Bid");
        m_column_map.put(11, "Comment");
        m_column_map.put(12, "End Date");
        m_column_map.put(13, "Buy Price");
        m_column_map.put(14, "Feedback");
        m_column_map.put(15, "Feedback %");
        m_column_map.put(16, "Location");
        m_column_map.put(17, "# of bids");
        m_column_map.put(18, "Price");
        m_column_map.put(19, "Total");
        m_column_map.put(20, "Snipe Max");
        m_column_map.put(21, "Thumbnail");
    }

    public static TableColumnController getInstance() {
        return m_instance;
    }

    public String getColumnName(int index) {
        return m_column_map.get(index);
    }

    public int getColumnNumber(String colName) {
        if (colName.equals("Ended at")) {
            colName = "End Date";
        }
        for (Map.Entry<Integer, String> entry : m_column_map.entrySet()) {
            if (!entry.getValue().equals(colName)) continue;
            return entry.getKey();
        }
        return -1;
    }

    public Collection<String> getColumnNames() {
        return m_column_map.values();
    }

    public void addColumn(String name) {
        m_column_map.put(columnCount++, name);
    }

    public String customColumn(int j, Object auctionEntry) {
        if (JConfig.scriptingEnabled()) {
            return (String)Scripting.rubyMethod("custom_column", this.getColumnName(j), auctionEntry);
        }
        return "";
    }
}

