/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util;

import com.jbidwatcher.util.config.JConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;

public class ByteBuffer {
    private byte[] data;
    private int length;
    private CRC32 crcCalc = new CRC32();
    private int crc;

    public ByteBuffer(byte[] inData, int inLength) {
        this.data = inData;
        this.length = inLength;
        this.crcCalc.reset();
        this.crcCalc.update(this.data);
        this.crc = (int)this.crcCalc.getValue();
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getCRC() {
        return this.crc;
    }

    public void save(String fileName) {
        File fp = new File(fileName);
        if (fp.exists()) {
            File oldFP = new File(fileName + "~");
            if (oldFP.exists()) {
                oldFP.delete();
            }
            fp.renameTo(oldFP);
        }
        try {
            FileOutputStream fos = new FileOutputStream(fp);
            fos.write(this.data, 0, this.length);
            fos.close();
        }
        catch (IOException ioe) {
            JConfig.log().handleException("Error writing " + fileName, ioe);
        }
    }
}

