/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util.html;

import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.html.CleanupHandler;
import com.jbidwatcher.util.html.JHTMLListener;
import com.jbidwatcher.util.html.JHTMLParser;
import com.jbidwatcher.util.html.htmlToken;
import com.jbidwatcher.util.http.Http;
import com.jbidwatcher.util.xml.XMLElement;
import com.jbidwatcher.util.xml.XMLInterface;
import com.jbidwatcher.util.xml.XMLParseException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JHTML
implements JHTMLListener {
    protected boolean m_loaded = false;
    protected int m_tokenIndex;
    protected int m_contentIndex;
    private JHTMLParser m_parser;
    private Map<String, intPair> contentMap;
    private Map<String, intPair> caselessContentMap;
    private List<String> contentList;
    private List<Form> m_formList;
    private Form m_curForm;
    private static boolean do_uber_debug = false;
    private String mCharset;
    private static Pattern urlMatcher = Pattern.compile("(?i)href=\"([^\"#]*)");
    private static final boolean CHECK_CASE = false;

    public JHTML(StringBuffer strBuf) {
        this.setup();
        this.m_parser = new JHTMLParser(strBuf, this);
    }

    private void setup() {
        this.caselessContentMap = new HashMap<String, intPair>();
        this.contentMap = new HashMap<String, intPair>();
        this.contentList = new ArrayList<String>();
        this.m_formList = new ArrayList<Form>();
        this.m_curForm = null;
        this.reset();
    }

    public void reset() {
        this.m_tokenIndex = 0;
        this.m_contentIndex = 0;
    }

    public Map<String, String> extractMicroformat() {
        htmlToken tok;
        XMLElement xe = new XMLElement();
        String currentProperty = null;
        HashMap<String, String> rval = new HashMap<String, String>();
        int balance = 0;
        String currentContent = null;
        while ((tok = this.nextToken()) != null) {
            int type = tok.getTokenType();
            if (currentProperty != null) {
                if (type == 1) {
                    ++balance;
                }
                if (type == 2 && --balance == 0) {
                    if (rval.get(currentProperty) == null || ((String)rval.get(currentProperty)).length() == 0 || currentContent.length() != 0) {
                        rval.put(currentProperty, currentContent);
                    }
                    currentProperty = null;
                }
            }
            if (type == 1 || type == 3) {
                if (tok.getToken().startsWith("!")) continue;
                try {
                    xe.reset();
                    xe.parseString("<" + tok.getToken() + "/>");
                }
                catch (XMLParseException xpe) {
                    JConfig.log().logVerboseDebug("eBay's HTML still sucks.");
                    continue;
                }
                String itemprop = xe.getProperty("itemprop");
                if (itemprop != null) {
                    String content = xe.getProperty("content");
                    if (content != null) {
                        if (rval.get(itemprop) != null && ((String)rval.get(itemprop)).length() != 0 && content.length() == 0) continue;
                        rval.put(itemprop, content);
                        continue;
                    }
                    currentProperty = itemprop;
                    currentContent = "";
                    balance = 1;
                    continue;
                }
                if (!xe.getTagName().equals("meta")) continue;
                String property = xe.getProperty("property");
                String content = xe.getProperty("content");
                if (property != null && property.startsWith("og:")) {
                    itemprop = property.substring(3);
                    if (rval.get(itemprop) != null && ((String)rval.get(itemprop)).length() != 0 && content.length() == 0) continue;
                    rval.put(itemprop, content);
                    continue;
                }
                String name = xe.getProperty("name");
                if (name == null || !name.equals("twitter:text:price")) continue;
                rval.put("price", content);
                continue;
            }
            if (type != 4 || currentProperty == null) continue;
            if (currentContent.length() != 0) {
                currentContent = currentContent + " ";
            }
            currentContent = currentContent + tok.toString();
        }
        return rval;
    }

    public List<Form> getForms() {
        return this.m_formList;
    }

    @Override
    public void addToken(htmlToken newToken, int contentIndex) {
        if (newToken.getTokenType() == 4) {
            if (newToken.getToken().length() == 1 && !Character.isDigit(newToken.getToken().charAt(0))) {
                return;
            }
            intPair pair = new intPair(contentIndex, this.contentList.size());
            if (!this.contentMap.containsKey(newToken.getToken())) {
                this.contentMap.put(newToken.getToken(), pair);
                this.caselessContentMap.put(newToken.getToken().toLowerCase(), pair);
            }
            this.contentList.add(newToken.getToken());
        } else if (newToken.getTokenType() == 1 || newToken.getTokenType() == 2 || newToken.getTokenType() == 3) {
            this.handleForms(newToken);
            if (newToken.getToken().toLowerCase().startsWith("meta")) {
                this.checkDocumentType(newToken.getToken(), "ISO-8859-1");
                this.checkDocumentType(newToken.getToken(), "UTF-8");
            }
        }
    }

    public String getCharset() {
        return this.mCharset;
    }

    private void checkDocumentType(String meta, String type) {
        if (meta.contains(type)) {
            this.setCharset(type);
        }
    }

    private void handleForms(htmlToken newToken) {
        if (newToken.getToken().toLowerCase().startsWith("form")) {
            if (this.m_curForm != null) {
                this.m_formList.add(this.m_curForm);
                this.m_curForm = null;
            }
            try {
                this.m_curForm = new Form(newToken.getToken());
            }
            catch (XMLParseException parseException) {
                JConfig.log().logDebug("Form parsing failure: " + parseException);
            }
        } else if (newToken.getToken().toLowerCase().startsWith("/form")) {
            if (this.m_curForm != null) {
                this.m_formList.add(this.m_curForm);
            }
            this.m_curForm = null;
        }
        if (this.m_curForm != null && (newToken.getToken().regionMatches(true, 0, "input", 0, 5) || newToken.getToken().regionMatches(true, 0, "button", 0, 6))) {
            this.m_curForm.addInput(newToken.getToken());
        }
    }

    public static String getFirstContent(String toSearch) {
        JHTML parser = new JHTML(new StringBuffer(toSearch));
        return parser.contentList.get(0);
    }

    public String getTitle() {
        this.reset();
        String tagWalk = this.getNextTag();
        while (tagWalk != null && !"title".equalsIgnoreCase(tagWalk)) {
            tagWalk = this.getNextTag();
        }
        if (tagWalk == null) {
            return null;
        }
        htmlToken t = this.nextToken();
        while (t != null && t.getTokenType() != 4) {
            t = this.nextToken();
        }
        return t == null ? null : t.getToken();
    }

    public String getNextContent() {
        if (this.m_contentIndex + 1 >= this.contentList.size()) {
            return null;
        }
        return this.contentList.get(this.m_contentIndex++);
    }

    public String getPrevContent() {
        if (this.m_contentIndex == 0) {
            return null;
        }
        return this.contentList.get(--this.m_contentIndex);
    }

    public String getPrevContent(int farBack) {
        if (farBack > this.m_contentIndex) {
            this.m_contentIndex = 0;
            return null;
        }
        this.m_contentIndex -= farBack;
        return this.contentList.get(this.m_contentIndex);
    }

    public Object lookup(String hunt, boolean caseless) {
        intPair at = caseless ? this.caselessContentMap.get(hunt.toLowerCase()) : this.contentMap.get(hunt);
        return at;
    }

    private String contentLookup(String hunt, boolean caseless) {
        intPair at = (intPair)this.lookup(hunt, caseless);
        if (at == null) {
            return null;
        }
        this.m_tokenIndex = at.getFirst() + 2;
        this.m_contentIndex = at.getSecond() + 1;
        return this.contentList.get(this.m_contentIndex++);
    }

    public String find(String hunt, boolean ignoreCase) {
        for (String nextContent : this.contentList) {
            if (!nextContent.regionMatches(ignoreCase, 0, hunt, 0, hunt.length())) continue;
            return nextContent;
        }
        return null;
    }

    private String contentFind(String hunt, boolean ignoreCase) {
        String nextContent = this.find(hunt, ignoreCase);
        if (nextContent != null) {
            nextContent = this.contentLookup(nextContent, false);
        }
        return nextContent;
    }

    public String grep(String match) {
        Pattern matchPat = Pattern.compile(match);
        for (String nextContent : this.contentList) {
            Matcher m = matchPat.matcher(nextContent);
            if (!m.matches()) continue;
            return nextContent;
        }
        return null;
    }

    public Matcher realGrep(String match) {
        Pattern matchPat = Pattern.compile(match);
        for (String nextContent : this.contentList) {
            Matcher m = matchPat.matcher(nextContent);
            if (!m.matches()) continue;
            return m;
        }
        return null;
    }

    private String grepAfter(String match, String ignore) {
        Pattern toMatch = Pattern.compile(match);
        Pattern toIgnore = ignore == null ? null : Pattern.compile(ignore);
        Iterator<String> it = this.contentList.iterator();
        while (it.hasNext()) {
            String contentStep = it.next();
            if (!toMatch.matcher(contentStep).matches()) continue;
            Iterator<String> save = it;
            if (it.hasNext()) {
                String potential = it.next();
                if (ignore == null || !toIgnore.matcher(potential).matches()) {
                    this.contentLookup(contentStep, false);
                    return potential;
                }
            }
            it = save;
        }
        return null;
    }

    private String contentGrep(String match, String ignore) {
        return this.grepAfter(match, ignore);
    }

    public String getNextContentAfterContent(String previousData) {
        return this.contentFind(previousData, false);
    }

    public String getContentBeforeContent(String followingData) {
        if (this.contentFind(followingData, false) != null && this.getPrevContent() != null && this.getPrevContent() != null) {
            return this.getPrevContent();
        }
        return null;
    }

    public String getNextContentAfterRegex(String match) {
        return this.contentGrep(match, null);
    }

    public String getNextContentAfterRegexIgnoring(String match, String ignore) {
        return this.contentGrep(match, ignore);
    }

    public boolean hasSequence(String ... sequence) {
        return sequence.length != 0 && this.findSequence(sequence) != null;
    }

    public SequenceResult findSequence(String ... originalSequence) {
        SequenceResult contentSequence = new SequenceResult();
        contentSequence.nextStartPoint = 0;
        Pattern[] inputPattern = new Pattern[originalSequence.length];
        int currentPattern = 0;
        for (String step : originalSequence) {
            inputPattern[currentPattern++] = Pattern.compile(step);
        }
        contentSequence.sequence = inputPattern;
        return this.findNextSequence(contentSequence);
    }

    public SequenceResult findNextSequence(SequenceResult contentSequence) {
        int stepwise = contentSequence.nextStartPoint;
        Pattern[] inputPattern = contentSequence.sequence;
        List<String> toSearch = this.contentList.subList(stepwise, this.contentList.size());
        int index = 0;
        for (String contentStep : toSearch) {
            ++stepwise;
            if (inputPattern[index].matcher(contentStep).matches()) {
                contentSequence.add(contentStep);
                if (++index != inputPattern.length) continue;
                contentSequence.nextStartPoint = stepwise;
                return contentSequence;
            }
            contentSequence.clear();
            index = 0;
        }
        return null;
    }

    public String getNextTag() {
        htmlToken returnToken = this.nextToken();
        if (returnToken != null) {
            while (returnToken != null && returnToken.getTokenType() == 4 && returnToken.getTokenType() != 5) {
                returnToken = this.nextToken();
            }
            if (returnToken != null && returnToken.getTokenType() != 5) {
                return returnToken.getToken();
            }
        }
        return null;
    }

    public List<String> getAllLinks() {
        ArrayList<String> linkTags = null;
        String curTag = this.getNextTag();
        while (curTag != null) {
            if (curTag.startsWith("A ") || curTag.startsWith("a ")) {
                if (linkTags == null) {
                    linkTags = new ArrayList<String>();
                }
                linkTags.add(curTag);
            }
            curTag = this.getNextTag();
        }
        return linkTags;
    }

    public String getLinkForContent(String searchContent) {
        this.reset();
        String lastTag = null;
        htmlToken curToken = this.nextToken();
        while (curToken != null) {
            switch (curToken.getTokenType()) {
                case 1: {
                    String tag = curToken.getToken();
                    if (!tag.regionMatches(true, 0, "a ", 0, 2)) break;
                    lastTag = tag;
                    break;
                }
                case 2: {
                    String tag = curToken.getToken();
                    if (tag.equalsIgnoreCase("/a")) {
                        lastTag = null;
                    }
                }
                case 4: {
                    Matcher result;
                    String content = curToken.getToken();
                    if (lastTag == null || !searchContent.equals(content) || !(result = urlMatcher.matcher(lastTag)).find()) break;
                    return result.group(1);
                }
            }
            curToken = this.nextToken();
        }
        return null;
    }

    public List<String> getAllImages() {
        HashSet<String> imgUrls = new HashSet<String>();
        String curTag = this.getNextTag();
        while (curTag != null) {
            if (curTag.toLowerCase().startsWith("img ")) {
                imgUrls.add(JHTML.deAmpersand(curTag).replaceAll(".*img.*src=\"(.*?)\".*", "$1"));
            }
            curTag = this.getNextTag();
        }
        return new ArrayList<String>(imgUrls);
    }

    public List<String> getAllURLsOnPage(boolean viewOnly) {
        List<String> addressTags = this.getAllLinks();
        if (addressTags == null) {
            return null;
        }
        ArrayList<String> outEntries = null;
        for (String curTag : addressTags) {
            Matcher result = urlMatcher.matcher(curTag);
            if (!result.find()) continue;
            String href = result.group(1);
            boolean isView = false;
            if (viewOnly) {
                boolean bl = isView = href.matches("^https?://[a-z]+.ebay.[a-z.]+/(?:itm/)?[A-Za-z0-9-]+/[0-9]+(\\?.*)?") || href.indexOf("ViewItem") != -1;
                if (isView) {
                    href = JHTML.deAmpersand(href);
                }
            }
            if (viewOnly && !isView) continue;
            if (outEntries == null) {
                outEntries = new ArrayList<String>();
            }
            outEntries.add(href);
        }
        return outEntries;
    }

    public static String deAmpersand(String href) {
        int searchIndex = href.indexOf("&amp;");
        while (searchIndex != -1) {
            href = href.substring(0, searchIndex + 1) + href.substring(searchIndex + 5);
            searchIndex = href.indexOf("&amp;");
        }
        return href;
    }

    public htmlToken nextToken() {
        htmlToken rval;
        if ((rval = this.m_parser.getTokenAt(this.m_tokenIndex++)) == null) {
            --this.m_tokenIndex;
        }
        return rval;
    }

    public boolean isLoaded() {
        return this.m_loaded;
    }

    private void loadParseURL(String newURL, String cookie, CleanupHandler cl) {
        StringBuffer loadedPage;
        this.m_parser = new JHTMLParser(this);
        try {
            URLConnection uc = Http.net().getPage(newURL, cookie, null, true);
            loadedPage = Http.net().receivePage(uc);
            if (loadedPage != null) {
                if (cl != null) {
                    cl.cleanup(loadedPage);
                }
                this.m_parser.parse(loadedPage);
                this.m_loaded = true;
            }
        }
        catch (IOException e) {
            loadedPage = null;
            JConfig.log().handleException("JHTML.loadPage: (" + newURL + ") " + e, e);
        }
        if (loadedPage == null) {
            this.m_loaded = false;
        }
    }

    public JHTML(String newURL, String cookie, CleanupHandler cl) {
        this.setup();
        this.loadParseURL(newURL, cookie, cl);
    }

    public Form getFormWithInput(String input) {
        List<Form> forms = this.getForms();
        for (Form curForm : forms) {
            if (!curForm.hasInput(input)) continue;
            return curForm;
        }
        return null;
    }

    public void setCharset(String charset) {
        this.mCharset = charset;
    }

    private boolean isToken(htmlToken tok, int tokenType, String tag) {
        return tok.getTokenType() == tokenType && tok.getToken().regionMatches(true, 0, tag, 0, tag.length());
    }

    public List<Table> extractTables() {
        ArrayList<Table> tableContents = new ArrayList<Table>(1);
        htmlToken tok = this.nextToken();
        while (tok != null) {
            if (this.isToken(tok, 1, "table")) {
                tableContents.add(this.extractTable(tableContents));
            }
            tok = this.nextToken();
        }
        return tableContents;
    }

    public Table extractTable(List<Table> tableContents) {
        ArrayList<htmlToken> currentTable = new ArrayList<htmlToken>();
        Table currentTableContents = new Table();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<ArrayList<htmlToken>> tableList = new ArrayList<ArrayList<htmlToken>>(1);
        tableList.add(currentTable);
        htmlToken tok = this.nextToken();
        String curHdr = null;
        while (!this.isToken(tok, 2, "/table")) {
            if (this.isToken(tok, 1, "table")) {
                tableContents.add(this.extractTable(tableContents));
            } else {
                if (this.isToken(tok, 2, "/tr")) {
                    boolean first = true;
                    ArrayList<String> curRow = null;
                    for (String hdr : headers) {
                        if (first) {
                            curRow = new ArrayList<String>(headers.size());
                            first = false;
                        }
                        curRow.add(hdr);
                    }
                    if (!headers.isEmpty()) {
                        currentTableContents.addRow(curRow);
                    }
                    headers = new ArrayList();
                } else if (this.isToken(tok, 1, "td") || this.isToken(tok, 1, "th")) {
                    curHdr = "";
                } else if (this.isToken(tok, 2, "/td") || this.isToken(tok, 2, "/th")) {
                    if (curHdr != null && curHdr.length() != 0) {
                        headers.add(curHdr);
                    }
                    curHdr = null;
                }
                if (tok.getTokenType() == 4 && curHdr != null) {
                    if (curHdr.length() != 0) {
                        curHdr = curHdr + ' ';
                    }
                    curHdr = curHdr + tok.getToken();
                }
                currentTable.add(tok);
            }
            tok = this.nextToken();
        }
        return currentTableContents;
    }

    public class Table {
        private List<List<String>> data = new ArrayList<List<String>>();

        public void addRow(List<String> newRow) {
            this.data.add(newRow);
        }

        public String getCell(int col, int row) {
            return this.data.get(row).get(col);
        }

        public List<String> getRow(int row) {
            return this.data.get(row);
        }

        public boolean rowCellMatches(int row, String regexp) {
            if (this.data.size() == 0) {
                return false;
            }
            for (String cell : this.data.get(row)) {
                if (!cell.matches(regexp)) continue;
                return true;
            }
            return false;
        }

        public int getRowCount() {
            return this.data.size();
        }
    }

    public class SequenceResult
    extends LinkedList<String> {
        Pattern[] sequence;
        int nextStartPoint;

        public int getNextStartPoint() {
            return this.nextStartPoint;
        }
    }

    public static class Form {
        private List<XMLInterface> mAllInputs;
        private XMLElement formTag = new XMLElement();
        private static final String FORM_VALUE = "value";
        private static final String FORM_SUBMIT = "submit";
        private static final String FORM_CHECKBOX = "checkbox";
        public static final String FORM_PASSWORD = "password";
        private static final String FORM_HIDDEN = "hidden";
        private static final String FORM_RADIO = "radio";

        public Form(String initialTag) {
            this.formTag.parseString('<' + initialTag + "/>");
            this.mAllInputs = new ArrayList<XMLInterface>();
            if (do_uber_debug) {
                JConfig.log().logDebug("Name: " + this.formTag.getProperty("name", "(unnamed)"));
            }
        }

        public String getName() {
            return this.formTag.getProperty("name");
        }

        public boolean hasInput(String srchFor) {
            return this.hasInput(srchFor, null);
        }

        public boolean hasInput(String srchFor, String value) {
            for (XMLInterface curInput : this.mAllInputs) {
                String name = curInput.getProperty("name");
                if (name == null || !srchFor.equalsIgnoreCase(name) || value != null && !curInput.getProperty(FORM_VALUE).equalsIgnoreCase(value)) continue;
                return true;
            }
            return false;
        }

        public boolean delInput(String srchFor) {
            Iterator<XMLInterface> it = this.mAllInputs.iterator();
            while (it.hasNext()) {
                XMLInterface curInput = it.next();
                String name = curInput.getProperty("name");
                if (name == null || !srchFor.equalsIgnoreCase(name)) continue;
                it.remove();
                return true;
            }
            return false;
        }

        public String getCGI() throws UnsupportedEncodingException {
            String action = this.getAction();
            String rval = this.getFormData();
            if (action != null) {
                rval = action.indexOf(63) == -1 ? action + '?' + rval : action + '&' + rval;
            }
            return rval;
        }

        public String getFormData() throws UnsupportedEncodingException {
            Iterator<XMLInterface> it = this.mAllInputs.iterator();
            StringBuffer rval = new StringBuffer("");
            String seperator = "";
            while (it.hasNext()) {
                String value;
                XMLElement curInput = (XMLElement)it.next();
                if (do_uber_debug) {
                    JConfig.log().logDebug("Type == " + curInput.getProperty("type", "text"));
                }
                if (rval.length() != 0) {
                    seperator = "&";
                }
                String type = curInput.getProperty("type", "text");
                String name = curInput.getProperty("name", "");
                if (type.equals("text") || type.equalsIgnoreCase(FORM_HIDDEN) || type.equals(FORM_PASSWORD)) {
                    rval.append(seperator).append(name).append('=').append(URLEncoder.encode(curInput.getProperty(FORM_VALUE, ""), "UTF-8"));
                    continue;
                }
                if (type.equals(FORM_CHECKBOX) || type.equals(FORM_RADIO)) {
                    if (curInput.getProperty("checked") == null) continue;
                    rval.append(seperator).append(name).append('=').append(URLEncoder.encode(curInput.getProperty(FORM_VALUE, "on"), "UTF-8"));
                    continue;
                }
                if (!type.equals(FORM_SUBMIT) || name.length() == 0 || (value = curInput.getProperty(FORM_VALUE, "Submit")).equalsIgnoreCase("cancel")) continue;
                rval.append(seperator).append(name).append('=').append(URLEncoder.encode(value, "UTF-8"));
            }
            return rval.toString();
        }

        public String getAction() {
            return this.formTag.getProperty("action");
        }

        private String createProperty(String property, XMLInterface tag, String defValue) {
            String value = tag.getProperty(property);
            if (value != null) {
                return property + "=\"" + value + "\" ";
            }
            return defValue;
        }

        public void addInput(String newTag) {
            boolean isError;
            XMLElement inputTag = new XMLElement();
            try {
                inputTag.parseString('<' + newTag + "/>");
            }
            catch (XMLParseException e) {
                if (XMLElement.rejectingBadHTML()) {
                    throw e;
                }
                JConfig.log().handleException("Bad input tag", e);
                return;
            }
            String inputType = inputTag.getProperty("type", "text").toLowerCase();
            if (inputTag.getTagName().equals("button")) {
                XMLElement tempTag = new XMLElement();
                String name = this.createProperty("name", inputTag, "");
                String value = this.createProperty(FORM_VALUE, inputTag, "");
                String type = this.createProperty("type", inputTag, "button");
                tempTag.parseString("<input " + type + name + value + "/>");
                inputType = tempTag.getProperty("type");
                inputTag = tempTag;
            }
            boolean showInputs = JConfig.queryConfiguration("debug.showInputs", "false").equals("true");
            boolean bl = isError = inputType == null;
            if (!isError) {
                if (inputType.equals("text")) {
                    if (showInputs) {
                        JConfig.log().logDebug("T: Name: " + inputTag.getProperty("name") + ", Value: " + inputTag.getProperty(FORM_VALUE));
                    }
                } else if (inputType.equals(FORM_PASSWORD)) {
                    if (showInputs) {
                        JConfig.log().logDebug("P: Name: " + inputTag.getProperty("name") + ", Value: " + inputTag.getProperty(FORM_VALUE));
                    }
                } else if (inputType.equalsIgnoreCase(FORM_HIDDEN) || inputType.equalsIgnoreCase("'hidden'")) {
                    if (showInputs) {
                        JConfig.log().logDebug("H: Name: " + inputTag.getProperty("name") + ", Value: " + inputTag.getProperty(FORM_VALUE));
                    }
                } else if (inputType.equals(FORM_CHECKBOX)) {
                    if (showInputs) {
                        JConfig.log().logDebug("CB: Name: " + inputTag.getProperty("name") + ", Value: " + inputTag.getProperty(FORM_VALUE));
                    }
                } else if (inputType.equals(FORM_RADIO)) {
                    if (showInputs) {
                        JConfig.log().logDebug("R: Name: " + inputTag.getProperty("name") + ", Value: " + inputTag.getProperty(FORM_VALUE));
                    }
                } else if (inputType.equals(FORM_SUBMIT)) {
                    if (showInputs) {
                        JConfig.log().logDebug("S: Name: " + inputTag.getProperty("name") + ", Value: " + inputTag.getProperty(FORM_VALUE));
                    }
                } else if (inputType.equals("image")) {
                    if (showInputs) {
                        JConfig.log().logDebug("I: Name: " + inputTag.getProperty("name") + ", Value: " + inputTag.getProperty(FORM_VALUE));
                    }
                } else if (inputType.equals("button")) {
                    if (showInputs) {
                        JConfig.log().logDebug("B: Name: " + inputTag.getProperty("name") + ", Value: " + inputTag.getProperty(FORM_VALUE));
                    }
                } else if (inputType.equals("reset")) {
                    if (showInputs) {
                        JConfig.log().logDebug("RST: Name: " + inputTag.getProperty("name") + ", Value: " + inputTag.getProperty(FORM_VALUE));
                    }
                } else if (inputType.equals("file")) {
                    if (showInputs) {
                        JConfig.log().logDebug("File: Name: " + inputTag.getProperty("name"));
                    }
                } else {
                    JConfig.log().logDebug("Unknown input type: " + inputType);
                    isError = true;
                }
            } else {
                JConfig.log().logDebug("Bad input tag (ignoring): " + newTag);
            }
            if (!isError) {
                this.mAllInputs.add(inputTag);
            }
        }

        public void setText(String key, String val) {
            for (XMLInterface curInput : this.mAllInputs) {
                String name = curInput.getProperty("name");
                if (name == null || !name.equalsIgnoreCase(key)) continue;
                curInput.setProperty(FORM_VALUE, val);
            }
        }

        public String getInputValue(String inputName) {
            for (XMLInterface input : this.mAllInputs) {
                String name = input.getProperty("name");
                if (name == null || !name.equals(inputName) || input.getProperty(FORM_VALUE) == null) continue;
                return input.getProperty(FORM_VALUE);
            }
            return null;
        }

        public Map<String, Object> getCGIMap() {
            LinkedHashMap<String, Object> rval = new LinkedHashMap<String, Object>();
            for (XMLInterface input : this.mAllInputs) {
                String name = input.getProperty("name");
                String value = input.getProperty(FORM_VALUE);
                rval.put(name, value);
            }
            return rval;
        }
    }

    private static class intPair {
        private int first;
        private int second;

        public intPair(int f, int s) {
            this.first = f;
            this.second = s;
        }

        public int getFirst() {
            return this.first;
        }

        public int getSecond() {
            return this.second;
        }
    }
}

