/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jbidwatcher.auction.EntryCorral;
import com.jbidwatcher.auction.MultiSnipe;
import com.jbidwatcher.util.HashBacked;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;

@Singleton
public class MultiSnipeManager {
    private final EntryCorral entryCorral;

    @Inject
    private MultiSnipeManager(EntryCorral corral) {
        this.entryCorral = corral;
        MQFactory.getConcrete("won").addListener(new MessageQueue.Listener(){

            @Override
            public void messageAction(Object deQ) {
                MultiSnipe ms = MultiSnipeManager.this.getForAuctionIdentifier((String)deQ);
                if (ms != null) {
                    ms.setWonAuction();
                }
            }
        });
        MQFactory.getConcrete("notwon").addListener(new MessageQueue.Listener(){

            @Override
            public void messageAction(Object deQ) {
                MultiSnipe ms = MultiSnipeManager.this.getForAuctionIdentifier((String)deQ);
                if (ms != null) {
                    ms.remove((String)deQ);
                }
            }
        });
    }

    public MultiSnipe addAuctionToMultisnipe(String identifier, MultiSnipe ms) {
        MultiSnipe old = this.getForAuctionIdentifier(identifier);
        if (old != null) {
            if (old.equals(ms)) {
                return null;
            }
            old.remove(identifier);
        }
        ms.add(identifier);
        return old;
    }

    public MultiSnipe getForAuctionIdentifier(String identifier) {
        Object hash = this.entryCorral.takeForRead(identifier);
        Integer multisnipeId = ((HashBacked)hash).getInteger("multisnipe_id");
        return multisnipeId == null ? null : MultiSnipe.find(multisnipeId);
    }
}

