/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction;

import com.jbidwatcher.util.db.ActiveRecord;
import com.jbidwatcher.util.db.Table;
import java.text.NumberFormat;

public class Seller
extends ActiveRecord {
    private static NumberFormat decimalPercentage = null;
    private static Table sDB = null;

    public String getSeller() {
        return this.getString("seller");
    }

    private void setSeller(String name) {
        this.setString("seller", name);
    }

    public String getPositivePercentage() {
        String feedbackPercent;
        if (decimalPercentage == null) {
            decimalPercentage = NumberFormat.getPercentInstance();
            decimalPercentage.setMinimumFractionDigits(1);
            decimalPercentage.setMaximumFractionDigits(1);
        }
        if ((feedbackPercent = this.getString("feedback_percentage")) != null) {
            Double x = Double.parseDouble(feedbackPercent);
            return decimalPercentage.format(x / 100.0);
        }
        return "n/a";
    }

    public void setPositivePercentage(String positivePercentage) {
        this.setString("feedback_percentage", positivePercentage.replaceAll(",", ".").replaceFirst("%", ""));
        this.saveDB();
    }

    public int getFeedback() {
        return this.getInteger("feedback", 0);
    }

    public void setFeedback(int feedback) {
        this.setInteger("feedback", feedback);
        this.saveDB();
    }

    public static Seller makeSeller(String sellerName) {
        if (sellerName == null) {
            return null;
        }
        Seller existing_seller = Seller.findFirstBy("seller", sellerName);
        if (existing_seller == null) {
            existing_seller = new Seller();
            existing_seller.setSeller(sellerName);
            existing_seller.saveDB();
        }
        return existing_seller;
    }

    public Seller makeSeller(String sellerName, Seller oldSeller) {
        Seller rval = Seller.makeSeller(sellerName);
        rval.setFeedback(oldSeller.getFeedback());
        rval.setPositivePercentage(oldSeller.getString("feedback_percentage"));
        rval.saveDB();
        return rval;
    }

    protected static String getTableName() {
        return "sellers";
    }

    @Override
    protected Table getDatabase() {
        if (sDB == null) {
            sDB = Seller.openDB(Seller.getTableName());
        }
        return sDB;
    }

    public static Seller findFirstBy(String key, String value) {
        return (Seller)ActiveRecord.findFirstBy(Seller.class, key, value);
    }
}

