/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.util;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public abstract class BasicDialog
extends JDialog {
    private boolean cancelled = false;
    private JPanel basicContentPane;
    private JButton buttonOK;
    private JButton buttonCancel;

    public BasicDialog(Frame frame, String s, boolean b, GraphicsConfiguration currentGraphicsConfiguration) {
        super(frame, s, b, currentGraphicsConfiguration);
        this.establishBasicUI();
    }

    public BasicDialog() {
        this.establishBasicUI();
    }

    private void establishBasicUI() {
        this.buttonOK = new JButton();
        this.buttonOK.setText("OK");
        this.buttonCancel = new JButton();
        this.buttonCancel.setText("Cancel");
    }

    protected void addBehavior() {
        this.setContentPane(this.getBasicContentPane());
        this.setLocationRelativeTo(null);
        this.getRootPane().setDefaultButton(this.getButtonOK());
        this.getButtonOK().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicDialog.this.cancelled = false;
                BasicDialog.this.onOK();
            }
        });
        this.getButtonCancel().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicDialog.this.cancelled = true;
                BasicDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BasicDialog.this.cancelled = true;
                BasicDialog.this.onCancel();
            }
        });
        this.getBasicContentPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicDialog.this.cancelled = true;
                BasicDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    protected abstract void onOK();

    protected abstract void onCancel();

    protected JButton getButtonOK() {
        return this.buttonOK;
    }

    protected void setButtonOK(JButton ok) {
        this.buttonOK = ok;
    }

    protected JButton getButtonCancel() {
        return this.buttonCancel;
    }

    protected void setButtonCancel(JButton cancel) {
        this.buttonCancel = cancel;
    }

    public JPanel getBasicContentPane() {
        if (this.basicContentPane == null) {
            this.basicContentPane = new JPanel(new BorderLayout());
        }
        return this.basicContentPane;
    }

    public void setBasicContentPane(JPanel contentPane) {
        this.basicContentPane = contentPane;
    }
}

