/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util;

import com.jbidwatcher.util.config.JConfig;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class IconFactory {
    private static Map<ImageIcon, Map<Object, ImageIcon>> _icons = new HashMap<ImageIcon, Map<Object, ImageIcon>>();

    public static ImageIcon getCombination(ImageIcon leftImage, ImageIcon rightImage) {
        if (leftImage == null) {
            return rightImage;
        }
        if (rightImage == null) {
            return leftImage;
        }
        Map<Object, ImageIcon> combos = _icons.get(leftImage);
        if (combos == null) {
            ImageIcon new_icon = IconFactory.appendIcons(leftImage, rightImage);
            combos = new HashMap<Object, ImageIcon>();
            combos.put(rightImage, new_icon);
            _icons.put(leftImage, combos);
            return new_icon;
        }
        ImageIcon old_icon = combos.get(rightImage);
        if (old_icon == null) {
            old_icon = IconFactory.appendIcons(leftImage, rightImage);
            combos.put(rightImage, old_icon);
            _icons.put(leftImage, combos);
        }
        return old_icon;
    }

    private static ImageIcon appendIcons(ImageIcon a, ImageIcon b) {
        int x = a.getIconWidth() + b.getIconWidth();
        int y = Math.max(a.getIconHeight(), b.getIconHeight());
        BufferedImage bi = a.getImage() instanceof BufferedImage ? new BufferedImage(x, y, ((BufferedImage)a.getImage()).getType()) : new BufferedImage(x, y, 6);
        Graphics ig = bi.getGraphics();
        ig.drawImage(a.getImage(), 0, 0, null);
        ig.drawImage(b.getImage(), a.getIconWidth(), 0, null);
        return new ImageIcon(bi);
    }

    private static BufferedImage createResizedCopy(Image originalImage, int scaledWidth, int scaledHeight) {
        BufferedImage scaledBI = new BufferedImage(scaledWidth, scaledHeight, 1);
        Graphics2D g = scaledBI.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setComposite(AlphaComposite.Src);
        g.drawImage(originalImage, 0, 0, scaledWidth, scaledHeight, null);
        g.dispose();
        return scaledBI;
    }

    public static boolean resizeImage(String inFile, String outFile, int maxAcceptableX, int scaleToX, int maxAcceptableY, int scaleToY) {
        BufferedImage image;
        File input = new File(inFile);
        if (!input.exists()) {
            return false;
        }
        try {
            image = ImageIO.read(input);
        }
        catch (IOException ioe) {
            JConfig.log().handleException("Can't read " + inFile + " to create thumbnail.", ioe);
            return false;
        }
        if (image == null) {
            return false;
        }
        int x = image.getWidth();
        int y = image.getHeight();
        int new_x = -1;
        int new_y = -1;
        if ((x > maxAcceptableX || y > maxAcceptableY) && (new_y = (new_x = scaleToX) * y / x) > maxAcceptableY) {
            new_y = scaleToY;
            new_x = new_y * x / y;
        }
        if (new_x == -1 || new_y == -1) {
            return false;
        }
        try {
            FileOutputStream fos = new FileOutputStream(outFile);
            ImageIO.write((RenderedImage)IconFactory.createResizedCopy(image, new_x, new_y), "jpeg", fos);
            fos.close();
        }
        catch (FileNotFoundException e) {
            JConfig.log().handleException("Can't write " + outFile + " to create thumbnail.", e);
            return false;
        }
        catch (IOException e) {
            JConfig.log().handleException("Can't generate image " + outFile + ".", e);
            return false;
        }
        return true;
    }
}

