/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.ForeignKeyConstraint;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.model.TableIndex;
import net.sourceforge.schemaspy.model.xml.ForeignKeyMeta;
import net.sourceforge.schemaspy.model.xml.TableColumnMeta;
import net.sourceforge.schemaspy.model.xml.TableMeta;
import net.sourceforge.schemaspy.util.CaseInsensitiveMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
implements Comparable<Table> {
    private final String schema;
    private final String name;
    protected final CaseInsensitiveMap<TableColumn> columns = new CaseInsensitiveMap();
    private final List<TableColumn> primaryKeys = new ArrayList<TableColumn>();
    private final CaseInsensitiveMap<ForeignKeyConstraint> foreignKeys = new CaseInsensitiveMap();
    private final CaseInsensitiveMap<TableIndex> indexes = new CaseInsensitiveMap();
    private Object id;
    private final Map<String, String> checkConstraints = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private Integer numRows;
    protected final Database db;
    protected final Properties properties;
    private String comments;
    private int maxChildren;
    private int maxParents;
    private static final Logger logger = Logger.getLogger(Table.class.getName());

    public Table(Database database, String string, String string2, String string3, Properties properties, Pattern pattern, Pattern pattern2) throws SQLException {
        this.schema = string;
        this.name = string2;
        this.db = database;
        this.properties = properties;
        logger.fine("Creating " + this.getClass().getSimpleName().toLowerCase() + " " + string == null ? string2 : string + '.' + string2);
        this.setComments(string3);
        this.initColumns(pattern, pattern2);
        this.initIndexes();
        this.initPrimaryKeys(database.getMetaData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectForeignKeys(Map<String, Table> map, Pattern pattern, Pattern pattern2) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = this.db.getMetaData().getImportedKeys(null, this.getSchema(), this.getName());
            while (resultSet.next()) {
                this.addForeignKey(resultSet.getString("FK_NAME"), resultSet.getString("FKCOLUMN_NAME"), resultSet.getString("PKTABLE_SCHEM"), resultSet.getString("PKTABLE_NAME"), resultSet.getString("PKCOLUMN_NAME"), resultSet.getInt("UPDATE_RULE"), resultSet.getInt("DELETE_RULE"), map, pattern, pattern2);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        if (this.getSchema() != null) {
            try {
                resultSet = this.db.getMetaData().getExportedKeys(null, this.getSchema(), this.getName());
                while (resultSet.next()) {
                    String string = resultSet.getString("FKTABLE_SCHEM");
                    if (this.getSchema().equals(string)) continue;
                    this.db.addRemoteTable(string, resultSet.getString("FKTABLE_NAME"), this.getSchema(), this.properties, pattern, pattern2);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    public Collection<ForeignKeyConstraint> getForeignKeys() {
        return Collections.unmodifiableCollection(this.foreignKeys.values());
    }

    public void addCheckConstraint(String string, String string2) {
        this.checkConstraints.put(string, string2);
    }

    protected void addForeignKey(String string, String string2, String string3, String string4, String string5, int n, int n2, Map<String, Table> map, Pattern pattern, Pattern pattern2) throws SQLException {
        TableColumn tableColumn;
        if (string == null) {
            return;
        }
        ForeignKeyConstraint foreignKeyConstraint = this.foreignKeys.get(string);
        if (foreignKeyConstraint == null) {
            foreignKeyConstraint = new ForeignKeyConstraint(this, string, n, n2);
            this.foreignKeys.put(string, foreignKeyConstraint);
        }
        if ((tableColumn = this.getColumn(string2)) != null) {
            foreignKeyConstraint.addChildColumn(tableColumn);
            Table table = map.get(string4);
            String string6 = string3;
            String string7 = Config.getInstance().getSchema();
            if (table == null || string7 != null && string6 != null && !string7.equals(string6)) {
                table = this.db.addRemoteTable(string6, string4, string7, this.properties, pattern, pattern2);
            }
            if (table != null) {
                TableColumn tableColumn2 = table.getColumn(string5);
                if (tableColumn2 != null) {
                    foreignKeyConstraint.addParentColumn(tableColumn2);
                    tableColumn.addParent(tableColumn2, foreignKeyConstraint);
                    tableColumn2.addChild(tableColumn, foreignKeyConstraint);
                } else {
                    logger.warning("Couldn't add FK '" + foreignKeyConstraint.getName() + "' to table '" + this + "' - Column '" + string5 + "' doesn't exist in table '" + table + "'");
                }
            } else {
                logger.warning("Couldn't add FK '" + foreignKeyConstraint.getName() + "' to table '" + this + "' - Unknown Referenced Table '" + string4 + "'");
            }
        } else {
            logger.warning("Couldn't add FK '" + foreignKeyConstraint.getName() + "' to table '" + this + "' - Column '" + string2 + "' doesn't exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPrimaryKeys(DatabaseMetaData databaseMetaData) throws SQLException {
        if (this.properties == null) {
            return;
        }
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getPrimaryKeys(null, this.getSchema(), this.getName());
            while (resultSet.next()) {
                this.setPrimaryColumn(resultSet);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    private void setPrimaryColumn(ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("PK_NAME");
        if (string == null) {
            return;
        }
        TableIndex tableIndex = this.getIndex(string);
        if (tableIndex != null) {
            tableIndex.setIsPrimaryKey(true);
        }
        String string2 = resultSet.getString("COLUMN_NAME");
        this.setPrimaryColumn(this.getColumn(string2));
    }

    void setPrimaryColumn(TableColumn tableColumn) {
        this.primaryKeys.add(tableColumn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumns(Pattern pattern, Pattern pattern2) throws SQLException {
        ResultSet resultSet = null;
        Class<Table> clazz = Table.class;
        synchronized (Table.class) {
            try {
                resultSet = this.db.getMetaData().getColumns(null, this.getSchema(), this.getName(), "%");
                while (resultSet.next()) {
                    this.addColumn(resultSet, pattern, pattern2);
                }
            }
            catch (SQLException sQLException) {
                class ColumnInitializationFailure
                extends SQLException {
                    private static final long serialVersionUID = 1L;

                    public ColumnInitializationFailure(SQLException sQLException) {
                        super("Failed to collect column details for " + (Table.this.isView() ? "view" : "table") + " '" + Table.this.getName() + "' in schema '" + Table.this.getSchema() + "'");
                        this.initCause(sQLException);
                    }
                }
                throw new ColumnInitializationFailure(sQLException);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (!this.isView() && !this.isRemote()) {
                this.initColumnAutoUpdate(false);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumnAutoUpdate(boolean bl) throws SQLException {
        Object object;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        StringBuilder stringBuilder = new StringBuilder("select * from ");
        if (this.getSchema() != null) {
            stringBuilder.append(this.getSchema());
            stringBuilder.append('.');
        }
        if (bl) {
            object = this.db.getMetaData().getIdentifierQuoteString().trim();
            stringBuilder.append((String)object + this.getName() + (String)object);
        } else {
            stringBuilder.append(this.db.getQuotedIdentifier(this.getName()));
        }
        stringBuilder.append(" where 0 = 1");
        try {
            preparedStatement = this.db.getMetaData().getConnection().prepareStatement(stringBuilder.toString());
            resultSet = preparedStatement.executeQuery();
            object = resultSet.getMetaData();
            for (int i = object.getColumnCount(); i > 0; --i) {
                TableColumn tableColumn = this.getColumn(object.getColumnName(i));
                tableColumn.setIsAutoUpdated(object.isAutoIncrement(i));
            }
        }
        catch (SQLException sQLException) {
            if (bl) {
                logger.warning("Failed to determine auto increment status: " + sQLException);
                logger.warning("SQL: " + stringBuilder.toString());
            } else {
                this.initColumnAutoUpdate(true);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    protected void addColumn(ResultSet resultSet, Pattern pattern, Pattern pattern2) throws SQLException {
        String string = resultSet.getString("COLUMN_NAME");
        if (string == null) {
            return;
        }
        if (this.getColumn(string) == null) {
            TableColumn tableColumn = new TableColumn(this, resultSet, pattern, pattern2);
            this.columns.put(tableColumn.getName(), tableColumn);
        }
    }

    protected TableColumn addColumn(TableColumnMeta tableColumnMeta) {
        TableColumn tableColumn = new TableColumn(this, tableColumnMeta);
        this.columns.put(tableColumn.getName(), tableColumn);
        return tableColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIndexes() throws SQLException {
        if (this.isView() || this.isRemote()) {
            return;
        }
        if (this.initIndexes(this.properties.getProperty("selectIndexesSql"))) {
            return;
        }
        ResultSet resultSet = null;
        try {
            resultSet = this.db.getMetaData().getIndexInfo(null, this.getSchema(), this.getName(), false, true);
            while (resultSet.next()) {
                if (resultSet.getShort("TYPE") == 0) continue;
                this.addIndex(resultSet);
            }
        }
        catch (SQLException sQLException) {
            logger.warning("Unable to extract index info for table '" + this.getName() + "' in schema '" + this.getSchema() + "': " + sQLException);
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initIndexes(String string) {
        if (string == null) {
            return false;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.db.prepareStatement(string, this.getName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                if (resultSet.getShort("TYPE") == 0) continue;
                this.addIndex(resultSet);
            }
        }
        catch (SQLException sQLException) {
            logger.warning("Failed to query index information with SQL: " + string);
            logger.warning(sQLException.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return true;
    }

    public TableIndex getIndex(String string) {
        return this.indexes.get(string);
    }

    private void addIndex(ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("INDEX_NAME");
        if (string == null) {
            return;
        }
        TableIndex tableIndex = this.getIndex(string);
        if (tableIndex == null) {
            tableIndex = new TableIndex(resultSet);
            this.indexes.put(tableIndex.getName(), tableIndex);
        }
        tableIndex.addColumn(this.getColumn(resultSet.getString("COLUMN_NAME")), resultSet.getString("ASC_OR_DESC"));
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public void setId(Object object) {
        this.id = object;
    }

    public Object getId() {
        return this.id;
    }

    public Map<String, String> getCheckConstraints() {
        return this.checkConstraints;
    }

    public Set<TableIndex> getIndexes() {
        return new HashSet<TableIndex>(this.indexes.values());
    }

    public List<TableColumn> getPrimaryColumns() {
        return this.primaryKeys;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String string) {
        String string2;
        String string3 = string2 = string == null || string.trim().length() == 0 ? null : string.trim();
        if (string2 != null) {
            int n = string2.indexOf("; InnoDB free: ");
            if (n == -1) {
                int n2 = n = string2.startsWith("InnoDB free: ") ? 0 : -1;
            }
            if (n != -1) {
                string2 = (string2 = string2.substring(0, n).trim()).length() == 0 ? null : string2;
            }
        }
        this.comments = string2;
    }

    public TableColumn getColumn(String string) {
        return this.columns.get(string);
    }

    public List<TableColumn> getColumns() {
        TreeSet<TableColumn> treeSet = new TreeSet<TableColumn>(new ByColumnIdComparator());
        treeSet.addAll(this.columns.values());
        return new ArrayList<TableColumn>(treeSet);
    }

    public boolean isRoot() {
        for (TableColumn tableColumn : this.columns.values()) {
            if (!tableColumn.isForeignKey()) continue;
            return false;
        }
        return true;
    }

    public boolean isLeaf() {
        for (TableColumn tableColumn : this.columns.values()) {
            if (tableColumn.getChildren().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getMaxParents() {
        return this.maxParents;
    }

    public void addedParent() {
        ++this.maxParents;
    }

    public void unlinkParents() {
        for (TableColumn tableColumn : this.columns.values()) {
            tableColumn.unlinkParents();
        }
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public void addedChild() {
        ++this.maxChildren;
    }

    public void unlinkChildren() {
        for (TableColumn tableColumn : this.columns.values()) {
            tableColumn.unlinkChildren();
        }
    }

    public ForeignKeyConstraint removeSelfReferencingConstraint() {
        return this.remove(this.getSelfReferencingConstraint());
    }

    private ForeignKeyConstraint remove(ForeignKeyConstraint foreignKeyConstraint) {
        if (foreignKeyConstraint != null) {
            for (int i = 0; i < foreignKeyConstraint.getChildColumns().size(); ++i) {
                TableColumn tableColumn = foreignKeyConstraint.getChildColumns().get(i);
                TableColumn tableColumn2 = foreignKeyConstraint.getParentColumns().get(i);
                tableColumn.removeParent(tableColumn2);
                tableColumn2.removeChild(tableColumn);
            }
        }
        return foreignKeyConstraint;
    }

    private ForeignKeyConstraint getSelfReferencingConstraint() {
        for (TableColumn tableColumn : this.columns.values()) {
            for (TableColumn tableColumn2 : tableColumn.getParents()) {
                if (this.compareTo(tableColumn2.getTable()) != 0) continue;
                return tableColumn.getParentConstraint(tableColumn2);
            }
        }
        return null;
    }

    public List<ForeignKeyConstraint> removeNonRealForeignKeys() {
        ArrayList<ForeignKeyConstraint> arrayList = new ArrayList<ForeignKeyConstraint>();
        for (TableColumn object : this.columns.values()) {
            for (TableColumn tableColumn : object.getParents()) {
                ForeignKeyConstraint foreignKeyConstraint = object.getParentConstraint(tableColumn);
                if (foreignKeyConstraint == null || foreignKeyConstraint.isReal()) continue;
                arrayList.add(foreignKeyConstraint);
            }
        }
        for (ForeignKeyConstraint foreignKeyConstraint : arrayList) {
            this.remove(foreignKeyConstraint);
        }
        return arrayList;
    }

    public int getNumChildren() {
        int n = 0;
        for (TableColumn tableColumn : this.columns.values()) {
            n += tableColumn.getChildren().size();
        }
        return n;
    }

    public int getNumNonImpliedChildren() {
        int n = 0;
        for (TableColumn tableColumn : this.columns.values()) {
            for (TableColumn tableColumn2 : tableColumn.getChildren()) {
                if (tableColumn.getChildConstraint(tableColumn2).isImplied()) continue;
                ++n;
            }
        }
        return n;
    }

    public int getNumParents() {
        int n = 0;
        for (TableColumn tableColumn : this.columns.values()) {
            n += tableColumn.getParents().size();
        }
        return n;
    }

    public int getNumNonImpliedParents() {
        int n = 0;
        for (TableColumn tableColumn : this.columns.values()) {
            for (TableColumn tableColumn2 : tableColumn.getParents()) {
                if (tableColumn.getParentConstraint(tableColumn2).isImplied()) continue;
                ++n;
            }
        }
        return n;
    }

    public ForeignKeyConstraint removeAForeignKeyConstraint() {
        List<TableColumn> list = this.getColumns();
        int n = 0;
        int n2 = 0;
        for (TableColumn tableColumn : list) {
            n += tableColumn.getParents().size();
            n2 += tableColumn.getChildren().size();
        }
        for (TableColumn tableColumn : list) {
            ForeignKeyConstraint foreignKeyConstraint = n <= n2 ? tableColumn.removeAParentFKConstraint() : tableColumn.removeAChildFKConstraint();
            if (foreignKeyConstraint == null) continue;
            return foreignKeyConstraint;
        }
        return null;
    }

    public boolean isView() {
        return false;
    }

    public boolean isRemote() {
        return false;
    }

    public String getViewSql() {
        return null;
    }

    public int getNumRows() {
        if (this.numRows == null) {
            this.numRows = Config.getInstance().isNumRowsEnabled() ? this.fetchNumRows() : -1;
        }
        return this.numRows;
    }

    public void setNumRows(int n) {
        this.numRows = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int fetchNumRows() {
        if (this.properties == null) {
            return 0;
        }
        SQLException sQLException = null;
        String string = this.properties.getProperty("selectRowCountSql");
        if (string != null) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.db.prepareStatement(string, this.getName());
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    int n = resultSet.getInt("row_count");
                    return n;
                }
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException3) {}
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException4) {}
                }
            }
        }
        try {
            return this.fetchNumRows("count(*)", false);
        }
        catch (SQLException sQLException5) {
            try {
                return this.fetchNumRows("count(1)", false);
            }
            catch (SQLException sQLException6) {
                logger.warning("Unable to extract the number of rows for table " + this.getName() + ", using '-1'");
                if (sQLException != null) {
                    logger.warning(sQLException.toString());
                }
                logger.warning(sQLException5.toString());
                logger.warning(sQLException6.toString());
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int fetchNumRows(String string, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        StringBuilder stringBuilder = new StringBuilder("select ");
        stringBuilder.append(string);
        stringBuilder.append(" from ");
        if (this.getSchema() != null) {
            stringBuilder.append(this.getSchema());
            stringBuilder.append('.');
        }
        if (bl) {
            String string2 = this.db.getMetaData().getIdentifierQuoteString().trim();
            stringBuilder.append(string2 + this.getName() + string2);
        } else {
            stringBuilder.append(this.db.getQuotedIdentifier(this.getName()));
        }
        try {
            preparedStatement = this.db.getConnection().prepareStatement(stringBuilder.toString());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            int n = -1;
            return n;
        }
        catch (SQLException sQLException) {
            if (bl) {
                throw sQLException;
            }
            int n = this.fetchNumRows(string, true);
            return n;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    public void update(TableMeta tableMeta) {
        String string = tableMeta.getComments();
        if (string != null) {
            this.comments = string;
        }
        for (TableColumnMeta tableColumnMeta : tableMeta.getColumns()) {
            TableColumn tableColumn = this.getColumn(tableColumnMeta.getName());
            if (tableColumn == null) {
                if (tableMeta.getRemoteSchema() == null) {
                    logger.warning("Unrecognized column '" + tableColumnMeta.getName() + "' for table '" + this.getName() + '\'');
                    continue;
                }
                tableColumn = this.addColumn(tableColumnMeta);
            }
            tableColumn.update(tableColumnMeta);
        }
    }

    public void connect(TableMeta tableMeta, Map<String, Table> map, Map<String, Table> map2) {
        for (TableColumnMeta tableColumnMeta : tableMeta.getColumns()) {
            TableColumn tableColumn = this.getColumn(tableColumnMeta.getName());
            for (ForeignKeyMeta foreignKeyMeta : tableColumnMeta.getForeignKeys()) {
                Table table;
                Table table2 = table = foreignKeyMeta.getRemoteSchema() == null ? map.get(foreignKeyMeta.getTableName()) : map2.get(foreignKeyMeta.getRemoteSchema() + '.' + foreignKeyMeta.getTableName());
                if (table != null) {
                    TableColumn tableColumn2 = table.getColumn(foreignKeyMeta.getColumnName());
                    if (tableColumn2 == null) {
                        logger.warning(table.getName() + '.' + foreignKeyMeta.getColumnName() + " doesn't exist");
                        continue;
                    }
                    new ForeignKeyConstraint(tableColumn2, tableColumn){

                        public String getName() {
                            return "Defined in XML";
                        }
                    };
                    continue;
                }
                logger.warning("Undefined table '" + foreignKeyMeta.getTableName() + "' referenced by '" + this.getName() + '.' + tableColumn.getName() + '\'');
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    public boolean isOrphan(boolean bl) {
        if (bl) {
            return this.getMaxParents() == 0 && this.getMaxChildren() == 0;
        }
        for (TableColumn tableColumn : this.columns.values()) {
            for (TableColumn tableColumn2 : tableColumn.getParents()) {
                if (tableColumn.getParentConstraint(tableColumn2).isImplied()) continue;
                return false;
            }
            for (TableColumn tableColumn2 : tableColumn.getChildren()) {
                if (tableColumn.getChildConstraint(tableColumn2).isImplied()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(Table table) {
        if (table == this) {
            return 0;
        }
        int n = this.getName().compareToIgnoreCase(table.getName());
        if (n == 0) {
            String string = this.getSchema();
            String string2 = table.getSchema();
            n = string != null && string2 != null ? string.compareToIgnoreCase(string2) : (string == null ? -1 : 1);
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByColumnIdComparator
    implements Comparator<TableColumn> {
        private ByColumnIdComparator() {
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            if (tableColumn.getId() == null || tableColumn2.getId() == null) {
                return tableColumn.getName().compareToIgnoreCase(tableColumn2.getName());
            }
            if (tableColumn.getId() instanceof Number) {
                return ((Number)tableColumn.getId()).intValue() - ((Number)tableColumn2.getId()).intValue();
            }
            return tableColumn.getId().toString().compareToIgnoreCase(tableColumn2.getId().toString());
        }
    }
}

