/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.Pathname;

public final class Utilities {
    public static final boolean isPlatformUnix;
    public static final boolean isPlatformWindows;

    public static boolean isFilenameAbsolute(String filename) {
        int length = filename.length();
        if (length > 0) {
            char c0 = filename.charAt(0);
            if (c0 == '\\' || c0 == '/') {
                return true;
            }
            if (length > 2) {
                if (isPlatformWindows) {
                    char c1 = filename.charAt(1);
                    if (c1 == ':') {
                        if (c0 >= 'a' && c0 <= 'z') {
                            return true;
                        }
                        if (c0 >= 'A' && c0 <= 'Z') {
                            return true;
                        }
                    }
                } else if (filename.equals("~") || filename.startsWith("~/")) {
                    return true;
                }
            }
        }
        return false;
    }

    public static ZipInputStream getZipInputStream(ZipFile zipfile, String entryName) {
        return Utilities.getZipInputStream(zipfile, entryName, false);
    }

    public static ZipInputStream getZipInputStream(ZipFile zipfile, String entryName, boolean errorOnFailure) {
        ZipEntry zipEntry = zipfile.getEntry(entryName);
        ZipInputStream stream = null;
        try {
            stream = new ZipInputStream(zipfile.getInputStream(zipEntry));
        }
        catch (IOException e) {
            if (errorOnFailure) {
                Lisp.error(new FileError("Failed to open '" + entryName + "' in zipfile '" + zipfile + "': " + e.getMessage()));
            }
            return null;
        }
        return stream;
    }

    public static InputStream getEntryAsInputStream(ZipInputStream zipInputStream, String entryName) {
        ZipEntry entry = Utilities.getEntry(zipInputStream, entryName);
        ByteArrayOutputStream bytes = Utilities.readEntry(zipInputStream);
        return new ByteArrayInputStream(bytes.toByteArray());
    }

    public static ByteArrayOutputStream readEntry(ZipInputStream stream) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int count;
            while ((count = stream.read(buf, 0, buf.length)) != -1) {
                result.write(buf, 0, count);
            }
        }
        catch (IOException e) {
            Debug.trace("Failed to read entry from " + stream + ": " + e);
            return null;
        }
        return result;
    }

    public static ZipEntry getEntry(ZipInputStream zipInputStream, String entryName) {
        return Utilities.getEntry(zipInputStream, entryName, false);
    }

    public static ZipEntry getEntry(ZipInputStream zipInputStream, String entryName, boolean errorOnFailure) {
        ZipEntry entry = null;
        do {
            try {
                entry = zipInputStream.getNextEntry();
            }
            catch (IOException e) {
                if (errorOnFailure) {
                    Lisp.error(new FileError("Failed to seek for '" + entryName + "'" + " in " + zipInputStream.toString()));
                }
                return null;
            }
        } while (entry != null && !entry.getName().equals(entryName));
        if (entry != null) {
            return entry;
        }
        if (errorOnFailure) {
            Lisp.error(new FileError("Failed to find '" + entryName + "'" + " in " + zipInputStream.toString()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean checkZipFile(Pathname name) {
        boolean bl;
        InputStream input = name.getInputStream();
        try {
            try {
                byte[] bytes = new byte[4];
                int bytesRead = input.read(bytes);
                bl = bytesRead == 4 && bytes[0] == 80 && bytes[1] == 75 && bytes[2] == 3 && bytes[3] == 4;
                Object var6_7 = null;
                if (input == null) return bl;
            }
            catch (Throwable t) {
                boolean bl2 = false;
                Object var6_8 = null;
                if (input == null) return bl2;
                try {
                    input.close();
                    return bl2;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (input == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            input.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return bl;
        }
        input.close();
        return bl;
    }

    static InputStream getInputStream(ZipFile jarFile, Pathname inner) {
        String entryPath = inner.asEntryPath();
        ZipEntry entry = jarFile.getEntry(entryPath);
        if (entry == null) {
            Debug.trace("Failed to find entry '" + entryPath + "'" + " in " + "'" + jarFile.getName() + "'");
            return null;
        }
        InputStream result = null;
        try {
            result = jarFile.getInputStream(entry);
        }
        catch (IOException e) {
            Debug.trace("Failed to open InputStream for '" + entryPath + "'" + " in " + "'" + jarFile.getName() + "'");
            return null;
        }
        return result;
    }

    static String escapeFormat(String s) {
        return s.replace("~", "~~");
    }

    static {
        String osName = System.getProperty("os.name");
        isPlatformUnix = osName.startsWith("Linux") || osName.startsWith("Mac OS X") || osName.startsWith("Darwin") || osName.startsWith("Solaris") || osName.startsWith("SunOS") || osName.startsWith("AIX") || osName.startsWith("FreeBSD") || osName.startsWith("OpenBSD") || osName.startsWith("NetBSD");
        isPlatformWindows = osName.startsWith("Windows");
    }
}

