/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignKeyConstraint
implements Comparable<ForeignKeyConstraint> {
    private final String name;
    private Table parentTable;
    private final List<TableColumn> parentColumns = new ArrayList<TableColumn>();
    private final Table childTable;
    private final List<TableColumn> childColumns = new ArrayList<TableColumn>();
    private final int deleteRule;
    private final int updateRule;
    private static final Logger logger = Logger.getLogger(ForeignKeyConstraint.class.getName());
    private static final boolean finerEnabled = logger.isLoggable(Level.FINER);

    ForeignKeyConstraint(Table table, String string, int n, int n2) {
        this.name = string;
        if (finerEnabled) {
            logger.finer("Adding foreign key constraint '" + this.getName() + "' to " + table);
        }
        this.childTable = table;
        this.deleteRule = n2;
        this.updateRule = n;
    }

    public ForeignKeyConstraint(TableColumn tableColumn, TableColumn tableColumn2, int n, int n2) {
        this(tableColumn2.getTable(), null, n, n2);
        this.addChildColumn(tableColumn2);
        this.addParentColumn(tableColumn);
        tableColumn2.addParent(tableColumn, this);
        tableColumn.addChild(tableColumn2, this);
    }

    public ForeignKeyConstraint(TableColumn tableColumn, TableColumn tableColumn2) {
        this(tableColumn, tableColumn2, 3, 3);
    }

    void addParentColumn(TableColumn tableColumn) {
        if (tableColumn != null) {
            this.parentColumns.add(tableColumn);
            this.parentTable = tableColumn.getTable();
        }
    }

    void addChildColumn(TableColumn tableColumn) {
        if (tableColumn != null) {
            this.childColumns.add(tableColumn);
        }
    }

    public String getName() {
        return this.name;
    }

    public Table getParentTable() {
        return this.parentTable;
    }

    public List<TableColumn> getParentColumns() {
        return Collections.unmodifiableList(this.parentColumns);
    }

    public Table getChildTable() {
        return this.childTable;
    }

    public List<TableColumn> getChildColumns() {
        return Collections.unmodifiableList(this.childColumns);
    }

    public int getDeleteRule() {
        return this.deleteRule;
    }

    public boolean isCascadeOnDelete() {
        return this.getDeleteRule() == 0;
    }

    public boolean isRestrictDelete() {
        return this.getDeleteRule() == 3 || this.getDeleteRule() == 1;
    }

    public boolean isNullOnDelete() {
        return this.getDeleteRule() == 2;
    }

    public String getDeleteRuleName() {
        switch (this.getDeleteRule()) {
            case 0: {
                return "Cascade on delete";
            }
            case 1: 
            case 3: {
                return "Restrict delete";
            }
            case 2: {
                return "Null on delete";
            }
        }
        return "";
    }

    public String getDeleteRuleDescription() {
        switch (this.getDeleteRule()) {
            case 0: {
                return "Cascade on delete:\n Deletion of parent deletes child";
            }
            case 1: 
            case 3: {
                return "Restrict delete:\n Parent cannot be deleted if children exist";
            }
            case 2: {
                return "Null on delete:\n Foreign key to parent set to NULL when parent deleted";
            }
        }
        return "";
    }

    public String getDeleteRuleAlias() {
        switch (this.getDeleteRule()) {
            case 0: {
                return "C";
            }
            case 1: 
            case 3: {
                return "R";
            }
            case 2: {
                return "N";
            }
        }
        return "";
    }

    public int getUpdateRule() {
        return this.updateRule;
    }

    public boolean isImplied() {
        return false;
    }

    public boolean isReal() {
        return this.getClass() == ForeignKeyConstraint.class;
    }

    @Override
    public int compareTo(ForeignKeyConstraint foreignKeyConstraint) {
        if (foreignKeyConstraint == this) {
            return 0;
        }
        int n = this.getName().compareToIgnoreCase(foreignKeyConstraint.getName());
        if (n == 0) {
            String string = this.getChildColumns().get(0).getTable().getSchema();
            String string2 = foreignKeyConstraint.getChildColumns().get(0).getTable().getSchema();
            n = string != null && string2 != null ? string.compareToIgnoreCase(string2) : (string == null ? -1 : 1);
        }
        return n;
    }

    public static String toString(List<TableColumn> list) {
        if (list.size() == 1) {
            return list.iterator().next().toString();
        }
        return list.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.childTable.getName());
        stringBuilder.append('.');
        stringBuilder.append(ForeignKeyConstraint.toString(this.childColumns));
        stringBuilder.append(" refs ");
        stringBuilder.append(this.parentTable.getName());
        stringBuilder.append('.');
        stringBuilder.append(ForeignKeyConstraint.toString(this.parentColumns));
        if (this.parentTable.isRemote()) {
            stringBuilder.append(" in ");
            stringBuilder.append(this.parentTable.getSchema());
        }
        if (this.name != null) {
            stringBuilder.append(" via ");
            stringBuilder.append(this.name);
        }
        return stringBuilder.toString();
    }
}

