/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private final String lineSeparator = System.getProperty("line.separator");
    private final int MAX_LEVEL_LEN = 7;
    private static final String formatSpec = "HH:mm:ss.";
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<DateFormat> dateFormatter = new ThreadLocal<DateFormat>(){

        @Override
        public DateFormat initialValue() {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(LogFormatter.formatSpec);
            return simpleDateFormat;
        }
    };
    private static final ThreadLocal<Date> date = new ThreadLocal<Date>(){

        @Override
        public Date initialValue() {
            return new Date();
        }
    };

    public String format(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder(128);
        date.get().setTime(logRecord.getMillis());
        stringBuilder.append(dateFormatter.get().format(date.get()));
        long l = logRecord.getMillis() % 1000L;
        stringBuilder.append(Long.toString(l += 1000L).substring(1));
        stringBuilder.append(" ");
        StringBuilder stringBuilder2 = new StringBuilder(logRecord.getLevel().getLocalizedName());
        if (stringBuilder2.length() > 7) {
            stringBuilder2.setLength(7);
        }
        stringBuilder2.append(":");
        while (stringBuilder2.length() < 8) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append(" ");
        String string = logRecord.getSourceClassName() != null ? logRecord.getSourceClassName() : logRecord.getLoggerName();
        int n = string.lastIndexOf(46);
        if (n >= 0 && n < string.length() - 1) {
            string = string.substring(n + 1);
        }
        stringBuilder.append(string);
        if (logRecord.getSourceMethodName() != null) {
            stringBuilder.append('.');
            stringBuilder.append(logRecord.getSourceMethodName());
        }
        stringBuilder.append(" - ");
        stringBuilder.append(this.formatMessage(logRecord));
        stringBuilder.append(this.lineSeparator);
        if (logRecord.getThrown() != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                logRecord.getThrown().printStackTrace(new PrintWriter((Writer)stringWriter, true));
                stringBuilder.append(stringWriter.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuilder.toString();
    }
}

