/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.text.NumberFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.model.TableIndex;
import net.sourceforge.schemaspy.view.StyleSheet;

public class DotNode {
    private final Table table;
    private final DotNodeConfig config;
    private final String path;
    private final Set<TableColumn> excludedColumns = new HashSet<TableColumn>();
    private final String lineSeparator = System.getProperty("line.separator");
    private final boolean displayNumRows = Config.getInstance().isNumRowsEnabled();

    public DotNode(Table table, String string) {
        this(table, string, new DotNodeConfig(true, true));
    }

    public DotNode(Table table, String string, DotNodeConfig dotNodeConfig) {
        this.table = table;
        this.path = string + (table.isRemote() ? "../../" + table.getSchema() + "/tables/" : "");
        this.config = dotNodeConfig;
    }

    public DotNode(Table table, boolean bl, String string) {
        this(table, string, bl ? new DotNodeConfig(true, false) : new DotNodeConfig());
    }

    public void setShowImplied(boolean bl) {
        this.config.showImpliedRelationships = bl;
    }

    public Table getTable() {
        return this.table;
    }

    public void excludeColumn(TableColumn tableColumn) {
        this.excludedColumns.add(tableColumn);
    }

    public String toString() {
        int n;
        int n2;
        StyleSheet styleSheet = StyleSheet.getInstance();
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.table.getName();
        String string2 = (this.table.isRemote() ? this.table.getSchema() + "." : "") + string;
        String string3 = this.config.showColumnDetails ? "COLSPAN=\"2\" " : "COLSPAN=\"3\" ";
        stringBuilder.append("  \"" + string2 + "\" [" + this.lineSeparator);
        stringBuilder.append("    label=<" + this.lineSeparator);
        stringBuilder.append("    <TABLE BORDER=\"" + (this.config.showColumnDetails ? "2" : "0") + "\" CELLBORDER=\"1\" CELLSPACING=\"0\" BGCOLOR=\"" + styleSheet.getTableBackground() + "\">" + this.lineSeparator);
        stringBuilder.append("      <TR>");
        stringBuilder.append("<TD COLSPAN=\"3\" BGCOLOR=\"" + styleSheet.getTableHeadBackground() + "\" ALIGN=\"CENTER\">" + string2 + "</TD>");
        stringBuilder.append("</TR>" + this.lineSeparator);
        boolean bl = false;
        if (this.config.showColumns) {
            List<TableColumn> list = this.table.getPrimaryColumns();
            HashSet<TableColumn> hashSet = new HashSet<TableColumn>();
            for (TableIndex object : this.table.getIndexes()) {
                hashSet.addAll(object.getColumns());
            }
            hashSet.removeAll(list);
            for (TableColumn tableColumn : this.table.getColumns()) {
                if (this.config.showTrivialColumns || this.config.showColumnDetails || tableColumn.isPrimary() || tableColumn.isForeignKey() || hashSet.contains(tableColumn)) {
                    stringBuilder.append("      <TR>");
                    stringBuilder.append("<TD PORT=\"" + tableColumn.getName() + "\" " + string3);
                    if (this.excludedColumns.contains(tableColumn)) {
                        stringBuilder.append("BGCOLOR=\"" + styleSheet.getExcludedColumnBackgroundColor() + "\" ");
                    } else if (list.contains(tableColumn)) {
                        stringBuilder.append("BGCOLOR=\"" + styleSheet.getPrimaryKeyBackground() + "\" ");
                    } else if (hashSet.contains(tableColumn)) {
                        stringBuilder.append("BGCOLOR=\"" + styleSheet.getIndexedColumnBackground() + "\" ");
                    }
                    stringBuilder.append("ALIGN=\"LEFT\">");
                    stringBuilder.append(tableColumn.getName());
                    stringBuilder.append("</TD>");
                    if (this.config.showColumnDetails) {
                        stringBuilder.append("<TD PORT=\"");
                        stringBuilder.append(tableColumn.getName());
                        stringBuilder.append(".type\" ALIGN=\"LEFT\">");
                        stringBuilder.append(tableColumn.getType().toLowerCase());
                        stringBuilder.append("[");
                        stringBuilder.append(tableColumn.getDetailedSize());
                        stringBuilder.append("]</TD>");
                    }
                    stringBuilder.append("</TR>" + this.lineSeparator);
                    continue;
                }
                bl = true;
            }
        }
        if (bl || !this.config.showColumns) {
            stringBuilder.append("      <TR><TD PORT=\"elipses\" COLSPAN=\"3\" ALIGN=\"LEFT\">...</TD></TR>" + this.lineSeparator);
        }
        stringBuilder.append("      <TR>");
        stringBuilder.append("<TD ALIGN=\"LEFT\" BGCOLOR=\"" + styleSheet.getBodyBackground() + "\">");
        int n3 = n2 = this.config.showImpliedRelationships ? this.table.getNumParents() : this.table.getNumNonImpliedParents();
        if (n2 > 0 || this.config.showColumnDetails) {
            stringBuilder.append("&lt; " + n2);
        } else {
            stringBuilder.append("  ");
        }
        stringBuilder.append("</TD>");
        stringBuilder.append("<TD ALIGN=\"RIGHT\" BGCOLOR=\"" + styleSheet.getBodyBackground() + "\">");
        if (this.table.isView()) {
            stringBuilder.append("view");
        } else {
            int n4 = this.table.getNumRows();
            if (this.displayNumRows && n4 != -1) {
                stringBuilder.append(NumberFormat.getInstance().format(n4));
                stringBuilder.append(" row");
                if (n4 != 1) {
                    stringBuilder.append('s');
                }
            } else {
                stringBuilder.append("  ");
            }
        }
        stringBuilder.append("</TD>");
        stringBuilder.append("<TD ALIGN=\"RIGHT\" BGCOLOR=\"" + styleSheet.getBodyBackground() + "\">");
        int n4 = n = this.config.showImpliedRelationships ? this.table.getNumChildren() : this.table.getNumNonImpliedChildren();
        if (n > 0 || this.config.showColumnDetails) {
            stringBuilder.append(n + " &gt;");
        } else {
            stringBuilder.append("  ");
        }
        stringBuilder.append("</TD></TR>" + this.lineSeparator);
        stringBuilder.append("    </TABLE>>" + this.lineSeparator);
        if (!this.table.isRemote() || Config.getInstance().isOneOfMultipleSchemas()) {
            stringBuilder.append("    URL=\"" + this.path + DotNode.toNCR(string) + ".html\"" + this.lineSeparator);
        }
        stringBuilder.append("    tooltip=\"" + DotNode.toNCR(string2) + "\"" + this.lineSeparator);
        stringBuilder.append("  ];");
        return stringBuilder.toString();
    }

    private static String toNCR(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append("&#");
            stringBuilder.append(Integer.parseInt(Integer.toHexString(c), 16));
            stringBuilder.append(";");
        }
        return stringBuilder.toString();
    }

    public static class DotNodeConfig {
        private final boolean showColumns;
        private boolean showTrivialColumns;
        private final boolean showColumnDetails;
        private boolean showImpliedRelationships;

        public DotNodeConfig() {
            this.showImpliedRelationships = false;
            this.showColumnDetails = false;
            this.showTrivialColumns = false;
            this.showColumns = false;
        }

        public DotNodeConfig(boolean bl, boolean bl2) {
            this.showColumns = true;
            this.showTrivialColumns = bl;
            this.showColumnDetails = bl2;
        }
    }
}

