/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.util.Dot;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.view.DotFormatter;
import net.sourceforge.schemaspy.view.HtmlDiagramFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlOrphansPage
extends HtmlDiagramFormatter {
    private static HtmlOrphansPage instance = new HtmlOrphansPage();

    private HtmlOrphansPage() {
    }

    public static HtmlOrphansPage getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(Database database, List<Table> list, File file, LineWriter lineWriter) throws IOException {
        Dot dot = this.getDot();
        if (dot == null) {
            return false;
        }
        HashSet<Table> hashSet = new HashSet<Table>();
        for (Table object : list) {
            if (object.isOrphan(true)) continue;
            hashSet.add(object);
        }
        this.writeHeader(database, "Utility Tables", !hashSet.isEmpty(), lineWriter);
        lineWriter.writeln("<a name='diagram'>");
        try {
            StringBuilder stringBuilder = new StringBuilder(65536);
            for (Table table : list) {
                String string = table.getName();
                File file2 = new File(file, string + ".1degree.dot");
                File file3 = new File(file, string + ".1degree.png");
                LineWriter lineWriter2 = new LineWriter(file2, "UTF-8");
                DotFormatter.getInstance().writeOrphan(table, lineWriter2);
                lineWriter2.close();
                try {
                    stringBuilder.append(dot.generateDiagram(file2, file3));
                }
                catch (Dot.DotFailure dotFailure) {
                    System.err.println(dotFailure);
                    boolean bl = false;
                    lineWriter.writeln("</a>");
                    this.writeFooter(lineWriter);
                    return bl;
                }
                lineWriter.write("  <img src='diagrams/summary/" + file3.getName() + "' usemap='#" + table + "' border='0' alt='' align='top'");
                if (hashSet.contains(table)) {
                    lineWriter.write(" class='impliedNotOrphan'");
                }
                lineWriter.writeln(">");
            }
            lineWriter.write(stringBuilder.toString());
            boolean bl = true;
            return bl;
        }
        finally {
            lineWriter.writeln("</a>");
            this.writeFooter(lineWriter);
        }
    }

    private void writeHeader(Database database, String string, boolean bl, LineWriter lineWriter) throws IOException {
        this.writeHeader(database, null, string, true, lineWriter);
        lineWriter.writeln("<table class='container' width='100%'>");
        lineWriter.writeln("<tr><td class='container'>");
        this.writeGeneratedBy(database.getConnectTime(), lineWriter);
        lineWriter.writeln("</td>");
        lineWriter.writeln("<td class='container' align='right' valign='top' rowspan='2'>");
        this.writeLegend(false, lineWriter);
        lineWriter.writeln("</td></tr>");
        lineWriter.writeln("<tr><td class='container' align='left' valign='top'>");
        if (bl) {
            lineWriter.writeln("<form action=''>");
            lineWriter.writeln(" <label for='removeImpliedOrphans'><input type=checkbox id='removeImpliedOrphans'>");
            lineWriter.writeln("  Hide tables with implied relationships</label>");
            lineWriter.writeln("</form>");
        }
        lineWriter.writeln("</td></tr></table>");
    }

    @Override
    protected boolean isOrphansPage() {
        return true;
    }
}

