/*
 * Decompiled with CFR 0.152.
 */
package com.cyberfox.util.platform;

import com.cyberfox.util.config.JConfig;
import java.awt.SystemTray;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Platform {
    private static boolean _trayEnabled = false;
    private static boolean traySupportDisabled = false;

    private Platform() {
    }

    public static boolean isMac() {
        return JConfig.queryConfiguration("mac", "false").equals("true");
    }

    public static boolean isLinux() {
        return JConfig.getOS().equalsIgnoreCase("linux");
    }

    public static boolean isWindows() {
        return JConfig.getOS().equalsIgnoreCase("windows");
    }

    public static boolean isVista() {
        return System.getProperty("os.name").startsWith("Windows Vista");
    }

    public static boolean usingSparkle() {
        return Platform.isMac() && (JConfig.queryConfiguration("config.firstrun", "false").equals("true") || JConfig.queryConfiguration("temp.sparkle", "false").equals("true"));
    }

    public static void setupMacUI() {
        if (Platform.isRawMac()) {
            JConfig.setConfiguration("mac", "true");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.macos.useScreenMenuBar", "true");
            System.setProperty("Quaqua.tabLayoutPolicy", "wrap");
        }
    }

    public static boolean setQuaquaFeel(JFrame inFrame) {
        String whatLaF = "ch.randelshofer.quaqua.QuaquaLookAndFeel";
        try {
            UIManager.setLookAndFeel(whatLaF);
            if (inFrame != null) {
                SwingUtilities.updateComponentTreeUI(inFrame);
            }
            return true;
        }
        catch (Exception exMe) {
            JConfig.log().handleException("Can't set Quaqua UI (" + whatLaF + ")", exMe);
            return false;
        }
    }

    public static void checkLaF(String lookAndFeel) {
        if (Platform.isRawMac()) {
            if (UIManager.getLookAndFeel().getClass().getName().equals(lookAndFeel)) {
                JConfig.setConfiguration("mac.aqua", "true");
            } else {
                JConfig.setConfiguration("mac.aqua", "false");
            }
        } else {
            JConfig.setConfiguration("mac", "false");
            JConfig.setConfiguration("mac.aqua", "false");
        }
    }

    public static void setTrayEnabled(boolean b) {
        _trayEnabled = b;
    }

    public static boolean isTrayEnabled() {
        return _trayEnabled;
    }

    public static boolean supportsTray() {
        if (!traySupportDisabled && Platform.isWindows()) {
            return true;
        }
        if (Platform.isLinux() && !JConfig.queryConfiguration("tray.override", "false").equals("true")) {
            return false;
        }
        return SystemTray.isSupported();
    }

    public static boolean isRawMac() {
        return System.getProperty("os.name").contains("OS X");
    }

    public static boolean isUSBased() {
        HashSet<String> US_LOCALES = new HashSet<String>(Arrays.asList("", "US", "CA"));
        return US_LOCALES.contains(Locale.getDefault().getCountry());
    }
}

