/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction;

import com.jbidwatcher.auction.AuctionCore;
import com.jbidwatcher.auction.Seller;
import com.jbidwatcher.util.Constants;
import com.jbidwatcher.util.Currency;
import com.jbidwatcher.util.GZip;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.db.ActiveRecord;
import com.jbidwatcher.util.db.Table;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AuctionInfo
extends AuctionCore {
    private String potentialThumbnail = null;
    protected Seller mSeller;
    protected GZip mLoadedPage = null;
    private static Table sDB = null;

    static AuctionInfo findByIdOrIdentifier(String id, String identifier) {
        AuctionInfo ai = null;
        if (id != null) {
            ai = AuctionInfo.find(id);
        }
        if (ai == null && identifier != null) {
            ai = AuctionInfo.findByIdentifier(identifier);
        }
        return ai;
    }

    public void setThumbnail(String thumbPath) {
        if (thumbPath == null) {
            this.setNoThumbnail(true);
        }
        this.mThumbnailPath = thumbPath;
    }

    public void save() {
        String outPath = JConfig.queryConfiguration("auctions.savepath");
        if (outPath != null && outPath.length() != 0 && JConfig.queryConfiguration("store.auctionHTML", "true").equals("true")) {
            String filePath = outPath + System.getProperty("file.separator") + this.getIdentifier() + ".html.gz";
            if (this.mLoadedPage != null) {
                this.mLoadedPage.save(filePath);
            }
        }
        this.mLoadedPage = null;
    }

    private GZip loadFile(File fp) {
        GZip localZip = new GZip();
        if (fp.exists()) {
            if (fp.length() < 524288L) {
                try {
                    JConfig.log().logDebug("Loading from backing page (file is " + fp.length() + " bytes)!");
                    localZip.load(fp);
                }
                catch (IOException ioe) {
                    JConfig.log().handleException("Couldn't read " + fp.getName(), ioe);
                    return null;
                }
                return localZip;
            }
            JConfig.log().logDebug("Can't load " + fp.getName() + ", file is too large.");
        }
        return null;
    }

    void setRealContent(StringBuffer changedContent, boolean final_data) {
        if (changedContent != null) {
            byte[] localBytes = changedContent.toString().getBytes();
            this.setRealContent(localBytes, final_data);
        }
    }

    void setRealContent(byte[] changedContent, boolean final_data) {
        String outPath = JConfig.queryConfiguration("auctions.savepath");
        if (changedContent != null) {
            this.mLoadedPage = new GZip();
            this.mLoadedPage.setData(changedContent);
            if (outPath != null && outPath.length() != 0 && final_data) {
                String filePath = outPath + System.getProperty("file.separator") + this.getIdentifier() + ".html.gz";
                this.mLoadedPage.save(filePath);
                this.mLoadedPage = null;
            }
        }
    }

    GZip getRealContent() {
        File fp = JConfig.getContentFile(this.getIdentifier());
        if (fp != null) {
            return this.loadFile(fp);
        }
        return this.mLoadedPage;
    }

    public void setContent(StringBuffer inContent, boolean final_data) {
        this.setRealContent(inContent, final_data);
    }

    protected StringBuffer getContent() {
        StringBuffer sb;
        if (this.mLoadedPage != null) {
            StringBuffer outSB = this.mLoadedPage.getUncompressedData(false);
            if (outSB == null) {
                outSB = new StringBuffer("mLoadedPage.getUncompressedData is null");
            }
            sb = outSB;
        } else {
            JConfig.log().logDebug("mLoadedPage is null, returning the 'real' cached copy!");
            GZip gz = this.getRealContent();
            if (gz != null) {
                sb = gz.getUncompressedData();
                JConfig.log().logDebug("Turned the uncompressed data into a StringBuffer!");
                if (sb == null) {
                    JConfig.log().logDebug(" Failed to uncompress for id " + this.getIdentifier());
                }
            } else {
                sb = new StringBuffer("Error getting real content.");
            }
        }
        return sb;
    }

    public String getSellerName() {
        this.refreshSeller();
        return this.mSeller != null ? this.mSeller.getSeller() : "(unknown)";
    }

    private void refreshSeller() {
        String seller_id;
        if (this.mSeller == null && (seller_id = this.get("seller_id")) != null) {
            this.mSeller = Seller.findFirstBy("id", seller_id);
        }
    }

    public Seller getSeller() {
        this.refreshSeller();
        return this.mSeller;
    }

    public String getPositiveFeedbackPercentage() {
        this.refreshSeller();
        if (this.mSeller != null) {
            return this.mSeller.getPositivePercentage();
        }
        return "n/a";
    }

    public int getFeedbackScore() {
        this.refreshSeller();
        if (this.mSeller != null) {
            return this.mSeller.getFeedback();
        }
        return 0;
    }

    protected void setSellerName(String sellerName) {
        String raw_id;
        if (sellerName == null || sellerName.length() == 0) {
            return;
        }
        this.mSeller = this.mSeller == null ? Seller.makeSeller(sellerName.trim()) : this.mSeller.makeSeller(sellerName, this.mSeller);
        Integer seller_id = this.mSeller.getId();
        if ((seller_id == null || seller_id == 0) && (raw_id = this.mSeller.saveDB()) != null && raw_id.length() != 0) {
            seller_id = Integer.parseInt(raw_id);
        }
        this.setInteger("seller_id", seller_id);
    }

    public void setIdentifier(String id) {
        this.setString("identifier", id);
    }

    public void setHighBidder(String highBidder) {
        this.setString("highBidder", highBidder);
    }

    protected void setTitle(String title) {
        this.setString("title", title);
    }

    protected void setItemLocation(String itemLocation) {
        this.setString("itemLocation", itemLocation);
    }

    protected void setInsuranceOptional(boolean insuranceOptional) {
        this.setBoolean("insuranceOptional", insuranceOptional);
    }

    protected void setFixedPrice(boolean fixedPrice) {
        this.setBoolean("fixedPrice", fixedPrice);
    }

    protected void setNoThumbnail(boolean noThumbnail) {
        this.setBoolean("noThumbnail", noThumbnail);
    }

    protected void setCurBid(Currency curBid) {
        this.setMonetary("curBid", curBid);
    }

    protected void setMinBid(Currency minBid) {
        this.setMonetary("minBid", minBid);
    }

    protected void setShipping(Currency shipping) {
        this.setMonetary("shipping", shipping);
    }

    protected void setInsurance(Currency insurance) {
        this.setMonetary("insurance", insurance);
    }

    protected void setUSCur(Currency USCur) {
        this.setMonetary("us_cur", USCur, false);
    }

    protected void setBuyNowUS(Currency buyNowUS) {
        this.setMonetary("buy_now_us", buyNowUS, false);
    }

    protected void setBuyNow(Currency buyNow) {
        this.setMonetary("buy_now", buyNow);
    }

    protected void setEnd(Date end) {
        if (end == null || end.equals(Constants.FAR_FUTURE)) {
            end = null;
        }
        this.setDate("end", end);
    }

    public void setNumBids(int numBids) {
        this.setInteger("numBids", numBids);
    }

    public void setPrivate(boolean isPrivate) {
        this.setBoolean("private", isPrivate);
    }

    protected void setPaypal(boolean paypal) {
        this.setBoolean("paypal", paypal);
    }

    protected void setEnded(boolean ended) {
        this.setBoolean("ended", ended);
    }

    public void setThumbnailURL(String url) {
        this.setNoThumbnail(false);
        this.potentialThumbnail = url;
    }

    public String getThumbnailURL() {
        if (this.potentialThumbnail != null) {
            return this.potentialThumbnail;
        }
        return AuctionInfo.getThumbnailById(this.getIdentifier());
    }

    public String getAlternateSiteThumbnail() {
        return AuctionInfo.getThumbnailById(this.getIdentifier() + "6464");
    }

    private static String getThumbnailById(String id) {
        return "http://thumbs.ebaystatic.com/pict/" + id + ".jpg";
    }

    protected static String getTableName() {
        return "auctions";
    }

    @Override
    protected Table getDatabase() {
        return AuctionInfo.getRealDatabase();
    }

    private static Table getRealDatabase() {
        if (sDB == null) {
            sDB = AuctionInfo.openDB(AuctionInfo.getTableName());
        }
        return sDB;
    }

    @Override
    public String saveDB() {
        String seller_id;
        if (this.mSeller != null && (seller_id = this.mSeller.saveDB()) != null) {
            this.set("seller_id", seller_id);
        }
        return super.saveDB();
    }

    public static AuctionInfo find(String id) {
        return AuctionInfo.findFirstBy("id", id);
    }

    public static AuctionInfo findFirstBy(String key, String value) {
        return (AuctionInfo)ActiveRecord.findFirstBy(AuctionInfo.class, key, value);
    }

    public static AuctionInfo findByIdentifier(String identifier) {
        return (AuctionInfo)ActiveRecord.findFirstBySQL(AuctionInfo.class, "SELECT * FROM auctions WHERE id IN (SELECT Max(id) FROM auctions WHERE identifier = '" + identifier + "')");
    }

    public static int count() {
        return ActiveRecord.count(AuctionInfo.class);
    }

    public static int uniqueCount() {
        return AuctionInfo.getRealDatabase().countBySQL("SELECT COUNT(DISTINCT(identifier)) FROM auctions WHERE identifier IS NOT NULL");
    }

    public static boolean deleteAll(List<Integer> toDelete) {
        if (toDelete.isEmpty()) {
            return true;
        }
        String auctions = AuctionInfo.buildCSL(toDelete);
        return AuctionInfo.getRealDatabase().deleteBy("id IN (" + auctions + ")");
    }

    public static List<AuctionInfo> findAllByIds(List<? extends Object> toFind) {
        if (toFind.isEmpty()) {
            return new ArrayList<AuctionInfo>(0);
        }
        String auctions = AuctionInfo.buildCSL(toFind);
        return ActiveRecord.findAllBySQL(AuctionInfo.class, "SELECT * FROM auctions WHERE id IN (" + auctions + ")");
    }

    private static String buildCSL(List<? extends Object> toDelete) {
        StringBuilder ids = new StringBuilder("");
        boolean first = true;
        for (Object object : toDelete) {
            if (!first) {
                ids.append(", ");
            }
            ids.append(object);
            first = false;
        }
        return ids.toString();
    }

    public static List<AuctionInfo> findLostAuctions() {
        List<? extends ActiveRecord> resultSet;
        try {
            resultSet = AuctionInfo.findAllBySQL(AuctionInfo.class, "SELECT * FROM auctions WHERE identifier NOT IN (SELECT DISTINCT(identifier) FROM entries)");
        }
        catch (Exception e) {
            JConfig.log().handleDebugException("Failed to find lost auctions.", e);
            resultSet = null;
        }
        return resultSet;
    }
}

