/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction;

import com.jbidwatcher.util.ByteBuffer;
import com.jbidwatcher.util.IconFactory;
import com.jbidwatcher.util.config.JConfig;
import java.io.File;
import java.io.IOException;

public class Thumbnail {
    public static String getValidImagePath(String identifier) {
        return Thumbnail.getValidImagePath(identifier, null);
    }

    static String getValidImagePath(String identifier, ByteBuffer buf) {
        File f;
        String thumbPath;
        String outPath = JConfig.queryConfiguration("auctions.savepath");
        if (outPath == null || outPath.length() == 0) {
            return null;
        }
        String basePath = outPath + System.getProperty("file.separator") + identifier;
        String imgPath = thumbPath = basePath + "_t.jpg";
        if (buf != null) {
            buf.save(basePath + ".jpg");
        }
        if (!(f = new File(thumbPath)).exists()) {
            File img = new File(basePath + ".jpg");
            if (!img.exists()) {
                return null;
            }
            String badConversionPath = basePath + "_b.jpg";
            File conversionAttempted = new File(badConversionPath);
            imgPath = basePath + ".jpg";
            if (!conversionAttempted.exists()) {
                int prefHeight;
                int maxHeight;
                int prefWidth;
                String maxWidthString = JConfig.queryConfiguration("thumbnail.maxWidth", "512");
                String prefWidthString = JConfig.queryConfiguration("thumbnail.prefWidth", "256");
                String maxHeightString = JConfig.queryConfiguration("thumbnail.maxHeight", "512");
                String prefHeightString = JConfig.queryConfiguration("thumbnail.prefWidth", "256");
                int maxWidth = Integer.parseInt(maxWidthString);
                if (IconFactory.resizeImage(imgPath, thumbPath, maxWidth, prefWidth = Integer.parseInt(prefWidthString), maxHeight = Integer.parseInt(maxHeightString), prefHeight = Integer.parseInt(prefHeightString))) {
                    imgPath = thumbPath;
                } else {
                    try {
                        conversionAttempted.createNewFile();
                    }
                    catch (IOException e) {
                        JConfig.log().handleException("Can't create 'bad' lock file.", e);
                    }
                }
            }
        }
        return imgPath;
    }
}

