/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction.server.ebay;

import com.jbidwatcher.auction.LoginManager;
import com.jbidwatcher.util.Externalized;
import com.jbidwatcher.util.TT;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.html.JHTML;
import com.jbidwatcher.util.http.CookieJar;
import com.jbidwatcher.util.http.Http;
import com.jbidwatcher.util.queue.MQFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class ebayLoginManager
implements LoginManager {
    private volatile CookieJar mSignInCookie = null;
    private boolean mNotifySwing = true;
    private String mBadPassword = null;
    private String mBadUsername = null;
    private String mPassword;
    private String mUserId;
    private String mSiteName;
    private TT T;

    public ebayLoginManager(TT countryProperties, String site, String password, String userId) {
        this.mPassword = password;
        this.mUserId = userId;
        this.mSiteName = site;
        this.T = countryProperties;
    }

    public ebayLoginManager(TT countryProperties, String site, String password, String userId, boolean notifyFailures) {
        this(countryProperties, site, password, userId);
        this.mNotifySwing = notifyFailures;
    }

    @Override
    public void resetCookie() {
        this.mBadPassword = null;
        this.mBadUsername = null;
        this.mSignInCookie = null;
    }

    public boolean updateLogin(String serverName) {
        String oldUsername = this.mUserId;
        String oldPassword = this.mPassword;
        this.setUserId(JConfig.queryConfiguration(serverName + ".user", "default"));
        this.setPassword(JConfig.queryConfiguration(serverName + ".password", "default"));
        return !this.mUserId.equals(oldUsername) || !this.mPassword.equals(oldPassword);
    }

    private URLConnection checkFollowRedirector(URLConnection current, CookieJar cj, String lookFor) throws IOException, CaptchaException {
        StringBuffer signed_in = Http.net().receivePage(current);
        JConfig.log().dump2File("sign_in-a1.html", signed_in);
        JHTML redirector = new JHTML(signed_in);
        if (this.checkSecurityConfirmation(redirector)) {
            return null;
        }
        return ebayLoginManager.checkHTMLFollowRedirect(redirector, lookFor, cj);
    }

    private static URLConnection checkHTMLFollowRedirect(JHTML redirectPage, String lookFor, CookieJar cj) {
        redirectPage.reset();
        JHTML.Form alertSuppressor = redirectPage.getFormWithInput("hidUrl");
        if (alertSuppressor != null && alertSuppressor != null) {
            String url = redirectPage.getFormWithInput("hidUrl").getInputValue("hidUrl");
            return cj.connect(url);
        }
        List<String> allURLs = redirectPage.getAllURLsOnPage(false);
        for (String url : allURLs) {
            int step;
            if (url.indexOf(lookFor) == -1) continue;
            url = url.replaceAll("&amp;", "&");
            url = url.replaceAll("\n", "");
            if (lookFor.equals("BidBin") && (step = url.indexOf("BidBinInfo=")) != -1) {
                step += "BidBinInfo=".length();
                try {
                    String encodedURL = URLEncoder.encode(url.substring(step), "UTF-8");
                    url = url.substring(0, step) + encodedURL;
                }
                catch (UnsupportedEncodingException ignored) {
                    JConfig.log().logMessage("Failed to build a URL because of encoding transformation failure.");
                }
            }
            return cj.connect(url);
        }
        return null;
    }

    private boolean getAdultRedirector(URLConnection uc_signin, CookieJar cj) throws IOException, CaptchaException {
        return (uc_signin = this.checkFollowRedirector(uc_signin, cj, "Adult")) != null && this.getAdultConfirmation(uc_signin, cj);
    }

    private boolean getAdultConfirmation(URLConnection uc_signin, CookieJar cj) throws IOException {
        StringBuffer confirm = Http.net().receivePage(uc_signin);
        JConfig.log().dump2File("sign_in-a2.html", confirm);
        JHTML confirmPage = new JHTML(confirm);
        List<JHTML.Form> confirm_forms = confirmPage.getForms();
        boolean enqueued = false;
        for (JHTML.Form finalForm : confirm_forms) {
            if (!finalForm.hasInput("MfcISAPICommand", "AdultSignIn")) continue;
            uc_signin = cj.connect(finalForm.getAction(), finalForm.getFormData(), null, true, null);
            StringBuffer confirmed = Http.net().receivePage(uc_signin);
            JConfig.log().dump2File("sign_in-a3.html", confirmed);
            JHTML htdoc = new JHTML(confirmed);
            JHTML.Form curForm = htdoc.getFormWithInput("pass");
            if (curForm != null) {
                MQFactory.getConcrete("login").enqueue("FAILED Couldn't find a password form on the sign in page.");
                return false;
            }
            enqueued = true;
            if (htdoc.grep(this.T.s("your.user.id.or.password.is.incorrect")) != null) {
                MQFactory.getConcrete("login").enqueue("FAILED Incorrect login information.");
                continue;
            }
            if (htdoc.grep(this.T.s("your.information.has.been.verified")) != null) {
                MQFactory.getConcrete("login").enqueue("SUCCESSFUL");
                continue;
            }
            if (htdoc.grep(this.T.s("mature.audiences.accepted")) != null) {
                MQFactory.getConcrete("login").enqueue("SUCCESSFUL");
                continue;
            }
            if (htdoc.grep(this.T.s("mature.audiences.disallowed.outside.the.us")) != null) {
                MQFactory.getConcrete("login").enqueue("NEUTRAL Turn off 'Mature Audiences' in JBidwatcher configuration; it's not valid for non-US users.");
                JConfig.setConfiguration("ebay.mature", "false");
                JConfig.setConfiguration("ebay.international", "true");
                continue;
            }
            JConfig.log().logFile("Neutral login result...", confirmed);
            MQFactory.getConcrete("login").enqueue("NEUTRAL");
        }
        if (!enqueued) {
            JConfig.log().logFile("No confirm form found...", confirm);
            MQFactory.getConcrete("login").enqueue("NEUTRAL No confirm form found.");
        }
        return true;
    }

    @Override
    public synchronized CookieJar getSignInCookie(CookieJar old_cj) {
        if (this.getUserId().equals("default")) {
            return old_cj;
        }
        if (this.getPassword().equals(this.mBadPassword) && this.getUserId().equals(this.mBadUsername)) {
            JConfig.log().logDebug("Not getting the sign in cookie; username/password combo hasn't changed.");
            return old_cj;
        }
        String msg = "Getting the sign in cookie for " + this.T.getCountrySiteName();
        JConfig.log().logDebug(msg);
        MQFactory.getConcrete("Swing").enqueue(msg);
        CookieJar cj = this.getSignInCookie(this.getUserId(), this.getPassword());
        String done_msg = cj != null ? "Done getting the sign in cookie for " : "Did not successfully retrieve the sign in cookie for ";
        done_msg = done_msg + this.T.getCountrySiteName();
        MQFactory.getConcrete("Swing").enqueue(done_msg);
        JConfig.log().logDebug(done_msg);
        return cj;
    }

    @Override
    public synchronized CookieJar getNecessaryCookie(boolean force) {
        if (this.mSignInCookie == null || force) {
            this.mSignInCookie = this.getSignInCookie(this.mSignInCookie);
        }
        return this.mSignInCookie;
    }

    public CookieJar getSignInCookie(String username, String password) {
        boolean isAdult = JConfig.queryConfiguration(this.mSiteName + ".mature", "false").equals("true");
        String startURL = this.T.s("ebayServer.signInPage");
        CookieJar cj = new CookieJar();
        if (isAdult) {
            startURL = Externalized.getString("ebayServer.adultPageLogin");
        }
        URLConnection uc_signin = cj.connect(startURL);
        if (JConfig.queryConfiguration("debug.auth", "false").equals("true")) {
            JConfig.log().logDebug("GET " + startURL);
            JConfig.log().logDebug(cj.dump());
        }
        try {
            StringBuffer signin = Http.net().receivePage(uc_signin);
            JConfig.log().dump2File("sign_in-1.html", signin);
            JHTML htdoc = new JHTML(signin);
            cj = this.signInUsingPage(startURL, username, password, isAdult, cj, htdoc);
        }
        catch (IOException e) {
            MQFactory.getConcrete("login").enqueue("FAILED " + e.getMessage());
            if (this.mNotifySwing) {
                MQFactory.getConcrete("Swing").enqueue("INVALID_LOGIN " + e.getMessage());
            }
            JConfig.log().handleException("Couldn't sign in!", e);
            cj = null;
        }
        catch (CaptchaException ce) {
            MQFactory.getConcrete("login").enqueue("CAPTCHA");
            if (this.mNotifySwing) {
                MQFactory.getConcrete("Swing").enqueue("INVALID_LOGIN eBay's increased security monitoring has been triggered, JBidwatcher cannot log in for a while.");
            }
            this.notifySecurityIssue();
            JConfig.log().handleException("Couldn't sign in, captcha interference!", ce);
            cj = null;
        }
        catch (CookieJar.CookieRedirectException cre) {
            MQFactory.getConcrete("login").enqueue("CAPTCHA");
            if (this.mNotifySwing) {
                MQFactory.getConcrete("Swing").enqueue("INVALID_LOGIN The login page is redirecting to itself infinitely; this probably means eBay's increased security monitoring has been triggered and JBidwatcher cannot log in for a while.");
            }
            this.notifySecurityIssue();
            JConfig.log().handleException("Couldn't sign in, endless redirection; probably captcha interference!", cre);
        }
        return cj;
    }

    private CookieJar signInUsingPage(String previousPage, String username, String password, boolean adult, CookieJar cj, JHTML htdoc) throws IOException, CaptchaException {
        ArrayList<String> resultPages = new ArrayList<String>();
        JHTML.Form curForm = htdoc.getFormWithInput("pass");
        if (curForm != null) {
            curForm.setText("userid", username);
            curForm.setText("pass", password);
            if (JConfig.queryConfiguration("debug.auth", "false").equals("true")) {
                JConfig.log().logDebug("Cookies before posting form: \n" + cj.dump());
            }
            URLConnection uc_signin = cj.connect(curForm.getAction(), curForm.getFormData(), previousPage, true, resultPages);
            if (JConfig.queryConfiguration("debug.auth", "false").equals("true")) {
                JConfig.log().logDebug("POST " + curForm.getAction());
                JConfig.log().logDebug("Data: " + curForm.getFormData());
                for (String string : resultPages) {
                    JConfig.log().logDebug("Went to page: " + string);
                }
                JConfig.log().logDebug("Cookies after posting form: \n" + cj.dump());
            }
            boolean fixYourPassword = false;
            for (String page : resultPages) {
                if (page.indexOf("FYPShow") == -1) continue;
                fixYourPassword = true;
            }
            if (adult) {
                if (this.getAdultRedirector(uc_signin, cj)) {
                    if (this.mNotifySwing) {
                        MQFactory.getConcrete("Swing").enqueue("VALID_LOGIN");
                    }
                } else {
                    cj = this.retryLoginWithoutAdult(cj, username, password);
                }
            } else {
                StringBuffer stringBuffer = Http.net().receivePage(uc_signin);
                JConfig.log().dump2File("sign_in-2.html", stringBuffer);
                JHTML doc = new JHTML(stringBuffer);
                if (fixYourPassword || doc.getTitle().equals("Reset your password")) {
                    JConfig.log().logMessage("eBay is requesting that you change your password.");
                    MQFactory.getConcrete("login").enqueue("FAILED You must change your password on eBay.");
                } else if (doc.getTitle().contains("Secret Question")) {
                    String notification = "eBay is requesting that you provide security questions for account recovery.";
                    JConfig.log().logMessage(notification);
                    MQFactory.getConcrete("login").enqueue("SUCCESSFUL " + notification);
                    if (this.mNotifySwing) {
                        MQFactory.getConcrete("Swing").enqueue("VALID_LOGIN");
                    }
                } else if (this.checkSecurityConfirmation(doc)) {
                    cj = null;
                    MQFactory.getConcrete("login").enqueue("FAILED Sign in information is not valid.");
                } else {
                    boolean success;
                    JHTML.Form redirect_form = doc.getFormWithInput("hidUrl");
                    String hidUrl = null;
                    if (redirect_form != null) {
                        hidUrl = redirect_form.getInputValue("hidUrl");
                    }
                    if (success = this.checkFinalRedirect(hidUrl)) {
                        MQFactory.getConcrete("login").enqueue("SUCCESSFUL");
                    } else {
                        JConfig.log().logFile("Security checks out, but no My eBay form link on final page...", stringBuffer);
                        MQFactory.getConcrete("login").enqueue("NEUTRAL");
                    }
                    if (this.mNotifySwing) {
                        MQFactory.getConcrete("Swing").enqueue("VALID_LOGIN");
                    }
                }
            }
        }
        return cj;
    }

    private boolean checkFinalRedirect(String hidUrl) {
        boolean success = false;
        if (hidUrl != null) {
            if (hidUrl.matches("^https?://signin.ebay.(com|co.uk|ie).*ws.*eBayISAPI.dll\\?SignInMCAlert.*$")) {
                MQFactory.getConcrete("Swing").enqueue("NOTIFY You have a message from eBay during login.");
                success = true;
            } else {
                success = hidUrl.matches("^https?://(signin.ebay.(com|co.uk|ie))?.*my.*ebay.*(com|co.uk|ie).*ws.*eBayISAPI.dll.*My.*eBay.*$") || hidUrl.matches("^https?://www.ebay.(com|co.uk|ie).*$");
            }
        }
        return success;
    }

    private CookieJar retryLoginWithoutAdult(CookieJar cj, String username, String password) {
        JConfig.log().logMessage("Disabling 'mature audiences' mode and retrying.");
        JConfig.setConfiguration(this.mSiteName + ".mature", "false");
        cj = this.getSignInCookie(username, password);
        JConfig.setConfiguration(this.mSiteName + ".mature", "true");
        return cj;
    }

    private void notifySecurityIssue() {
        MQFactory.getConcrete("Swing").enqueue("NOTIFY eBay's security monitoring has been triggered, and temporarily requires\nhuman intervention to log in.  JBidwatcher will not be able to log in\n(including bids, snipes, and retrieving My eBay items) until this is fixed.");
    }

    private void notifyBadSignin() {
        MQFactory.getConcrete("Swing").enqueue("NOTIFY Your sign in information appears to be incorrect, according to\neBay.  Please fix it in the eBay tab in the Configuration Manager.");
    }

    private boolean checkSecurityConfirmation(JHTML doc) throws CaptchaException {
        if (doc.grep(this.T.s("security.measure")) != null || doc.grep(this.T.s("enter.verification.code")) != null || doc.grep(this.T.s("enter.a.verification.code.to.continue")) != null || doc.grep(this.T.s("please.enter.the.verification.code")) != null) {
            JConfig.log().logMessage("eBay's security monitoring has been triggered, and temporarily requires human intervention to log in.");
            if (this.mNotifySwing) {
                MQFactory.getConcrete("Swing").enqueue("INVALID_LOGIN eBay's security monitoring has been triggered, and temporarily requires human intervention to log in.");
            }
            this.notifySecurityIssue();
            this.mBadPassword = this.getPassword();
            this.mBadUsername = this.getUserId();
            throw new CaptchaException("Failed eBay security check/captcha; verification code required.");
        }
        if (doc.grep(this.T.s("your.sign.in.information.is.not.valid")) != null || doc.grep(this.T.s("your.user.id.or.password.is.incorrect")) != null) {
            JConfig.log().logMessage("Your sign in information is not correct.");
            if (this.mNotifySwing) {
                MQFactory.getConcrete("Swing").enqueue("INVALID_LOGIN Your sign in information is not correct.  Fix it in the eBay tab in the Configuration Manager.");
            }
            this.notifyBadSignin();
            this.mBadPassword = this.getPassword();
            this.mBadUsername = this.getUserId();
            return true;
        }
        return false;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public String getUserId() {
        return this.mUserId;
    }

    public boolean isDefault() {
        return this.mUserId == null || this.mUserId.equals("default");
    }

    public boolean validate(String username, String password) {
        return !this.isDefault() && this.getUserId().equals(username) && this.getPassword().equals(password);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(ebayLoginManager that) {
        String user1 = this.getUserId();
        String pass1 = this.getPassword();
        String user2 = that.getUserId();
        String pass2 = that.getPassword();
        if (user1 != null) {
            if (!user1.equals(user2)) {
                return false;
            }
        } else if (user2 != null) return false;
        if (pass1 != null) {
            if (!pass1.equals(pass2)) {
                return false;
            }
        } else if (pass2 != null) return false;
        if (user1 == null) return true;
        if (pass1 == null) return true;
        if (!user1.equals(user2)) return false;
        if (!pass1.equals(pass2)) return false;
        return true;
    }

    public void setPassword(String password) {
        if (!this.mPassword.equals(password)) {
            this.mPassword = password;
            this.mSignInCookie = null;
        }
    }

    public void setUserId(String userId) {
        if (!this.mUserId.equals(userId)) {
            this.mUserId = userId;
            this.mSignInCookie = null;
        }
    }

    public static class CaptchaException
    extends Exception {
        private String _associatedString;

        public CaptchaException(String inString) {
            this._associatedString = inString;
        }

        @Override
        public String toString() {
            return this._associatedString;
        }
    }
}

