/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.scripting;

import com.jbidwatcher.util.config.JConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.builtin.IRubyObject;

public class Scripting {
    private static Object sRuby = null;
    private static FauxOutputStream sOutput;
    private static FauxInputStream sInput;
    private static Map<String, Object> expressionCache;

    private Scripting() {
    }

    public static Ruby getRuntime() {
        return (Ruby)sRuby;
    }

    public static void setOutput(OutputStream stream) {
        sOutput.setOutput(stream);
    }

    public static void setInput(InputStream stream) {
        sInput.setInput(stream);
    }

    public static void initialize() throws ClassNotFoundException {
        Class.forName("org.jruby.RubyInstanceConfig", true, Thread.currentThread().getContextClassLoader());
        System.setProperty("jruby.debug.loadService.timing", "true");
        sOutput = new FauxOutputStream();
        sInput = new FauxInputStream();
        RubyInstanceConfig config = new RubyInstanceConfig(){
            {
                String[] args = new String[]{"--readline", "--prompt-mode", "default"};
                this.setInput(sInput);
                this.setOutput(new PrintStream(sOutput));
                this.setError(new PrintStream(sOutput));
                this.setArgv(args);
            }
        };
        Ruby runtime = Ruby.newInstance((RubyInstanceConfig)config);
        runtime.getGlobalVariables().defineReadonly("$$", (IAccessor)new ValueAccessor((IRubyObject)runtime.newFixnum(System.identityHashCode(runtime))), GlobalVariable.Scope.GLOBAL);
        if (JConfig.queryConfiguration("platform.path") != null) {
            runtime.getLoadService().addPaths(new String[]{JConfig.queryConfiguration("platform.path")});
        }
        runtime.getLoadService().addPaths(new String[]{"lib/jbidwatcher", "lib/jbidwatcher/nokogiri-1.5.2-java/lib"});
        sRuby = runtime;
    }

    public static void require(String file) {
        Scripting.getRuntime().evalScriptlet("require '" + file + "';");
    }

    public static void setGlobalVariable(String variable, Object value) {
        Scripting.getRuntime().getGlobalVariables().defineReadonly(variable, (IAccessor)new ValueAccessor(JavaUtil.convertJavaToRuby((Ruby)Scripting.getRuntime(), (Object)value)), GlobalVariable.Scope.GLOBAL);
    }

    public static Object ruby(String command) {
        if (sRuby != null) {
            return ((Ruby)sRuby).evalScriptlet(command);
        }
        return null;
    }

    public static Object rubyMethod(String method, Object ... method_params) {
        return Scripting.doRuby("JBidwatcher", method, method_params);
    }

    public static void forget(String what) {
        expressionCache.remove(what);
    }

    public static Object doRuby(String on, String method, Object ... method_params) {
        if (sRuby == null) {
            return null;
        }
        Object actOn = expressionCache.get(on);
        if (actOn == null && (actOn = Scripting.ruby(on)) != null) {
            expressionCache.put(on, actOn);
        }
        if (actOn != null) {
            return JavaEmbedUtils.invokeMethod((Ruby)((Ruby)sRuby), (Object)actOn, (String)method, (Object[])method_params, Object.class);
        }
        return null;
    }

    static {
        expressionCache = new HashMap<String, Object>();
    }

    private static class FauxInputStream
    extends InputStream {
        private InputStream mIn = System.in;

        private FauxInputStream() {
        }

        @Override
        public int read() throws IOException {
            return this.mIn.read();
        }

        public InputStream setInput(InputStream newInput) {
            InputStream old = this.mIn;
            this.mIn = newInput;
            return old;
        }
    }

    private static class FauxOutputStream
    extends OutputStream {
        private OutputStream mOut = System.out;

        private FauxOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.mOut.write(b);
        }

        @Override
        public void write(byte[] bs) throws IOException {
            this.mOut.write(bs);
        }

        @Override
        public void write(byte[] bs, int offset, int length) throws IOException {
            this.mOut.write(bs, offset, length);
        }

        public OutputStream setOutput(OutputStream newOutput) {
            OutputStream old = this.mOut;
            this.mOut = newOutput;
            return old;
        }
    }
}

