/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.cyberfox.util.platform.Platform;
import com.jbidwatcher.ui.JTabPopupMenu;
import com.jbidwatcher.ui.PopupMenuFactory;
import com.jbidwatcher.ui.util.JContext;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MQFactory;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JBidMenuBar
extends JMenuBar {
    protected static JBidMenuBar _instance = null;
    protected JMenu _fileMenu;
    protected JMenu _editMenu;
    protected JMenu _debugMenu = null;
    protected JMenu _serverMenu;
    protected JMenu mWindowMenu;
    protected JMenu mTabMenu;
    protected JMenu _auctionMenu;
    protected JMenu _helpMenu;
    protected ActionListener _actionDirector;
    private static HashMap<String, JBidMenuBar> _frameMenus = new HashMap(10);

    protected JMenuItem makeMenuItem(JMenu inMenu, String inName, String inActionCommand, int mnemonic, KeyStroke accelerator) {
        return this.makeMenuItem(inMenu, inName, inActionCommand, mnemonic, accelerator, true);
    }

    protected JMenuItem makeMenuItem(JMenu inMenu, String inName, String inActionCommand, int mnemonic, KeyStroke accelerator, boolean add) {
        JMenuItem constructItem = new JMenuItem();
        constructItem.setText(inName);
        constructItem.setActionCommand(inActionCommand);
        constructItem.addActionListener(this._actionDirector);
        constructItem.setMnemonic(mnemonic);
        if (accelerator != null) {
            constructItem.setAccelerator(accelerator);
        }
        if (add) {
            inMenu.add(constructItem);
        }
        return constructItem;
    }

    protected JMenuItem makeMenuItem(JMenu inMenu, String inName, int mnemonic, KeyStroke accelerator) {
        return this.makeMenuItem(inMenu, inName, inName, mnemonic, accelerator, true);
    }

    protected JMenuItem makeMenuItem(JMenu inMenu, String inName, String inActionCommand, char mnemonic) {
        JMenuItem constructItem = new JMenuItem();
        constructItem.setText(inName);
        constructItem.setActionCommand(inActionCommand);
        constructItem.addActionListener(this._actionDirector);
        constructItem.setMnemonic(mnemonic);
        inMenu.add(constructItem);
        return constructItem;
    }

    protected JMenuItem makeMenuItem(JMenu inMenu, String inName, char mnemonic) {
        return this.makeMenuItem(inMenu, inName, inName, mnemonic);
    }

    protected JMenuItem makeMenuItem(JMenu inMenu, String inName, int mnemonic) {
        return this.makeMenuItem(inMenu, inName, inName, mnemonic, null);
    }

    protected JMenuItem makeMenuItem(JMenu inMenu, String inName) {
        return this.makeMenuItem(inMenu, inName, inName, '\u0000');
    }

    protected void establishFileMenu(JMenu inMenu) {
        this.makeMenuItem(inMenu, "Save Auctions", "Save", 83, KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.makeMenuItem(inMenu, "Dump Cache", "Dump", 68, KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        if (Platform.isMac()) {
            this.makeMenuItem(inMenu, "Configure", 67, KeyStroke.getKeyStroke(44, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        } else {
            this.makeMenuItem(inMenu, "Configure", 67, KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
        this.makeMenuItem(inMenu, "Scripting Manager", "Scripting", 'M');
        if (!Platform.isMac()) {
            this.makeMenuItem(inMenu, "Check For Updates", 85);
        }
        this.makeMenuItem(inMenu, "Clear Deleted Tracking", "Clear Deleted", 68, KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        if (!Platform.isMac()) {
            inMenu.add(new JSeparator());
        }
        this.makeMenuItem(inMenu, "Exit", "Exit", 88, KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), !Platform.isMac());
        String launcher = System.getenv("JBIDWATCHER_LAUNCHER");
        if (launcher != null && JConfig.debugging()) {
            this.makeMenuItem(inMenu, "Restart", "Restart", 'R');
        }
    }

    protected void establishDebugMenu(JMenu inMenu) {
        this.makeMenuItem(inMenu, "Serialize");
        this.makeMenuItem(inMenu, "Deserialize");
        this.makeMenuItem(inMenu, "SQL");
        inMenu.add(new JSeparator());
        this.makeMenuItem(inMenu, "Submit Log File");
    }

    protected void establishEditMenu(JMenu inMenu) {
        JMenu copyMenu = new JMenu("Copy");
        copyMenu.add(JContext.makeGeneralMenuItem("Information", "Copy")).addActionListener(this._actionDirector);
        copyMenu.add(JContext.makeGeneralMenuItem("URL", "CopyURL")).addActionListener(this._actionDirector);
        copyMenu.add(JContext.makeGeneralMenuItem("Auction Id", "CopyID")).addActionListener(this._actionDirector);
        inMenu.add(copyMenu);
        this.makeMenuItem(inMenu, "Paste Auction", "Paste", 80, KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        inMenu.add(new JSeparator());
        this.makeMenuItem(inMenu, "Find", "Search", 70, KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        inMenu.add(new JSeparator());
        this.makeMenuItem(inMenu, "Set Background Color", "Set Background Color", 'B');
        this.makeMenuItem(inMenu, "Show/Hide Toolbar", "Toolbar", 'T');
    }

    protected void establishServerMenu(JMenu inMenu) {
        String doTimeSync = JConfig.queryConfiguration("timesync.enabled", "true");
        this.makeMenuItem(inMenu, "Update Auctions", "UpdateAll", 'U');
        this.makeMenuItem(inMenu, "Stop Activity", "StopUpdating", 83, KeyStroke.getKeyStroke(27, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        if (doTimeSync.equals("true")) {
            inMenu.add(new JSeparator());
            this.makeMenuItem(inMenu, "Time Information", "Show Time Info", 'T');
            this.makeMenuItem(inMenu, "Synchronize Time", "Resync", 'R');
        }
    }

    protected void establishWindowMenu(JMenu inMenu) {
        this.makeMenuItem(inMenu, "Activity Log", "View Activity", 'A');
        this.makeMenuItem(inMenu, "Errors Log", "View Log", 'E');
        this.makeMenuItem(inMenu, "Search Manager", "Search", 'S');
        this.makeMenuItem(inMenu, "Configuration", "Configure", 'C');
        this.makeMenuItem(inMenu, "Scripting", 'P');
        inMenu.add(new JSeparator());
        this.makeMenuItem(inMenu, "Choose Font", "Font", 'F');
        this.makeMenuItem(inMenu, "Change Selection Color", "Selection Color", 'H');
    }

    protected void establishAuctionMenu(JMenu inMenu) {
        JMenuItem add = Platform.isMac() ? this.makeMenuItem(inMenu, "Add New", 65, KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) : this.makeMenuItem(inMenu, "Add", 65, KeyStroke.getKeyStroke(155, 0));
        add.registerKeyboardAction(this._actionDirector, "Add", KeyStroke.getKeyStroke(107, 0), 2);
        add.registerKeyboardAction(this._actionDirector, "Add", KeyStroke.getKeyStroke(61, 64), 2);
        if (Platform.isMac()) {
            this.makeMenuItem(inMenu, "Delete", 68, KeyStroke.getKeyStroke(127, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        } else {
            this.makeMenuItem(inMenu, "Delete", 68, KeyStroke.getKeyStroke(127, 0));
        }
        inMenu.add(new JSeparator());
        this.makeMenuItem(inMenu, "Snipe", 83, KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.makeMenuItem(inMenu, "Multiple Snipe", 'i');
        this.makeMenuItem(inMenu, "Cancel Snipe", 'C');
        inMenu.add(new JSeparator());
        this.makeMenuItem(inMenu, "Bid", 'B');
        this.makeMenuItem(inMenu, "Buy", 'y');
        inMenu.add(new JSeparator());
        this.makeMenuItem(inMenu, "Update", 'U');
        if (Platform.isMac()) {
            this.makeMenuItem(inMenu, "Show Information", "Information", 73, KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        } else {
            this.makeMenuItem(inMenu, "Show Information", "Information", 'I');
        }
        this.makeMenuItem(inMenu, "Show In Browser", "Browse", 98, KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        inMenu.add(new JSeparator());
        JMenu commentMenu = new JMenu("Comment");
        commentMenu.add(JContext.makeGeneralMenuItem("Add", "Add Comment")).addActionListener(this._actionDirector);
        commentMenu.add(JContext.makeGeneralMenuItem("View", "View Comment")).addActionListener(this._actionDirector);
        commentMenu.add(JContext.makeGeneralMenuItem("Remove", "Remove Comment")).addActionListener(this._actionDirector);
        inMenu.add(commentMenu);
    }

    protected void establishHelpMenu(JMenu inMenu) {
        this.makeMenuItem(inMenu, "Explain Colors And Icons", 'E');
        this.makeMenuItem(inMenu, "FAQ", 70, KeyStroke.getKeyStroke(112, 0));
        this.makeMenuItem(inMenu, "User Community", "Forum", 'C');
        this.makeMenuItem(inMenu, "Donate", 'D');
        this.makeMenuItem(inMenu, "License Details", "License", 'D');
        if (JConfig.debugging()) {
            this.makeMenuItem(inMenu, "Report a Bug", "Report Bug", 'R');
        }
        inMenu.add(new JSeparator());
        this.makeMenuItem(inMenu, "My JBidwatcher", 'M');
        this.makeMenuItem(inMenu, "About JBidwatcher", 'A');
    }

    protected static JBidMenuBar getFrameInstance(PopupMenuFactory menuFactory, JTabbedPane inTabs, ActionListener inAction, String frameName) {
        JBidMenuBar retInstance = _frameMenus.get(frameName);
        if (retInstance == null) {
            if (inAction == null) {
                throw new RuntimeException("JBidMenuBar.getInstance(null) called when no matching instance \"" + frameName + "\" yet created!");
            }
            retInstance = new JBidMenuBar(menuFactory, inTabs, inAction);
            _frameMenus.put(frameName, retInstance);
        }
        if (_instance == null) {
            _instance = retInstance;
        }
        return retInstance;
    }

    public static JBidMenuBar getInstance(PopupMenuFactory menuFactory, JTabbedPane inTabs, ActionListener inAction) {
        return JBidMenuBar.getInstance(menuFactory, inTabs, inAction, null);
    }

    public static JBidMenuBar getInstance(PopupMenuFactory menuFactory, JTabbedPane inTabs, ActionListener inAction, String frameName) {
        if (inAction == null && _instance == null && _frameMenus == null) {
            throw new RuntimeException("JBidMenuBar.getInstance(null, null) called when no instance yet created!");
        }
        if (frameName != null) {
            return JBidMenuBar.getFrameInstance(menuFactory, inTabs, inAction, frameName);
        }
        if (_instance == null) {
            _instance = new JBidMenuBar(menuFactory, inTabs, inAction);
        }
        return _instance;
    }

    private JBidMenuBar(PopupMenuFactory menuFactory, JTabbedPane inTabs, ActionListener inAction) {
        this._actionDirector = inAction;
        this._fileMenu = new JMenu("File");
        this._fileMenu.setMnemonic('F');
        this._editMenu = new JMenu("Edit");
        this._editMenu.setMnemonic('E');
        if (JConfig.queryConfiguration("debug.menu", "false").equals("true") && JConfig.debugging()) {
            this._debugMenu = new JMenu("Debug");
            this._debugMenu.setMnemonic('D');
            this.establishDebugMenu(this._debugMenu);
        }
        this._serverMenu = new JMenu("Servers");
        this._serverMenu.setMnemonic('S');
        this._auctionMenu = new JMenu("Auction");
        this._auctionMenu.setMnemonic('A');
        this.mTabMenu = new JMenu("Tab");
        this.mTabMenu.setMnemonic('T');
        this.mWindowMenu = new JMenu("Windows");
        this.mWindowMenu.setMnemonic('W');
        this._helpMenu = new JMenu("Help");
        this._helpMenu.setMnemonic('H');
        this.establishFileMenu(this._fileMenu);
        this.establishEditMenu(this._editMenu);
        this.establishServerMenu(this._serverMenu);
        this.establishAuctionMenu(this._auctionMenu);
        this.establishTabMenu(menuFactory, inTabs, this.mTabMenu);
        this.establishWindowMenu(this.mWindowMenu);
        this.establishHelpMenu(this._helpMenu);
        this.add(this._fileMenu);
        this.add(this._editMenu);
        if (this._debugMenu != null) {
            this.add(this._debugMenu);
        }
        this.add(this._serverMenu);
        this.add(this._auctionMenu);
        this.add(this.mTabMenu);
        this.add(this.mWindowMenu);
        this.add(this._helpMenu);
    }

    private void establishTabMenu(PopupMenuFactory menuFactory, final JTabbedPane inTabs, JMenu tabMenu) {
        final JTabPopupMenu pop = menuFactory.create(inTabs, tabMenu.getPopupMenu());
        MQFactory.getConcrete("tab_menu").registerListener(pop);
        tabMenu.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                pop.preparePopup(inTabs.getSelectedIndex());
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }
}

