/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;

public class JSplashScreen
extends Window
implements MessageQueue.Listener {
    JProgressBar statusBar;

    public JSplashScreen(ImageIcon coolPicture) {
        super(new Frame());
        MQFactory.getConcrete("splash").registerListener(this);
        JPanel panelForBorder = new JPanel(new BorderLayout());
        panelForBorder.setLayout(new BorderLayout());
        panelForBorder.add((Component)new JLabel(coolPicture), "Center");
        this.statusBar = new JProgressBar(0, 100);
        panelForBorder.add((Component)this.statusBar, "South");
        panelForBorder.setBorder(new BevelBorder(0));
        this.add(panelForBorder);
        this.pack();
        Dimension WindowSize = this.getSize();
        Dimension ScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((ScreenSize.width - WindowSize.width) / 2, (ScreenSize.height - WindowSize.height) / 2, WindowSize.width, WindowSize.height);
        this.setVisible(true);
    }

    public void showStatus(int currentStatus) {
        this.statusBar.setValue(currentStatus);
    }

    public void setWidth(int maxCount) {
        this.statusBar.setMaximum(maxCount);
    }

    public void setWidthValue(int maxCount, int currentStatus) {
        this.statusBar.setMaximum(maxCount);
        this.statusBar.setValue(currentStatus);
    }

    public void close() {
        SwingUtilities.invokeLater(new CloseJNSplash());
    }

    private int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void message(String msg) {
        if (msg.equals("OFF")) {
            this.statusBar.setStringPainted(false);
            this.statusBar.setString("");
        } else {
            this.statusBar.setStringPainted(true);
            this.statusBar.setString(msg);
        }
    }

    @Override
    public void messageAction(Object deQ) {
        String msg = (String)deQ;
        if (msg.startsWith("SET ")) {
            int amount = this.parseInt(msg.substring(4));
            this.showStatus(amount);
        } else if (msg.startsWith("WIDTH ")) {
            int width = this.parseInt(msg.substring(6));
            this.setWidth(width);
        } else if (msg.equals("CLOSE")) {
            this.close();
        } else if (msg.equals("MESSAGE")) {
            this.message(msg.substring(8));
        }
    }

    class CloseJNSplash
    implements Runnable {
        CloseJNSplash() {
        }

        @Override
        public synchronized void run() {
            JSplashScreen.this.setVisible(false);
            JSplashScreen.this.dispose();
        }
    }
}

