/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.ui.ActionTriple;
import com.jbidwatcher.ui.FilterInterface;
import com.jbidwatcher.ui.PlusTabbedPane;
import com.jbidwatcher.ui.table.Selector;
import com.jbidwatcher.ui.util.JMouseAdapter;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.PlainMessageQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableRowSorter;

@Singleton
public class JTabManager
extends JMouseAdapter {
    private JTabbedPane mAuctionTypes;
    private Map<String, JTable> mNameTableMap = new TreeMap<String, JTable>();
    private FilterInterface mFilter;

    public void setFilterManager(FilterInterface filter) {
        this.mFilter = filter;
    }

    @Inject
    private JTabManager() {
        this.mAuctionTypes = new PlusTabbedPane();
        this.mAuctionTypes.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JTable ts = JTabManager.this.getCurrentTable();
                if (ts != null) {
                    ((TableRowSorter)ts.getRowSorter()).sort();
                }
            }
        });
    }

    public JTabbedPane getTabs() {
        return this.mAuctionTypes;
    }

    public void setTab(String tab) {
        int idx = this.mAuctionTypes.indexOfTab(tab);
        this.mAuctionTypes.setSelectedIndex(idx);
    }

    public void add(String tabName, JComponent tabComponent, JTable inTable) {
        this.mAuctionTypes.add(tabName, tabComponent);
        this.mNameTableMap.put(tabName, inTable);
    }

    public JTable getCurrentTable() {
        String title = this.getCurrentTableTitle();
        if (title == null) {
            return null;
        }
        return this.mNameTableMap.get(title);
    }

    public String getCurrentTableTitle() {
        int currentIndex = this.mAuctionTypes.getSelectedIndex();
        if (currentIndex == -1) {
            return null;
        }
        return this.mAuctionTypes.getTitleAt(currentIndex);
    }

    public int[] getPossibleRows() {
        return this.getCurrentTable().getSelectedRows();
    }

    public void deselect() {
        JTable curTable = this.getCurrentTable();
        curTable.clearSelection();
    }

    public void showEntry(AuctionEntry found) {
        this.setTab(found.getCategory());
        this.selectBySearch("~n" + found.getIdentifier());
        int[] rows = this.getCurrentTable().getSelectedRows();
        if (rows.length == 0) {
            this.mFilter.addAuction(found);
            this.setTab(found.getCategory());
            this.selectBySearch("~n" + found.getIdentifier());
            rows = this.getCurrentTable().getSelectedRows();
        }
        this.getCurrentTable().scrollRectToVisible(this.getCurrentTable().getCellRect(rows[0], 1, true));
        this.getCurrentTable().requestFocus();
    }

    public void selectBySearch(String srch) {
        mySelector mySelector2 = new mySelector(srch);
        JTable curTable = this.getCurrentTable();
        if (!mySelector2.select(curTable)) {
            Toolkit.getDefaultToolkit().beep();
            MQFactory.getConcrete("Swing").enqueue("No entries matched!");
        }
    }

    public Object getIndexedEntry(int i) {
        return this.getCurrentTable().getValueAt(i, -1);
    }

    public Object getObjectAt(JTable _table, int x, int y) {
        if (_table != null) {
            int rowPoint = _table.rowAtPoint(new Point(x, y));
            if (x == 0 && y == 0) {
                rowPoint = _table.getSelectedRow();
            }
            if (rowPoint != -1) {
                return _table.getValueAt(rowPoint, -1);
            }
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        AuctionEntry whichAuction = null;
        String actionString = event.getActionCommand();
        JTable chosenTable = this.getCurrentTable();
        boolean isButton = false;
        if (actionString.startsWith("BT-")) {
            actionString = actionString.substring(3);
            isButton = true;
        }
        if (chosenTable != null) {
            int[] temp;
            whichAuction = !isButton ? (AuctionEntry)this.getObjectAt(chosenTable, this.getPopupX(), this.getPopupY()) : ((temp = chosenTable.getSelectedRows()).length == 0 ? null : (AuctionEntry)chosenTable.getValueAt(temp[0], -1));
        }
        ((PlainMessageQueue)MQFactory.getConcrete("user")).enqueueObject(new ActionTriple(event.getSource(), actionString, whichAuction));
    }

    public void sortDefault() {
        JTable ts = this.getCurrentTable();
        if (ts != null) {
            ((TableRowSorter)ts.getRowSorter()).sort();
        }
    }

    public void updateTime(final JTable table) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (table.getModel().getRowCount() > 0) {
                    int firstRow = 0;
                    int lastRow = table.getRowCount() - 1;
                    int timeLeftColumn = table.getColumnModel().getColumnIndex("Time left");
                    if (firstRow == lastRow) {
                        table.tableChanged(new TableModelEvent(table.getModel(), 0, 0, timeLeftColumn));
                    } else {
                        table.tableChanged(new TableModelEvent(table.getModel(), firstRow, lastRow, timeLeftColumn));
                    }
                }
            }
        });
    }

    public void updateTime() {
        JTable ts = this.getCurrentTable();
        if (ts != null) {
            this.updateTime(ts);
        }
    }

    private class mySelector
    implements Selector {
        private String _search;

        mySelector(String s) {
            this._search = s;
        }

        @Override
        public boolean select(JTable inTable) {
            String trueSearch = this._search;
            boolean invert = false;
            if (trueSearch.startsWith("~!")) {
                invert = true;
                if ((trueSearch = trueSearch.substring(2)).startsWith(" ")) {
                    trueSearch = trueSearch.substring(1);
                }
            }
            boolean comment_t = false;
            boolean seller_t = false;
            boolean buyer_t = false;
            boolean all_t = false;
            boolean number_t = false;
            if (trueSearch.startsWith("~")) {
                if (trueSearch.startsWith("~a")) {
                    comment_t = true;
                    seller_t = true;
                    buyer_t = true;
                    all_t = true;
                }
                if (trueSearch.startsWith("~n")) {
                    number_t = true;
                }
                if (trueSearch.startsWith("~b")) {
                    buyer_t = true;
                }
                if (trueSearch.startsWith("~c")) {
                    comment_t = true;
                }
                if (trueSearch.startsWith("~s")) {
                    seller_t = true;
                }
                if (trueSearch.startsWith("~u")) {
                    buyer_t = true;
                    seller_t = true;
                }
                if (seller_t || buyer_t || comment_t || number_t) {
                    trueSearch = trueSearch.substring(2);
                }
                if (trueSearch.startsWith(" ")) {
                    trueSearch = trueSearch.substring(1);
                }
            }
            if (trueSearch.length() != 0) {
                trueSearch = "(?i).*" + trueSearch + ".*";
            }
            inTable.clearSelection();
            boolean foundOne = false;
            for (int i = 0; i < inTable.getRowCount(); ++i) {
                boolean match = false;
                AuctionEntry ae = (AuctionEntry)inTable.getValueAt(i, -1);
                if (seller_t) {
                    match = ae.getSellerName().matches(trueSearch);
                }
                if (!match && buyer_t && ae.getHighBidder() != null) {
                    match = ae.getHighBidder().matches(trueSearch);
                }
                if (!match && comment_t && ae.getComment() != null) {
                    match = ae.getComment().matches(trueSearch);
                }
                if (!match && number_t) {
                    match = ae.getIdentifier().matches(trueSearch);
                }
                if (!(match || !all_t && (seller_t || buyer_t || comment_t))) {
                    match = ae.getTitle().matches(trueSearch);
                }
                if (invert) {
                    boolean bl = match = !match;
                }
                if (!match) continue;
                inTable.addRowSelectionInterval(i, i);
                foundOne = true;
            }
            return foundOne;
        }
    }
}

