/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.config;

import com.jbidwatcher.ui.config.JConfigTab;
import com.jbidwatcher.ui.util.JPasteListener;
import com.jbidwatcher.ui.util.OptionUI;
import com.jbidwatcher.util.config.JConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class JConfigDatabaseTab
extends JConfigTab {
    private JRadioButton defaultDerbyDB;
    private JRadioButton mysqlDB;
    private OptionUI mOui = null;
    private JTextField mysqlHost;
    private JTextField mysqlPort;
    private JTextField mysqlDatabase;
    private JTextField mysqlUser;
    private JPasswordField mysqlPassword;

    public JConfigDatabaseTab(JPasteListener pasteListener) {
        this.pasteListener = pasteListener;
        JPanel topPanes = new JPanel();
        JPanel bottomPanes = new JPanel();
        this.setLayout(new BorderLayout());
        topPanes.setLayout(new GridLayout(1, 2));
        topPanes.add(JConfigDatabaseTab.panelPack(this.buildRadioButtons()));
        this.add((Component)topPanes, "North");
        bottomPanes.setLayout(new GridLayout(1, 2));
        bottomPanes.add(JConfigDatabaseTab.panelPack(this.buildMySQLPanel()));
        this.add((Component)bottomPanes, "Center");
        this.updateValues();
    }

    @Override
    public String getTabName() {
        return "Database";
    }

    @Override
    public void cancel() {
        this.updateValues();
    }

    @Override
    public void apply() {
        if (this.defaultDerbyDB.isSelected()) {
            if (JConfig.queryConfiguration("temp.db.switch2derby") != null) {
                JConfig.kill("temp.db.switch2derby");
            }
            if (JConfig.queryConfiguration("db.protocol", "jdbc:derby:").contains("mysql")) {
                JConfig.setConfiguration("temp.db.switch2derby", "true");
            }
            JConfig.kill("temp.db.protocol");
            JConfig.kill("temp.db.driver");
            JConfig.kill("temp.db.user");
            JConfig.kill("temp.db.pass");
        } else if (this.mysqlDB.isSelected()) {
            Integer portNum;
            if (!JConfig.queryConfiguration("db.protocol", "jdbc:derby:").contains("mysql")) {
                JConfig.setConfiguration("temp.db.switch2derby", "false");
            }
            String host = this.mysqlHost.getText();
            String port = this.mysqlPort.getText();
            try {
                portNum = Integer.parseInt(port);
            }
            catch (Exception e) {
                portNum = -1;
            }
            String db = this.mysqlDatabase.getText();
            String connectURL = "jdbc:mysql://" + host;
            if (portNum != -1) {
                connectURL = connectURL + ":" + portNum;
            }
            connectURL = connectURL + "/";
            JConfig.setConfiguration("db.mysql.host", host);
            JConfig.setConfiguration("db.mysql.port", port);
            JConfig.setConfiguration("db.mysql.database", db);
            JConfig.setConfiguration("temp.db.framework", "remote");
            JConfig.setConfiguration("temp.db.protocol", connectURL);
            JConfig.setConfiguration("temp.db.driver", "com.mysql.jdbc.Driver");
            JConfig.setConfiguration("temp.db.user", this.mysqlUser.getText());
            JConfig.setConfiguration("temp.db.pass", new String(this.mysqlPassword.getPassword()));
        }
        if (JConfig.queryConfiguration("temp.db.switch2derby") != null) {
            if (this.mOui == null) {
                this.mOui = new OptionUI();
            }
            this.mOui.promptWithCheckbox(null, "You will have to shut down JBidwatcher and restart for the database change to take effect.", "JBidwatcher restart required", "prompt.db_change_restart");
        }
    }

    private String getConfigValue(JToggleButton jrb, String configValue, String defaultValue) {
        if (jrb.isSelected()) {
            if (defaultValue == null) {
                String outputValue = JConfig.queryConfiguration(configValue);
                if (outputValue == null) {
                    return "";
                }
                return outputValue;
            }
            return defaultValue;
        }
        return "<disabled>";
    }

    @Override
    public final void updateValues() {
        this.mysqlHost.setEnabled(this.mysqlDB.isSelected());
        this.mysqlHost.setText(this.getConfigValue(this.mysqlDB, "db.mysql.host", "localhost"));
        this.mysqlPort.setEnabled(this.mysqlDB.isSelected());
        this.mysqlPort.setText(this.getConfigValue(this.mysqlDB, "db.mysql.port", "3306"));
        this.mysqlDatabase.setEnabled(this.mysqlDB.isSelected());
        this.mysqlDatabase.setText(this.getConfigValue(this.mysqlDB, "db.mysql.database", "jbidwatcher"));
        this.mysqlUser.setEnabled(this.mysqlDB.isSelected());
        this.mysqlUser.setText(this.getConfigValue(this.mysqlDB, "db.user", "root"));
        this.mysqlPassword.setEnabled(this.mysqlDB.isSelected());
        this.mysqlPassword.setText(this.getConfigValue(this.mysqlDB, "db.pass", ""));
    }

    private JPanel buildRadioButtons() {
        radioAction rad = new radioAction();
        JPanel buttonPanel = new JPanel();
        Box buttonBox = Box.createVerticalBox();
        this.defaultDerbyDB = new JRadioButton("Use default embedded Derby DB");
        this.mysqlDB = new JRadioButton("Use remote MySQL database");
        String protocol = JConfig.queryConfiguration("db.protocol");
        if (protocol == null || !protocol.toLowerCase().contains("mysql")) {
            this.defaultDerbyDB.setSelected(true);
            this.mysqlDB.setSelected(false);
        } else {
            this.defaultDerbyDB.setSelected(false);
            this.mysqlDB.setSelected(true);
        }
        ButtonGroup allButtons = new ButtonGroup();
        allButtons.add(this.defaultDerbyDB);
        allButtons.add(this.mysqlDB);
        this.defaultDerbyDB.addActionListener(rad);
        this.mysqlDB.addActionListener(rad);
        buttonPanel.setBorder(BorderFactory.createTitledBorder("Database Settings"));
        buttonPanel.setLayout(new BorderLayout());
        buttonBox.add(this.defaultDerbyDB);
        buttonBox.add(this.mysqlDB);
        buttonPanel.add((Component)buttonBox, "North");
        return buttonPanel;
    }

    private JPanel buildMySQLPanel() {
        JPanel proxyPanel = new JPanel();
        proxyPanel.setBorder(BorderFactory.createTitledBorder("MySQL Settings"));
        proxyPanel.setLayout(new BoxLayout(proxyPanel, 1));
        this.mysqlHost = new JTextField();
        this.mysqlPort = new JTextField();
        this.mysqlDatabase = new JTextField();
        this.mysqlUser = new JTextField();
        this.mysqlPassword = new JPasswordField();
        this.adjustField(this.mysqlHost, "Host name or IP address of MySQL server", null);
        this.adjustField(this.mysqlPort, "Port number for MySQL server (default: 3306)", null);
        this.adjustField(this.mysqlDatabase, "The database on the server to use (default: jbidwatcher)", null);
        this.adjustField(this.mysqlUser, "Username (if needed) for MySQL server", null);
        this.adjustField(this.mysqlPassword, "Password (if needed) for MySQL server", null);
        proxyPanel.add(JConfigDatabaseTab.makeLine(new JLabel("MySQL Host: "), this.mysqlHost));
        proxyPanel.add(JConfigDatabaseTab.makeLine(new JLabel("MySQL Port: "), this.mysqlPort));
        proxyPanel.add(JConfigDatabaseTab.makeLine(new JLabel("Database:   "), this.mysqlDatabase));
        proxyPanel.add(JConfigDatabaseTab.makeLine(new JLabel("Username:   "), this.mysqlUser));
        proxyPanel.add(JConfigDatabaseTab.makeLine(new JLabel("Password:   "), this.mysqlPassword));
        return proxyPanel;
    }

    private class radioAction
    implements ActionListener {
        private radioAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JConfigDatabaseTab.this.updateValues();
        }
    }
}

