/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.table;

import com.jbidwatcher.search.SearchManager;
import com.jbidwatcher.search.Searcher;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.table.AbstractTableModel;

public class SearchTableModel
extends AbstractTableModel {
    private final SearchManager searchManager;
    String[] column_names = new String[]{"Name", "Type", "Search Value", "Site", "Repeat Time", "Next Run"};

    @Override
    public int getRowCount() {
        return this.searchManager.getSearchCount();
    }

    @Override
    public int getColumnCount() {
        return this.column_names.length;
    }

    @Override
    public String getColumnName(int index) {
        return this.column_names[index];
    }

    public int getColumnNumber(String colName) {
        for (int i = 0; i < this.column_names.length; ++i) {
            if (!colName.equals(this.column_names[i])) continue;
            return i;
        }
        return -1;
    }

    public Class getColumnClass(int i) {
        return String.class;
    }

    public Class getSortByColumnClass(int i) {
        if (i == 5) {
            return Long.class;
        }
        if (i == 4) {
            return Integer.class;
        }
        return this.getColumnClass(i);
    }

    public Object getSortByValueAt(int i, int j) {
        Searcher s = this.searchManager.getSearchByIndex(i);
        switch (j) {
            case -1: {
                return s;
            }
            case 0: {
                return s.getName();
            }
            case 1: {
                return s.getTypeName();
            }
            case 2: {
                return s.getSearch();
            }
            case 3: {
                return s.getServer();
            }
            case 4: {
                return s.getPeriod();
            }
            case 5: {
                return s.getLastRun() + (long)(s.getPeriod() * 3600000);
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int i, int j) {
        Searcher s = this.searchManager.getSearchByIndex(i);
        switch (j) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.getSortByValueAt(i, j);
            }
            case 4: {
                return this.formattedPeriod(s);
            }
            case 5: {
                return this.dateFormat(s);
            }
        }
        return null;
    }

    private Object formattedPeriod(Searcher s) {
        int period = s.getPeriod();
        if (period == -1) {
            return "None";
        }
        if (period < 24) {
            return period + " hour" + (period != 1 ? "s" : "");
        }
        if (period % 24 == 0) {
            return period / 24 + " day" + (period != 24 ? "s" : "");
        }
        String result = period / 24 + " day" + (period > 48 ? "s" : "");
        result = result + ", " + period % 24 + " hour" + (period % 24 != 1 ? "s" : "");
        return result;
    }

    public String dateFormat(Searcher s) {
        if (s.getPeriod() == -1) {
            return "Never";
        }
        if (!s.isEnabled()) {
            return "Disabled";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("MM.dd/yyyy @ hh:mm");
        long base = s.getLastRun();
        if (base == 0L) {
            base = System.currentTimeMillis();
        }
        return sdf.format(new Date(base += (long)(s.getPeriod() * 3600000)));
    }

    public SearchTableModel(SearchManager searchManager) {
        this.searchManager = searchManager;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void delete(int row) {
        this.searchManager.deleteSearch(this.searchManager.getSearchByIndex(row));
    }

    public int insert(Object newObj) {
        this.searchManager.addSearch((Searcher)newObj);
        return this.getRowCount() - 1;
    }
}

