/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util.queue;

import com.jbidwatcher.util.config.JConfig;

public class TimerHandler
extends Thread {
    private static final int ALMOST_A_SECOND = 990;
    private WakeupProcess _toWake = null;
    private volatile boolean _remainAsleep = false;
    private long _sleep_ms = 990L;

    public TimerHandler(WakeupProcess inWake, long sleeptime) {
        this._toWake = inWake;
        this._sleep_ms = sleeptime;
        this.setDaemon(true);
    }

    public TimerHandler(WakeupProcess inWake) {
        this._toWake = inWake;
        this.setDaemon(true);
    }

    public void pause() {
        this._remainAsleep = true;
    }

    public void unpause() {
        this._remainAsleep = false;
    }

    public boolean isPaused() {
        return this._remainAsleep;
    }

    @Override
    public void run() {
        JConfig.registerTimer(this);
        boolean interrupted = false;
        while (!interrupted) {
            if (Thread.interrupted()) {
                interrupted = true;
                continue;
            }
            try {
                TimerHandler.sleep(this._sleep_ms);
                if (this._remainAsleep) continue;
                this._toWake.check();
            }
            catch (InterruptedException ignored) {
                interrupted = true;
            }
            catch (Exception e) {
                JConfig.log().handleException("Exception during the check() operation of " + this._toWake.getClass().toString(), e);
            }
            catch (Error e) {
                JConfig.log().handleException("Serious error, consider dying.", e);
            }
        }
    }

    public static interface WakeupProcess {
        public boolean check() throws InterruptedException;
    }
}

