/*
 * Decompiled with CFR 0.152.
 */
package com.orbus.mahalo.tasks;

import com.orbus.mahalo.HostInfo;
import com.orbus.mahalo.MahaloSocket;
import com.orbus.mahalo.ServiceInfo;
import com.orbus.mahalo.ServiceState;
import com.orbus.mahalo.dns.DNSEntry;
import com.orbus.mahalo.dns.DNSPacket;
import com.orbus.mahalo.dns.DNSQuestion;
import com.orbus.mahalo.dns.DNSRecord;
import com.orbus.mahalo.tasks.Announcer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Prober
extends TimerTask {
    public static final int INTERVAL = 250;
    private static final Random s_Random = new Random();
    private MahaloSocket _Socket;
    private Timer _Timer;
    private HostInfo _HostInfo;
    private List<ServiceInfo> _ProbeList;

    public Prober(MahaloSocket aSocket, Timer aTimer, HostInfo aHostInfo, Collection<ServiceInfo> aProbeList) {
        this._Socket = aSocket;
        this._Timer = aTimer;
        this._HostInfo = aHostInfo;
        this._ProbeList = aProbeList != null ? new ArrayList<ServiceInfo>(aProbeList) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LinkedList<ServiceInfo> announceList = new LinkedList<ServiceInfo>();
        DNSPacket outPacket = new DNSPacket(false);
        if (this._HostInfo.getState().isProbing()) {
            HostInfo hostInfo = this._HostInfo;
            synchronized (hostInfo) {
                DNSQuestion question = new DNSQuestion(this._HostInfo.getName(), DNSEntry.EntryType.ANY, DNSEntry.EntryClass.IN, false);
                if (this._HostInfo.getState() == ServiceState.PROBING_1 || this._HostInfo.getState() == ServiceState.PROBING_2) {
                    question.setWantsUnicastResponce(true);
                }
                outPacket.addQuestion(question);
                DNSRecord.Address answer = this._HostInfo.getDNSAddressRecord(DNSEntry.EntryType.A);
                if (answer != null) {
                    outPacket.addAnswer(answer);
                }
                this._HostInfo.advanceState();
            }
        }
        if (this._ProbeList != null && this._ProbeList.size() > 0) {
            for (ServiceInfo info : this._ProbeList) {
                if (!info.getState().isProbing()) continue;
                ServiceInfo serviceInfo = info;
                synchronized (serviceInfo) {
                    DNSQuestion question = new DNSQuestion(info.getQualifiedName(), DNSEntry.EntryType.ANY, DNSEntry.EntryClass.IN, false);
                    if (info.getState() == ServiceState.PROBING_1 || info.getState() == ServiceState.PROBING_2) {
                        question.setWantsUnicastResponce(true);
                    }
                    outPacket.addQuestion(question);
                    outPacket.addAnswer(new DNSRecord.Service(info.getQualifiedName(), DNSEntry.EntryClass.IN, false, 3600, info.getPriority(), info.getWeight(), info.getPort(), this._HostInfo.getName()));
                    info.advanceState();
                    if (info.getState().isAnnouncing()) {
                        announceList.add(info);
                    }
                }
            }
            for (ServiceInfo info : announceList) {
                this._ProbeList.remove(info);
            }
        }
        if (outPacket.getQuestions().size() != 0) {
            this._Socket.send(outPacket);
        } else {
            this.cancel();
        }
        if (announceList.size() > 0) {
            this._Timer.schedule((TimerTask)new Announcer(this._Socket, this._HostInfo, announceList), 1000L, 1000L);
        }
    }

    public static int GetStartProbeTime() {
        return s_Random.nextInt(250);
    }
}

