/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.IOException;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.EndOfFile;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.StreamError;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class ConcatenatedStream
extends Stream {
    LispObject streams;
    private static final Primitive MAKE_CONCATENATED_STREAM = new Primitive("make-concatenated-stream", "&rest streams"){

        public LispObject execute(LispObject[] args) {
            LispObject streams = Lisp.NIL;
            for (int i = 0; i < args.length; ++i) {
                Stream stream;
                if (args[i] instanceof Stream && (stream = (Stream)args[i]).isInputStream()) {
                    streams = new Cons(stream, streams);
                    continue;
                }
                Lisp.error(new TypeError(String.valueOf(args[i]) + " is not an input stream."));
            }
            return new ConcatenatedStream(streams.nreverse());
        }
    };
    private static final Primitive CONCATENATED_STREAM_STREAMS = new Primitive("concatenated-stream-streams", "concatenated-stream"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof ConcatenatedStream) {
                return ((ConcatenatedStream)arg).streams;
            }
            return Lisp.type_error(arg, Symbol.CONCATENATED_STREAM);
        }
    };

    ConcatenatedStream(LispObject streams) {
        super(Symbol.CONCATENATED_STREAM);
        this.streams = streams;
        this.isInputStream = true;
    }

    public boolean isCharacterInputStream() {
        if (this.streams == Lisp.NIL) {
            return true;
        }
        return ((Stream)this.streams.car()).isCharacterInputStream();
    }

    public boolean isBinaryInputStream() {
        if (this.streams == Lisp.NIL) {
            return true;
        }
        return ((Stream)this.streams.car()).isBinaryInputStream();
    }

    public boolean isCharacterOutputStream() {
        return false;
    }

    public boolean isBinaryOutputStream() {
        return false;
    }

    public LispObject typeOf() {
        return Symbol.CONCATENATED_STREAM;
    }

    public LispObject classOf() {
        return BuiltInClass.CONCATENATED_STREAM;
    }

    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.CONCATENATED_STREAM) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.CONCATENATED_STREAM) {
            return Lisp.T;
        }
        return super.typep(typeSpecifier);
    }

    public LispObject getElementType() {
        if (this.streams == Lisp.NIL) {
            return Lisp.NIL;
        }
        return ((Stream)this.streams.car()).getElementType();
    }

    public LispObject readCharNoHang(boolean eofError, LispObject eofValue) {
        if (this.streams == Lisp.NIL) {
            if (eofError) {
                return Lisp.error(new EndOfFile(this));
            }
            return eofValue;
        }
        try {
            return this._charReady() ? this.readChar(eofError, eofValue) : Lisp.NIL;
        }
        catch (IOException e) {
            return Lisp.error(new StreamError((Stream)this, e));
        }
    }

    public LispObject listen() {
        if (this.streams == Lisp.NIL) {
            return Lisp.NIL;
        }
        Stream stream = (Stream)this.streams.car();
        return stream.listen();
    }

    protected int _readChar() throws IOException {
        if (this.streams == Lisp.NIL) {
            return -1;
        }
        Stream stream = (Stream)this.streams.car();
        int n = stream._readChar();
        if (n >= 0) {
            return n;
        }
        this.streams = this.streams.cdr();
        return this._readChar();
    }

    protected void _unreadChar(int n) throws IOException {
        if (this.streams == Lisp.NIL) {
            Lisp.error(new StreamError((Stream)this, "UNREAD-CHAR was invoked without a stream to unread into."));
        }
        Stream stream = (Stream)this.streams.car();
        stream._unreadChar(n);
    }

    protected boolean _charReady() throws IOException {
        if (this.streams == Lisp.NIL) {
            return false;
        }
        Stream stream = (Stream)this.streams.car();
        if (stream._charReady()) {
            return true;
        }
        for (LispObject remainingStreams = this.streams.cdr(); remainingStreams != Lisp.NIL; remainingStreams = remainingStreams.cdr()) {
            stream = (Stream)remainingStreams.car();
            if (!stream._charReady()) continue;
            return true;
        }
        return false;
    }

    public void _writeChar(char c) {
        this.outputStreamError();
    }

    public void _writeChars(char[] chars, int start, int end) {
        this.outputStreamError();
    }

    public void _writeString(String s) {
        this.outputStreamError();
    }

    public void _writeLine(String s) {
        this.outputStreamError();
    }

    public int _readByte() {
        if (this.streams == Lisp.NIL) {
            return -1;
        }
        Stream stream = (Stream)this.streams.car();
        int n = stream._readByte();
        if (n >= 0) {
            return n;
        }
        this.streams = this.streams.cdr();
        return this._readByte();
    }

    public void _writeByte(int n) {
        this.outputStreamError();
    }

    public void _finishOutput() {
        this.outputStreamError();
    }

    public void _clearInput() {
    }

    private void outputStreamError() {
        Lisp.error(new StreamError((Stream)this, String.valueOf(this) + " is not an output stream."));
    }
}

