/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.CapitalizeFirstStream;
import org.armedbear.lisp.CapitalizeStream;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.DowncaseStream;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;
import org.armedbear.lisp.UpcaseStream;

public abstract class CaseFrobStream
extends Stream {
    protected final Stream target;
    private static final Primitive MAKE_CASE_FROB_STREAM = new Primitive("make-case-frob-stream", Lisp.PACKAGE_SYS, false, "target kind"){

        public LispObject execute(LispObject first, LispObject second) {
            Stream target = Lisp.checkCharacterOutputStream(first);
            if (second == Keyword.UPCASE) {
                return new UpcaseStream(target);
            }
            if (second == Keyword.DOWNCASE) {
                return new DowncaseStream(target);
            }
            if (second == Keyword.CAPITALIZE) {
                return new CapitalizeStream(target);
            }
            if (second == Keyword.CAPITALIZE_FIRST) {
                return new CapitalizeFirstStream(target);
            }
            return Lisp.error(new TypeError("Kind must be :UPCASE, :DOWNCASE, :CAPITALIZE or :CAPITALIZE-FIRST."));
        }
    };

    protected CaseFrobStream(Stream target) {
        super(Symbol.CASE_FROB_STREAM);
        Debug.assertTrue(target.isCharacterOutputStream());
        this.target = target;
    }

    public LispObject getElementType() {
        return this.target.getElementType();
    }

    public LispObject typeOf() {
        return Symbol.CASE_FROB_STREAM;
    }

    public LispObject classOf() {
        return BuiltInClass.CASE_FROB_STREAM;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.CASE_FROB_STREAM) {
            return Lisp.T;
        }
        if (type == BuiltInClass.CASE_FROB_STREAM) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public boolean isInputStream() {
        return false;
    }

    public boolean isOutputStream() {
        return true;
    }

    public boolean isCharacterInputStream() {
        return false;
    }

    public boolean isBinaryInputStream() {
        return false;
    }

    public boolean isCharacterOutputStream() {
        return true;
    }

    public boolean isBinaryOutputStream() {
        return false;
    }

    public int getCharPos() {
        return this.target.getCharPos();
    }

    public void setCharPos(int n) {
        this.target.setCharPos(n);
    }

    protected int _readChar() {
        this.notSupported();
        return -1;
    }

    protected void _unreadChar(int n) {
        this.notSupported();
    }

    protected boolean _charReady() {
        this.notSupported();
        return false;
    }

    public void _writeChars(char[] chars, int start, int end) {
        this._writeString(new String(chars, start, end));
    }

    public int _readByte() {
        this.notSupported();
        return -1;
    }

    public void _writeByte(int n) {
        this.notSupported();
    }

    public void _finishOutput() {
        this.target._finishOutput();
    }

    public void _clearInput() {
        this.notSupported();
    }

    public LispObject close(LispObject abort) {
        this.setOpen(false);
        return Lisp.T;
    }

    public LispObject listen() {
        this.notSupported();
        return Lisp.NIL;
    }

    public LispObject terpri() {
        return this.target.terpri();
    }

    public LispObject freshLine() {
        return this.target.freshLine();
    }

    public String printObject() {
        return this.unreadableString("CASE-FROB-STREAM");
    }

    private void notSupported() {
        Lisp.error(new TypeError("Operation is not supported for streams of type CASE-FROB-STREAM."));
    }
}

