/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;

public final class SiteName {
    private static final Primitive MACHINE_INSTANCE = new Primitive("machine-instance"){

        public LispObject execute() {
            return SiteName.getHostName();
        }
    };
    private static final Primitive LONG_SITE_NAME = new Primitive("long-site-name"){

        public LispObject execute() {
            return SiteName.getHostName();
        }
    };
    private static final Primitive SHORT_SITE_NAME = new Primitive("short-site-name"){

        public LispObject execute() {
            return SiteName.getHostName();
        }
    };

    static LispObject getHostName() {
        InetAddress addr;
        String hostName = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            addr = null;
        }
        if (addr != null) {
            hostName = addr.getHostName();
        }
        return hostName != null ? new SimpleString(hostName) : Lisp.NIL;
    }
}

