/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import org.armedbear.lisp.Debug;

public class HttpHead {
    private static String get(String urlString, String key) throws IOException {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            HttpHead.log("Failed to form url from '" + urlString + "'" + ": " + e);
        }
        return HttpHead.get(url, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static String get(URL url, String key) throws IOException {
        String result;
        block19: {
            Socket socket;
            block16: {
                String string;
                String line;
                socket = null;
                result = null;
                String protocol = url.getProtocol();
                if (protocol.equals("http")) break block17;
                HttpHead.log("The protocol '" + protocol + "'" + " is not http.");
                String string2 = result;
                Object var16_7 = null;
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                {
                    block17: {
                        return string2;
                    }
                    String host = url.getHost();
                    int port = url.getPort();
                    if (port == -1) {
                        port = 80;
                    }
                    socket = new Socket(host, port);
                    PrintWriter out = null;
                    BufferedReader in = null;
                    try {
                        socket.setSoTimeout(5000);
                        out = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream()), true);
                        in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    }
                    catch (IOException e) {
                        HttpHead.log("Failed to establish socket io: " + e);
                        String string3 = result;
                        Object var16_8 = null;
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return string3;
                    }
                    String CRLF = "\r\n";
                    String head = "HEAD " + url.getPath() + " HTTP/1.1";
                    out.print(head + CRLF);
                    out.print("Host: " + url.getAuthority() + CRLF);
                    out.print("Connection: close" + CRLF);
                    out.print(CRLF);
                    out.flush();
                    line = null;
                    try {
                        line = in.readLine();
                    }
                    catch (IOException e) {
                        HttpHead.log("Failed to read HTTP response: " + e);
                    }
                    if (line == null) {
                        throw new IOException("Could not access URL to parse headers.");
                    }
                    String[] status = line.split("\\s");
                    if (status[1].equals("200")) {
                        result = HttpHead.findHeader(in, key);
                        break block16;
                    }
                    if (!status[1].startsWith("3")) break block18;
                    String location = HttpHead.findHeader(in, "Location");
                    if (location == null) break block16;
                    string = HttpHead.get(location, key);
                }
                Object var16_9 = null;
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                {
                    block18: {
                        return string;
                    }
                    HttpHead.log("Unexpected response: " + line);
                }
            }
            Object var16_10 = null;
            try {
                socket.close();
            }
            catch (IOException iOException) {}
            break block19;
            catch (Throwable throwable) {
                Object var16_11 = null;
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return result;
    }

    private static String findHeader(BufferedReader in, String key) {
        String result = null;
        try {
            String line;
            while ((line = in.readLine()) != null) {
                int i = line.indexOf(":");
                if (i == -1) continue;
                String k = line.substring(0, i);
                String v = line.substring(i + 1).trim();
                if (!k.equals(key)) continue;
                result = v;
                break;
            }
        }
        catch (IOException e) {
            HttpHead.log("Failed to read headers: " + e);
        }
        return result;
    }

    private static void log(String message) {
        Debug.warn(message);
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.out.println("Usage: <cmd> URL");
            return;
        }
        String modified = null;
        try {
            modified = HttpHead.get(argv[0], "Last-Modified");
        }
        catch (IOException ex) {
            System.err.println("Unable to get Last-Modified header: ");
            ex.printStackTrace(System.err);
        }
        if (modified != null) {
            System.out.println("Last-Modified: " + modified);
        } else {
            System.out.println("No result returned.");
        }
    }
}

