/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileAssemblySimple
implements Ftile {
    private final Ftile tile1;
    private final Ftile tile2;
    private FtileGeometry calculateDimension;
    private Dimension2D calculateDimensionInternal;

    public String toString() {
        return "FtileAssemblySimple " + this.tile1 + " && " + this.tile2;
    }

    public FtileAssemblySimple(Ftile ftile, Ftile ftile2) {
        this.tile1 = ftile;
        this.tile2 = ftile2;
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile1.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile2.getSwimlaneOut();
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        if (ftile == this.tile1) {
            return this.getTranslated1(stringBounder);
        }
        if (ftile == this.tile2) {
            return this.getTranslated2(stringBounder);
        }
        UTranslate uTranslate = this.tile1.getTranslateFor(ftile, stringBounder);
        if (uTranslate != null) {
            return uTranslate.compose(this.getTranslated1(stringBounder));
        }
        uTranslate = this.tile2.getTranslateFor(ftile, stringBounder);
        if (uTranslate != null) {
            return uTranslate.compose(this.getTranslated2(stringBounder));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic.apply(this.getTranslated1(stringBounder)).draw(this.tile1);
        uGraphic.apply(this.getTranslated2(stringBounder)).draw(this.tile2);
    }

    @Override
    public boolean isKilled() {
        return this.tile1.isKilled() || this.tile2.isKilled();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.tile1.getInLinkRendering();
    }

    @Override
    public LinkRendering getOutLinkRendering() {
        return null;
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        if (this.calculateDimension == null) {
            this.calculateDimension = this.calculateDimensionSlow(stringBounder);
        }
        return this.calculateDimension;
    }

    private FtileGeometry calculateDimensionSlow(StringBounder stringBounder) {
        UTranslate uTranslate = this.getTranslated1(stringBounder);
        UTranslate uTranslate2 = this.getTranslated2(stringBounder);
        FtileGeometry ftileGeometry = this.tile1.calculateDimension(stringBounder).translate(uTranslate);
        FtileGeometry ftileGeometry2 = this.tile2.calculateDimension(stringBounder).translate(uTranslate2);
        if (!ftileGeometry2.hasPointOut()) {
            return new FtileGeometry(this.calculateDimensionInternal(stringBounder), ftileGeometry.getLeft(), ftileGeometry.getInY());
        }
        if (ftileGeometry.getLeft() != ftileGeometry2.getLeft()) {
            throw new IllegalStateException();
        }
        return new FtileGeometry(this.calculateDimensionInternal(stringBounder), ftileGeometry.getLeft(), ftileGeometry.getInY(), ftileGeometry2.getOutY());
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        if (this.calculateDimensionInternal == null) {
            this.calculateDimensionInternal = this.calculateDimensionInternalSlow(stringBounder);
        }
        return this.calculateDimensionInternal;
    }

    private Dimension2D calculateDimensionInternalSlow(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.tile1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.tile2.calculateDimension(stringBounder);
        return Dimension2DDouble.mergeTB(ftileGeometry, ftileGeometry2);
    }

    private UTranslate getTranslated1(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry = this.tile1.calculateDimension(stringBounder);
        double d = dimension2D.getWidth() - ((Dimension2D)ftileGeometry).getWidth();
        return new UTranslate(d / 2.0, 0.0);
    }

    private UTranslate getTranslated2(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry = this.tile1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.tile2.calculateDimension(stringBounder);
        double d = dimension2D.getWidth() - ((Dimension2D)ftileGeometry2).getWidth();
        return new UTranslate(d / 2.0, ((Dimension2D)ftileGeometry).getHeight());
    }

    @Override
    public Collection<Connection> getInnerConnections() {
        return Collections.emptyList();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        hashSet.addAll(this.tile1.getSwimlanes());
        hashSet.addAll(this.tile2.getSwimlanes());
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public boolean shadowing() {
        return this.tile1.shadowing() || this.tile2.shadowing();
    }
}

