/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.util.GregorianCalendar;
import net.sourceforge.plantuml.project.DayClose;
import net.sourceforge.plantuml.project.Month;
import net.sourceforge.plantuml.project.WeekDay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Day
implements Comparable<Day> {
    private final int numDay;
    private final Month month;
    private final int year;
    private final WeekDay weekDay;

    private Day(int n, Month month, int n2, WeekDay weekDay) {
        this.year = n;
        this.month = month;
        this.numDay = n2;
        this.weekDay = weekDay;
    }

    public static boolean isValidDesc(String string) {
        if (string.matches("^\\d{4}/\\d{2}/\\d{2}$")) {
            return true;
        }
        return string.matches("^\\d{2}-[A-Za-z]{3}-\\d{4}$");
    }

    public Day(String string) {
        if (string.matches("^\\d{4}/\\d{2}/\\d{2}$")) {
            this.year = Integer.parseInt(string.substring(0, 4));
            this.month = Month.fromNum(Integer.parseInt(string.substring(5, 7)));
            this.numDay = Integer.parseInt(string.substring(8, 10));
        } else if (string.matches("^\\d{2}-[A-Za-z]{3}-\\d{4}$")) {
            this.year = Integer.parseInt(string.substring(7, 11));
            this.month = Month.valueOf(string.substring(3, 6));
            this.numDay = Integer.parseInt(string.substring(0, 2));
        } else {
            throw new IllegalArgumentException(string);
        }
        int n = new GregorianCalendar(this.year, this.month.getNum() - 1, this.numDay).get(7);
        this.weekDay = WeekDay.values()[n - 1];
    }

    public Day next(DayClose dayClose) {
        if (dayClose == null) {
            return this.nextInternal();
        }
        if (dayClose.isClose(this)) {
            throw new IllegalArgumentException();
        }
        Day day = this.nextInternal();
        while (dayClose.isClose(day)) {
            day = day.nextInternal();
        }
        return day;
    }

    public Day prev(DayClose dayClose) {
        if (dayClose == null) {
            return this.prevInternal();
        }
        if (dayClose.isClose(this)) {
            throw new IllegalArgumentException();
        }
        Day day = this.prevInternal();
        while (dayClose.isClose(day)) {
            day = day.prevInternal();
        }
        return day;
    }

    private Day nextInternal() {
        if (this.numDay < this.month.getNbDays(this.year)) {
            return new Day(this.year, this.month, this.numDay + 1, this.weekDay.next());
        }
        Month month = this.month.next();
        if (month == null) {
            return new Day(this.year + 1, Month.JAN, 1, this.weekDay.next());
        }
        return new Day(this.year, month, 1, this.weekDay.next());
    }

    private Day prevInternal() {
        if (this.numDay > 1) {
            return new Day(this.year, this.month, this.numDay - 1, this.weekDay.prev());
        }
        Month month = this.month.prev();
        if (month == null) {
            return new Day(this.year - 1, Month.DEC, 31, this.weekDay.prev());
        }
        return new Day(this.year, month, month.getNbDays(this.year), this.weekDay.prev());
    }

    public String toString() {
        return "" + (Object)((Object)this.weekDay) + " " + this.year + "-" + (Object)((Object)this.month) + "-" + String.format("%02d", this.numDay);
    }

    public final int getNumDay() {
        return this.numDay;
    }

    public final Month getMonth() {
        return this.month;
    }

    public final int getYear() {
        return this.year;
    }

    @Override
    public int compareTo(Day day) {
        if (this.year > day.year) {
            return 1;
        }
        if (this.year < day.year) {
            return -1;
        }
        int n = this.month.compareTo(day.month);
        if (n != 0) {
            return n;
        }
        return this.numDay - day.numDay;
    }

    public boolean equals(Object object) {
        Day day = (Day)object;
        return this.numDay == day.numDay && this.month == day.month && this.year == day.year;
    }

    public int hashCode() {
        return this.numDay * 420 + this.year + this.month.hashCode();
    }

    public final WeekDay getWeekDay() {
        return this.weekDay;
    }
}

