/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction;

import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.db.ActiveRecord;
import com.jbidwatcher.util.db.Table;
import java.io.File;
import java.util.Date;
import java.util.List;

public class DeletedEntry
extends ActiveRecord {
    private static Table sDB = null;

    public DeletedEntry() {
    }

    public static DeletedEntry create(String identifier) {
        DeletedEntry d = new DeletedEntry(identifier);
        d.saveDB();
        return d;
    }

    private DeletedEntry(String identifier) {
        this.setString("identifier", identifier);
        this.setDate("created_at", new Date());
        this.killFiles(identifier);
    }

    protected static String getTableName() {
        return "deleted";
    }

    @Override
    protected Table getDatabase() {
        return DeletedEntry.getRealDatabase();
    }

    protected static Table getRealDatabase() {
        if (sDB == null) {
            sDB = DeletedEntry.openDB(DeletedEntry.getTableName());
        }
        return sDB;
    }

    private void killFiles(String id) {
        File htmlBackup;
        String imgPath = DeletedEntry.deleteThumbnails(id);
        if (imgPath == null) {
            return;
        }
        File html = new File(imgPath + ".html.gz");
        if (html.exists()) {
            html.delete();
        }
        if ((htmlBackup = new File(imgPath + ".html.gz~")).exists()) {
            htmlBackup.delete();
        }
    }

    public static String deleteThumbnails(String id) {
        File badBlocker;
        File realThumb;
        String outPath = JConfig.queryConfiguration("auctions.savepath");
        if (outPath == null || outPath.length() == 0) {
            return null;
        }
        String imgPath = outPath + System.getProperty("file.separator") + id;
        File thumb = new File(imgPath + ".jpg");
        if (thumb.exists()) {
            thumb.delete();
        }
        if ((realThumb = new File(imgPath + "_t.jpg")).exists()) {
            realThumb.delete();
        }
        if ((badBlocker = new File(imgPath + "_b.jpg")).exists()) {
            badBlocker.delete();
        }
        return imgPath;
    }

    public static DeletedEntry findByIdentifier(String identifier) {
        return (DeletedEntry)DeletedEntry.findFirstBy(DeletedEntry.class, "identifier", identifier);
    }

    public static int clear() {
        int total = DeletedEntry.getRealDatabase().count();
        if (DeletedEntry.getRealDatabase().deleteBy("1=1")) {
            return total;
        }
        return 0;
    }

    public static void remove(String identifier) {
        List<? extends ActiveRecord> found = DeletedEntry.findAllBy(DeletedEntry.class, "identifier", identifier);
        if (found != null) {
            for (ActiveRecord activeRecord : found) {
                activeRecord.delete();
            }
        }
    }

    public static boolean exists(String identifier) {
        return JConfig.queryConfiguration("deleted.ignore", "true").equals("true") && DeletedEntry.findByIdentifier(identifier) != null;
    }
}

