/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.platform;

import com.jbidwatcher.util.browser.BrowserLauncher;
import com.jbidwatcher.util.browser.WindowsBrowserLauncher;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class Browser
extends JConfig
implements MessageQueue.Listener {
    private static Browser sInstance;

    @Override
    public void messageAction(Object deQ) {
        String msg = (String)deQ;
        Browser.launchBrowser(msg);
    }

    public static String getBrowserCommand() {
        String osName = Browser.getOS();
        if (osName.equalsIgnoreCase("windows")) {
            return WindowsBrowserLauncher.getBrowser("http");
        }
        return "firefox";
    }

    public static boolean launchBrowser(String url) {
        boolean browserLaunched = false;
        String errorMessage = "";
        boolean forceOverride = JConfig.queryConfiguration("browser.override", "false").equals("true");
        if (Desktop.isDesktopSupported() && !forceOverride) {
            try {
                Desktop.getDesktop().browse(new URI(url));
                browserLaunched = true;
            }
            catch (URISyntaxException syntaxError) {
                errorMessage = ": " + syntaxError.getMessage();
            }
            catch (IOException launchFailed) {
                JConfig.log().logMessage("Failed to launch: " + launchFailed.getMessage());
            }
        }
        if (!browserLaunched && errorMessage.isEmpty()) {
            browserLaunched = Browser.oldBrowse(url);
        }
        if (!browserLaunched) {
            JConfig.log().logMessage("Could not browse to " + url + errorMessage);
        }
        return browserLaunched;
    }

    private static boolean oldBrowse(String url) {
        String osName = Browser.getOS();
        String launchCommand = JConfig.queryConfiguration("browser.launch." + osName);
        if (launchCommand == null && (launchCommand = JConfig.queryConfiguration("browser.launch")) == null) {
            launchCommand = "firefox";
        }
        try {
            BrowserLauncher.openURL(url, launchCommand, JConfig.queryConfiguration("browser.override", "false").equals("true"));
        }
        catch (IOException e) {
            JConfig.log().handleException("Launching browser", e);
            return true;
        }
        return false;
    }

    public static void start() {
        if (sInstance == null) {
            sInstance = new Browser();
            MQFactory.getConcrete("browse").registerListener(sInstance);
        }
    }
}

