/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.cyberfox.util.platform.Platform;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jbidwatcher.auction.server.AuctionServerManager;
import com.jbidwatcher.ui.JBidMenuBar;
import com.jbidwatcher.ui.JTabManager;
import com.jbidwatcher.ui.PopupMenuFactory;
import com.jbidwatcher.ui.config.JConfigTab;
import com.jbidwatcher.ui.util.ButtonMaker;
import com.jbidwatcher.ui.util.JPasteListener;
import com.jbidwatcher.ui.util.SearchField;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MQFactory;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

@Singleton
public class JBidToolBar {
    private static final int SELECT_BOX_SIZE = 20;
    private final AuctionServerManager serverManager;
    private final JPasteListener pasteListener;
    private final JTabManager tabManager;
    @Inject
    private PopupMenuFactory menuFactory;
    private JLabel mHeaderStatus;
    private JPanel mBidBarPanel;
    private JBidMenuBar mBidMenu;
    private JTextField mSelectBox;
    private Icon mCurrentStatus;
    private Icon mCurrentStatus16;
    private JButton mDonateButton;
    private String mTooltip = "";
    private String mExtra = "";

    private String getSource(String icon) {
        String iconSize = JConfig.queryConfiguration("ui.iconSize", "32");
        String toolbarSrc = "/icons/toolbar/" + iconSize + "/";
        return toolbarSrc + icon;
    }

    public JPanel buildHeaderBar(JFrame inFrame, JTabManager inAction) {
        this.establishMenu(inFrame, inAction);
        this.mBidBarPanel = new JPanel();
        this.mBidBarPanel.setLayout(new BoxLayout(this.mBidBarPanel, 0));
        if (!Platform.isMac()) {
            this.mBidBarPanel.setBorder(BorderFactory.createEtchedBorder());
        } else {
            this.mBidBarPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        }
        JToolBar bidBar = this.establishToolbar(inAction);
        this.mBidBarPanel.add(bidBar);
        this.mBidBarPanel.add(Box.createHorizontalGlue());
        this.mHeaderStatus = new JLabel("", 4);
        Dimension boxSize = new Dimension(250, 32);
        this.mHeaderStatus.setMinimumSize(boxSize);
        this.mHeaderStatus.setPreferredSize(boxSize);
        this.mHeaderStatus.setMaximumSize(boxSize);
        this.mHeaderStatus.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                MQFactory.getConcrete("Swing").enqueue("TOGGLE_SMALL");
            }
        });
        this.mBidBarPanel.add(this.mHeaderStatus);
        bidBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.mBidBarPanel.setVisible(JConfig.queryConfiguration("display.toolbar", "true").equals("true"));
        if (!this.mBidBarPanel.isVisible() && !Platform.isMac()) {
            if (this.mHeaderStatus != null) {
                this.setStatusIcon();
            }
            this.mBidMenu.add(this.mHeaderStatus);
        }
        return this.mBidBarPanel;
    }

    private JToolBar establishToolbar(JTabManager inAction) {
        JToolBar bidBar = new JToolBar();
        ButtonMaker.addbutton(bidBar, inAction, "Add", this.getSource("add_auction.png"), "Add auction");
        ButtonMaker.addbutton(bidBar, inAction, "Search", this.getSource("find.png"), "Auction Search Manager");
        bidBar.addSeparator();
        ButtonMaker.addbutton(bidBar, inAction, "Snipe", this.getSource("auction.png"), "Place snipe");
        ButtonMaker.addbutton(bidBar, inAction, "Information", this.getSource("information.png"), "Get information");
        ButtonMaker.addbutton(bidBar, inAction, "Delete", this.getSource("delete.png"), "Delete auction");
        bidBar.addSeparator();
        ButtonMaker.addbutton(bidBar, inAction, "UpdateAll", this.getSource("updateall.png"), "Update all auctions");
        ButtonMaker.addbutton(bidBar, inAction, "StopUpdating", this.getSource("stopupdating.png"), "Stop updating auctions");
        bidBar.addSeparator();
        ButtonMaker.addbutton(bidBar, inAction, "Configure", this.getSource("configuration.png"), "Configure");
        if (JConfig.debugging) {
            ButtonMaker.addbutton(bidBar, inAction, "View Log", this.getSource("log_view.png"), "View log");
        }
        ButtonMaker.addbutton(bidBar, inAction, "FAQ", this.getSource("help.png"), "Help");
        ButtonMaker.addbutton(bidBar, inAction, "About", this.getSource("about.png"), "About JBidwatcher");
        bidBar.addSeparator();
        ButtonMaker.addbutton(bidBar, inAction, "Forum", this.getSource("forum.png"), "JBidwatcher forums");
        if (JConfig.debugging) {
            ButtonMaker.addbutton(bidBar, inAction, "Report Bug", this.getSource("report_bug.png"), "Report bug");
        }
        ButtonMaker.addbutton(bidBar, inAction, "My JBidwatcher", this.getSource("home.png"), "My JBidwatcher");
        if (JConfig.queryConfiguration("donation.clicked", "false").equals("false")) {
            this.mDonateButton = ButtonMaker.addbutton(bidBar, inAction, "Donate", "/icons/toolbar/btn_donate_SM.gif", "Please donate if you feel JBidwatcher is useful and has helped you!");
        }
        if (JConfig.queryConfiguration("toolbar.floater", "false").equals("false")) {
            bidBar.setFloatable(false);
        }
        if (Platform.isMac()) {
            bidBar.putClientProperty("Quaqua.ToolBar.style", "title");
        }
        bidBar.setRollover(true);
        JComponent searchBox = this.establishSearchBox(inAction);
        bidBar.addSeparator();
        bidBar.add(searchBox);
        bidBar.addSeparator();
        bidBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        return bidBar;
    }

    private JComponent establishSearchBox(final JTabManager inAction) {
        DocumentListener selectListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent de) {
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
            }
        };
        this.mSelectBox.addMouseListener(this.pasteListener);
        JConfigTab.tweakTextField(this.mSelectBox, "Search and select items from the current table.", selectListener);
        ActionListener doSearch = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                inAction.selectBySearch(JBidToolBar.this.mSelectBox.getText());
            }
        };
        this.mSelectBox.addActionListener(doSearch);
        this.mSelectBox.putClientProperty("JTextField.variant", "search");
        JPanel compact = new JPanel();
        compact.setLayout(new BoxLayout(compact, 0));
        compact.setPreferredSize(new Dimension(100, 24));
        compact.add(this.mSelectBox);
        return compact;
    }

    private void establishMenu(JFrame inFrame, JTabManager inAction) {
        this.mBidMenu = JBidMenuBar.getInstance(this.menuFactory, this.tabManager.getTabs(), inAction, "JBidwatcher");
        JMenu menu = this.serverManager.addAuctionServerMenus().getMenu();
        JBidMenuBar menuCheck = JBidMenuBar.getInstance(this.menuFactory, this.tabManager.getTabs(), null);
        if (menuCheck != this.mBidMenu) {
            menuCheck.add(menu);
            menuCheck.add(Box.createHorizontalGlue());
        }
        this.mBidMenu.add(menu);
        this.mBidMenu.add(Box.createHorizontalGlue());
        inFrame.setJMenuBar(this.mBidMenu);
    }

    @Inject
    private JBidToolBar(AuctionServerManager serverManager, JTabManager tabManager, JPasteListener pasteListener) {
        this.tabManager = tabManager;
        this.serverManager = serverManager;
        this.pasteListener = pasteListener;
        this.mSelectBox = new SearchField("Select", 20);
        if (Platform.isMac()) {
            this.mSelectBox.putClientProperty("Quaqua.TextField.style", "search");
        }
    }

    public void setText(String msg) {
        if (this.mHeaderStatus != null) {
            this.mHeaderStatus.setText(msg);
        }
    }

    public void setTextIcon(Icon status, Icon status16) {
        this.mCurrentStatus = status;
        this.mCurrentStatus16 = status16;
        if (this.mHeaderStatus != null) {
            this.setStatusIcon();
        }
    }

    public void setStatusIcon() {
        if (this.mBidBarPanel.isVisible()) {
            this.mHeaderStatus.setIcon(this.mCurrentStatus);
        } else {
            this.mHeaderStatus.setIcon(this.mCurrentStatus16);
        }
    }

    public void setToolTipText(String tooltip) {
        this.mTooltip = tooltip;
        this.updateTooltip();
    }

    private void updateTooltip() {
        if (this.mHeaderStatus != null) {
            if (this.mExtra != null && this.mExtra.length() != 0) {
                this.mHeaderStatus.setToolTipText("<html><body>" + this.mTooltip + "<br>" + this.mExtra + "</body></html>");
            } else {
                this.mHeaderStatus.setToolTipText(this.mTooltip);
            }
        }
    }

    public void setToolTipExtra(String extra) {
        this.mExtra = extra;
        this.updateTooltip();
    }

    public void show(boolean visible) {
        if (this.mHeaderStatus != null) {
            this.mHeaderStatus.setVisible(visible);
        }
    }

    public void togglePanel() {
        this.mBidBarPanel.setVisible(!this.mBidBarPanel.isVisible());
        if (this.mHeaderStatus != null) {
            this.setStatusIcon();
        }
        JConfig.setConfiguration("display.toolbar", this.mBidBarPanel.isVisible() ? "true" : "false");
        if (this.mBidBarPanel.isVisible()) {
            this.show(false);
            if (!Platform.isMac()) {
                this.mBidBarPanel.add(this.mHeaderStatus, "East", 0);
            }
            this.show(true);
        } else if (!Platform.isMac()) {
            this.mBidMenu.add(this.mHeaderStatus);
        }
    }

    public void hideDonation() {
        if (this.mDonateButton != null) {
            this.mDonateButton.setVisible(false);
        }
    }
}

