/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util.queue;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Heap {
    protected Object[] mNodes;
    protected int mCount = 0;
    protected final Comparator mCmp;

    public Heap(int capacity, Comparator cmp) throws IllegalArgumentException {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.mNodes = new Object[capacity];
        this.mCmp = cmp;
    }

    public Heap(int capacity) {
        this(capacity, null);
    }

    protected int compare(Object a, Object b) {
        if (this.mCmp == null) {
            return ((Comparable)a).compareTo(b);
        }
        return this.mCmp.compare(a, b);
    }

    protected final int parent(int k) {
        return (k - 1) / 2;
    }

    protected final int left(int k) {
        return 2 * k + 1;
    }

    protected final int right(int k) {
        return 2 * (k + 1);
    }

    public synchronized void insert(Object x) {
        int par;
        if (this.mCount >= this.mNodes.length) {
            int newcap = 3 * this.mNodes.length / 2 + 1;
            Object[] newnodes = new Object[newcap];
            System.arraycopy(this.mNodes, 0, newnodes, 0, this.mNodes.length);
            this.mNodes = newnodes;
        }
        int k = this.mCount++;
        while (k > 0 && this.compare(x, this.mNodes[par = this.parent(k)]) < 0) {
            this.mNodes[k] = this.mNodes[par];
            k = par;
        }
        this.mNodes[k] = x;
    }

    public synchronized Object extract() {
        if (this.mCount < 1) {
            return null;
        }
        int k = 0;
        return this.extractElementAt(k);
    }

    private Object extractElementAt(int k) {
        int l;
        Object least = this.mNodes[k];
        --this.mCount;
        Object x = this.mNodes[this.mCount];
        while ((l = this.left(k)) < this.mCount) {
            int child;
            int r = this.right(k);
            int n = child = r >= this.mCount || this.compare(this.mNodes[l], this.mNodes[r]) < 0 ? l : r;
            if (this.compare(x, this.mNodes[child]) <= 0) break;
            this.mNodes[k] = this.mNodes[child];
            k = child;
        }
        this.mNodes[k] = x;
        this.mNodes[this.mCount] = null;
        return least;
    }

    public synchronized Object peek() {
        if (this.mCount > 0) {
            return this.mNodes[0];
        }
        return null;
    }

    public synchronized int size() {
        return this.mCount;
    }

    public synchronized void clear() {
        for (int i = 0; i < this.mCount; ++i) {
            this.mNodes[i] = null;
        }
        this.mCount = 0;
    }

    public List getUnsorted() {
        List<Object> rval = Arrays.asList(this.mNodes);
        return rval.subList(0, this.mCount);
    }

    public List getSorted() {
        List base = this.getUnsorted();
        Collections.sort(base);
        return base;
    }

    public boolean erase(Object o) {
        for (int i = 0; i < this.mNodes.length; ++i) {
            if (this.mNodes[i] != o) continue;
            this.extractElementAt(i);
            return true;
        }
        return false;
    }
}

