/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.sql.DatabaseMetaData;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.util.CaseInsensitiveMap;
import net.sourceforge.schemaspy.util.HtmlEncoder;
import net.sourceforge.schemaspy.view.SqlFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSqlFormatter
implements SqlFormatter {
    private Set<String> keywords;
    private Map<String, Table> tablesByPossibleNames;
    private static String TOKENS = " \t\n\r\f()<>|,";

    @Override
    public String format(String string, Database database, Set<Table> set) {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        boolean bl2 = bl = string.contains("\n") || string.contains("\r");
        if (bl) {
            stringBuilder.append("<div class='viewDefinition preFormatted'>");
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (Character.isWhitespace(c)) {
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append(HtmlEncoder.encodeToken(c));
            }
        } else {
            stringBuilder.append("  <div class='viewDefinition'>");
            Set<String> set2 = this.getKeywords(database.getMetaData());
            StringTokenizer stringTokenizer = new StringTokenizer(string, TOKENS, true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (set2.contains(string2.toUpperCase())) {
                    stringBuilder.append("<b>");
                    stringBuilder.append(string2);
                    stringBuilder.append("</b>");
                    continue;
                }
                stringBuilder.append(HtmlEncoder.encodeToken(string2));
            }
        }
        stringBuilder.append("</div>");
        set.addAll(this.getReferencedTables(string, database));
        return stringBuilder.toString();
    }

    protected Set<Table> getReferencedTables(String string, Database database) {
        HashSet<Table> hashSet = new HashSet<Table>();
        Map<String, Table> map = this.getTableMap(database);
        Set<String> set = this.getKeywords(database.getMetaData());
        StringTokenizer stringTokenizer = new StringTokenizer(string, TOKENS, true);
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string2 = stringTokenizer.nextToken();
            if (set.contains(string2.toUpperCase())) continue;
            Table table = map.get(string2);
            if (table == null && (n = string2.lastIndexOf(46)) != -1) {
                table = map.get(string2.substring(0, n));
            }
            if (table == null) continue;
            hashSet.add(table);
        }
        return hashSet;
    }

    protected Map<String, Table> getTableMap(Database database) {
        if (this.tablesByPossibleNames == null) {
            this.tablesByPossibleNames = new CaseInsensitiveMap<Table>();
            this.tablesByPossibleNames.putAll(this.getTableMap(database.getTables(), database.getName()));
            this.tablesByPossibleNames.putAll(this.getTableMap(database.getViews(), database.getName()));
        }
        return this.tablesByPossibleNames;
    }

    protected Map<String, Table> getTableMap(Collection<? extends Table> collection, String string) {
        CaseInsensitiveMap<Table> caseInsensitiveMap = new CaseInsensitiveMap<Table>();
        for (Table table : collection) {
            String string2 = table.getName();
            String string3 = table.getSchema();
            if (string3 == null) {
                string3 = string;
            }
            caseInsensitiveMap.put(string2, table);
            caseInsensitiveMap.put("`" + string2 + "`", table);
            caseInsensitiveMap.put("'" + string2 + "'", table);
            caseInsensitiveMap.put("\"" + string2 + "\"", table);
            caseInsensitiveMap.put(string3 + "." + string2, table);
            caseInsensitiveMap.put("`" + string3 + "`.`" + string2 + "`", table);
            caseInsensitiveMap.put("'" + string3 + "'.'" + string2 + "'", table);
            caseInsensitiveMap.put("\"" + string3 + "\".\"" + string2 + "\"", table);
            caseInsensitiveMap.put("`" + string3 + '.' + string2 + "`", table);
            caseInsensitiveMap.put("'" + string3 + '.' + string2 + "'", table);
            caseInsensitiveMap.put("\"" + string3 + '.' + string2 + "\"", table);
        }
        return caseInsensitiveMap;
    }

    public Set<String> getKeywords(DatabaseMetaData databaseMetaData) {
        if (this.keywords == null) {
            this.keywords = new HashSet<String>(Arrays.asList("ABSOLUTE", "ACTION", "ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIT", "BIT_LENGTH", "BOTH", "BY", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHARACTER", "CHAR_LENGTH", "CHARACTER_LENGTH", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DESCRIPTOR", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOMAIN", "DOUBLE", "DROP", "ELSE", "END", "END - EXEC", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LANGUAGE", "LAST", "LEADING", "LEFT", "LEVEL", "LIKE", "LOCAL", "LOWER", "MATCH", "MAX", "MIN", "MINUTE", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NOT", "NULL", "NULLIF", "NUMERIC", "OCTET_LENGTH", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUTER", "OUTPUT", "OVERLAPS", "PAD", "PARTIAL", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWS", "SCHEMA", "SCROLL", "SECOND", "SECTION", "SELECT", "SESSION", "SESSION_USER", "SET", "SIZE", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCODE", "SQLERROR", "SQLSTATE", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "YEAR", "ZONE"));
            try {
                String[] stringArray = new String[]{databaseMetaData.getSQLKeywords(), databaseMetaData.getSystemFunctions(), databaseMetaData.getNumericFunctions(), databaseMetaData.getStringFunctions(), databaseMetaData.getTimeDateFunctions()};
                for (int i = 0; i < stringArray.length; ++i) {
                    StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i].toUpperCase(), ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        this.keywords.add(stringTokenizer.nextToken().trim());
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        return this.keywords;
    }
}

