/*
 * Decompiled with CFR 0.152.
 */
package com.cyberfox.util.config;

import com.cyberfox.util.config.ErrorHandler;
import com.cyberfox.util.config.JConfig;
import com.cyberfox.util.config.LoggerInterface;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ErrorManagement
implements LoggerInterface {
    private static PrintWriter mLogWriter = null;
    private List<ErrorHandler> sHandlers = new ArrayList<ErrorHandler>();
    private File mFP;
    private int fileNumber = 1;
    private boolean mPaused = false;
    private static LoggerWriter sWriter = new LoggerWriter();

    @Override
    public void addHandler(ErrorHandler eh) {
        this.sHandlers.add(eh);
    }

    @Override
    public void dumpFile(StringBuffer loadedPage) {
        if (loadedPage == null) {
            return;
        }
        this.dump2File("page" + this.fileNumber++ + ".html", loadedPage);
    }

    private void initLog() {
        if (this.mPaused) {
            return;
        }
        if (mLogWriter != null) {
            return;
        }
        String sep = System.getProperty("file.separator");
        String home = JConfig.getHomeDirectory();
        String doLogging = JConfig.queryConfiguration("logging", "true");
        if (doLogging.equals("true") && mLogWriter == null) {
            try {
                File fp;
                String increment = "";
                int stepper = 1;
                do {
                    fp = new File(home + sep + "errors" + increment + ".log");
                    increment = "." + stepper++;
                } while (fp.exists());
                this.mFP = fp;
                mLogWriter = new PrintWriter(new FileOutputStream(fp));
            }
            catch (IOException ioe) {
                System.err.println("FAILED TO OPEN AN ERROR LOG.");
                ioe.printStackTrace();
            }
        }
    }

    @Override
    public void pause() {
        this.mPaused = true;
    }

    @Override
    public void resume() {
        this.mPaused = false;
    }

    @Override
    public boolean openLog(File fp) {
        try {
            this.mFP = fp;
            mLogWriter = new PrintWriter(new FileOutputStream(fp));
            return true;
        }
        catch (IOException ioe) {
            System.err.println("FAILED TO OPEN AN ERROR LOG.");
            ioe.printStackTrace();
            return false;
        }
    }

    @Override
    public String getLog() {
        if (this.mFP == null) {
            return null;
        }
        return this.mFP.getAbsolutePath();
    }

    @Override
    public File closeLog() {
        for (ErrorHandler handler : this.sHandlers) {
            handler.close();
        }
        if (mLogWriter != null) {
            mLogWriter.close();
            mLogWriter = null;
            File oldFP = this.mFP;
            this.mFP = null;
            return oldFP;
        }
        return null;
    }

    @Override
    public void logMessage(String msg) {
        this.initLog();
        Date log_time = new Date();
        System.err.println(log_time + ": " + msg);
        String logMsg = log_time + ": ";
        logMsg = msg.startsWith(logMsg) ? msg : logMsg + msg;
        for (ErrorHandler handler : this.sHandlers) {
            handler.addLog(logMsg);
        }
        String doLogging = JConfig.queryConfiguration("logging", "true");
        if (doLogging.equals("true") && mLogWriter != null) {
            mLogWriter.println(logMsg);
            mLogWriter.flush();
        }
    }

    @Override
    public void logDebug(String msg) {
        if (JConfig.debugging && msg != null) {
            this.logMessage(msg);
        }
    }

    @Override
    public void logVerboseDebug(String msg) {
        if (JConfig.queryConfiguration("debug.uber", "false").equals("true")) {
            this.logMessage(msg);
        }
    }

    @Override
    public void handleDebugException(String sError, Throwable e) {
        if (JConfig.debugging) {
            this.handleException(sError, e);
        }
    }

    public static String getStackTrace(Throwable e) {
        StringBuffer sb = new StringBuffer();
        sWriter.setSnapshot(sb);
        e.printStackTrace(sWriter);
        sWriter.setSnapshot(null);
        return sb.toString();
    }

    @Override
    public void handleException(String sError, Throwable e) {
        this.initLog();
        Date log_time = new Date();
        if (sError == null || sError.length() == 0) {
            System.err.println("[" + log_time + "]");
        } else {
            System.err.println(log_time + ": " + sError);
        }
        e.printStackTrace();
        String doLogging = JConfig.queryConfiguration("logging", "true");
        String logMsg = sError == null || sError.length() == 0 ? "[" + log_time + "]" : log_time + ": " + sError;
        String trace = ErrorManagement.getStackTrace(e);
        for (ErrorHandler handler : this.sHandlers) {
            handler.exception(logMsg, e.getMessage(), trace);
        }
        if (doLogging.equals("true") && mLogWriter != null) {
            mLogWriter.println(logMsg);
            if (e.getMessage() != null) {
                mLogWriter.println(e.getMessage());
            }
            e.printStackTrace(mLogWriter);
            mLogWriter.flush();
        }
    }

    @Override
    public void logFile(String msgtop, StringBuffer dumpsb) {
        this.initLog();
        String doLogging = JConfig.queryConfiguration("logging", "true");
        if (doLogging.equals("true") && JConfig.debugging) {
            if (mLogWriter != null) {
                mLogWriter.println("+------------------------------");
                mLogWriter.println("| " + msgtop);
                mLogWriter.println("+------------------------------");
                if (dumpsb != null) {
                    mLogWriter.println(dumpsb);
                } else {
                    mLogWriter.println("(null)");
                }
                mLogWriter.println("+------------end---------------");
                mLogWriter.flush();
            }
            for (ErrorHandler handler : this.sHandlers) {
                handler.addLog("...");
            }
            this.logMessage("File contents logged with message: " + msgtop);
            for (ErrorHandler handler : this.sHandlers) {
                handler.addLog("...");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump2File(String fname, StringBuffer sb) {
        if (JConfig.queryConfiguration("debug.filedump", "false").equals("false")) {
            return;
        }
        FileWriter fw = null;
        try {
            fw = new FileWriter(fname);
            fw.write(sb.toString());
        }
        catch (IOException ioe) {
            this.handleException("Threw exception in dump2File!", ioe);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static class LoggerWriter
    extends PrintWriter {
        private StringBuffer mSnapshot = null;

        public LoggerWriter() {
            super(System.out);
        }

        @Override
        public void println(String x) {
            if (this.mSnapshot != null) {
                this.mSnapshot.append(x);
                this.mSnapshot.append('\n');
            }
        }

        public void setSnapshot(StringBuffer sb) {
            this.mSnapshot = sb;
        }
    }
}

