/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.ui.AuctionListHolder;
import com.jbidwatcher.util.Task;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MQFactory;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

@Singleton
public class ListManager {
    private final Map<String, AuctionListHolder> mCategoryMap = Collections.synchronizedMap(new LinkedHashMap(3));

    @Inject
    private ListManager() {
    }

    public boolean toggleField(String tabName, String field) {
        boolean visible = false;
        AuctionListHolder result = this.mCategoryMap.get(tabName);
        if (result != null && !(visible = result.getUI().toggleField(field))) {
            JConfig.killDisplay(tabName + '.' + field);
        }
        return visible;
    }

    public List<String> getColumns(String tabName) {
        AuctionListHolder result = this.mCategoryMap.get(tabName);
        return result == null ? null : result.getUI().getColumns();
    }

    public boolean exportTab(String tabName, String fname) {
        AuctionListHolder result = this.mCategoryMap.get(tabName);
        return result != null && result.getUI().export(fname);
    }

    AuctionListHolder findCategory(String categoryName) {
        return this.mCategoryMap.get(categoryName);
    }

    public List<String> allCategories() {
        return new ArrayList<String>(this.mCategoryMap.keySet());
    }

    public boolean printTab(String tabName) {
        AuctionListHolder result = this.mCategoryMap.get(tabName);
        if (result != null) {
            result.getUI().print();
        }
        return result != null;
    }

    public Component deleteTab(String tabName, boolean deleteFirst) {
        AuctionListHolder result = this.mCategoryMap.get(tabName);
        if (result != null && result.isDeletable()) {
            this.mCategoryMap.remove(tabName);
            this.removeAuctionsFromTab(deleteFirst, result);
            return result.getUI().getPanel();
        }
        return null;
    }

    private void removeAuctionsFromTab(final boolean deleteFirst, final AuctionListHolder holder) {
        holder.getList().each(new Task(){

            @Override
            public void execute(Object o) {
                AuctionEntry ae = (AuctionEntry)o;
                if (deleteFirst) {
                    holder.getUI().delEntry(ae);
                } else {
                    ae.setCategory(null);
                    MQFactory.getConcrete("redraw").enqueue(ae.getIdentifier());
                }
            }
        });
    }

    public Properties extractProperties(Properties outProps) {
        int i = 0;
        ArrayList<AuctionListHolder> categories = new ArrayList<AuctionListHolder>(this.mCategoryMap.values());
        for (AuctionListHolder step : categories) {
            JTable table = step.getUI().getTable();
            TableRowSorter<TableModel> sorter = step.getUI().getTableSorter();
            TableModel model = (TableModel)sorter.getModel();
            for (int j = 0; j < model.getColumnCount(); ++j) {
                int n = table.convertColumnIndexToView(j);
            }
            step.getUI().getColumnWidthsToProperties(outProps);
            String tab = step.getList().getName();
            outProps.setProperty("tabs.name." + i, tab);
            String KEEP_ENDED = tab + ".end.keep";
            String DELETE_NOT_MY_BID = tab + ".end.delete.notmybid";
            String DELETE_NO_BIDS = tab + ".end.delete.nobids";
            String ARCHIVE = tab + ".archive";
            outProps.setProperty(KEEP_ENDED, JConfig.queryDisplayProperty(KEEP_ENDED, "unset"));
            outProps.setProperty(DELETE_NOT_MY_BID, JConfig.queryDisplayProperty(DELETE_NOT_MY_BID, "unset"));
            outProps.setProperty(DELETE_NO_BIDS, JConfig.queryDisplayProperty(DELETE_NO_BIDS, "unset"));
            outProps.setProperty(ARCHIVE, JConfig.queryDisplayProperty(ARCHIVE, "unset"));
            ++i;
        }
        return outProps;
    }

    AuctionListHolder add(AuctionListHolder newList) {
        this.mCategoryMap.put(newList.getList().getName(), newList);
        return newList;
    }

    public void setBackground(Color bgColor) {
        ArrayList<AuctionListHolder> categories = new ArrayList<AuctionListHolder>(this.mCategoryMap.values());
        for (AuctionListHolder step : categories) {
            step.getUI().setBackground(bgColor);
        }
    }

    public void adjustHeights() {
        ArrayList<AuctionListHolder> categories = new ArrayList<AuctionListHolder>(this.mCategoryMap.values());
        for (AuctionListHolder step : categories) {
            step.getUI().adjustRowHeight();
        }
    }
}

