/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.jbidwatcher.search.SearchManager;
import com.jbidwatcher.search.Searcher;
import com.jbidwatcher.ui.ListManager;
import com.jbidwatcher.ui.util.BasicDialog;
import com.jbidwatcher.ui.util.JPasteListener;
import com.jbidwatcher.ui.util.SpringUtilities;
import com.jbidwatcher.util.config.JConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class SearchInfoDialog
extends BasicDialog {
    private final SearchManager searchManager;
    private final ListManager listManager;
    private JComboBox searchTypeBox;
    private JTextField searchNameField;
    private JComboBox periodList;
    private JComboBox currencyBox = null;
    private JCheckBox periodEnabled;
    private JComboBox tabList;
    private JTextField searchField;
    private Searcher curSearch;
    private Map<String, String> curToId = null;
    private static final String[] _periods = new String[]{"Every hour", "Every 6 hours", "Every 12 hours", "Once a day", "Every other day", "Once a week", "Only on command"};
    private static final String[] _search_types = new String[]{"Text Search", "Title Only", "Seller Search", "URL Load", "My Items"};
    private static final int[] _hours = new int[]{1, 6, 12, 24, 48, 168, -1};

    public String getSearchType() {
        return (String)this.searchTypeBox.getSelectedItem();
    }

    @Override
    public String getName() {
        return this.searchNameField.getText();
    }

    public String getSearch() {
        return this.searchField.getText();
    }

    public String getPeriod() {
        return (String)this.periodList.getSelectedItem();
    }

    public String getTab() {
        return (String)this.tabList.getSelectedItem();
    }

    public boolean doPeriodic() {
        return this.periodEnabled.isSelected();
    }

    public String getCurrency() {
        if (this.curToId == null) {
            return null;
        }
        return this.curToId.get(this.currencyBox.getSelectedItem().toString());
    }

    public SearchInfoDialog(SearchManager searchManager, ListManager listManager, JPasteListener pasteListener) {
        this.searchManager = searchManager;
        this.listManager = listManager;
        JConfig.setConfiguration("ebay.currencySearch.0", "All");
        JConfig.setConfiguration("ebay.currencySearch.1", "U.S. dollar");
        JConfig.setConfiguration("ebay.currencySearch.2", "Canadian dollar");
        JConfig.setConfiguration("ebay.currencySearch.3", "Pound Sterling");
        JConfig.setConfiguration("ebay.currencySearch.5", "Australian dollar");
        JConfig.setConfiguration("ebay.currencySearch.7", "Euro");
        JConfig.setConfiguration("ebay.currencySearch.44", "Indian Rupee");
        JConfig.setConfiguration("ebay.currencySearch.41", "New Taiwan dollar");
        JConfig.setConfiguration("ebay.currencySearch.13", "Swiss franc");
        this.addBehavior();
        this.setupUI(pasteListener);
        this.setModal(true);
    }

    @Override
    protected void onOK() {
        if (this.curSearch == null) {
            this.curSearch = this.searchManager.buildSearch(System.currentTimeMillis(), this.getSearchType(), this.getName(), this.getSearch(), "ebay", this.getCurrency(), -1);
            this.searchManager.addSearch(this.curSearch);
        } else {
            this.curSearch.setName(this.getName());
            this.curSearch.setSearch(this.getSearch());
            this.curSearch.setCurrency(this.getCurrency());
        }
        this.curSearch.setPeriod(_hours[this.periodList.getSelectedIndex()]);
        this.curSearch.setCategory(this.getTab());
        if (this.doPeriodic()) {
            this.curSearch.enable();
        } else {
            this.curSearch.disable();
        }
        this.dispose();
    }

    @Override
    protected void onCancel() {
        this.dispose();
    }

    public void prepare(Searcher s) {
        this.buildTabList();
        if (s == null) {
            this.tabList.setSelectedItem("current");
            this.searchField.setText("");
            this.searchNameField.setText("");
            this.periodList.setSelectedItem("Only on command");
            this.periodEnabled.setSelected(false);
            this.searchTypeBox.setEnabled(true);
            this.searchTypeBox.setSelectedIndex(0);
            this.currencyBox.setEnabled(true);
            this.currencyBox.setSelectedIndex(0);
        } else {
            this.tabList.setSelectedItem(s.getCategory());
            this.searchField.setText(s.getSearch());
            this.searchNameField.setText(s.getName());
            this.searchTypeBox.setSelectedItem(s.getTypeName());
            this.searchTypeBox.setEnabled(false);
            String oldCur = s.getCurrency();
            if (oldCur == null) {
                oldCur = "0";
            }
            this.currencyBox.setSelectedItem(JConfig.queryConfiguration("ebay.currencySearch." + oldCur, "All"));
            if (s.getTypeName().equals("Text") || s.getTypeName().equals("Title")) {
                this.currencyBox.setEnabled(true);
            } else {
                this.currencyBox.setEnabled(false);
            }
            this.periodEnabled.setSelected(s.isEnabled());
            this.periodList.setSelectedIndex(0);
            for (int index = 0; index < _hours.length; ++index) {
                if (s.getPeriod() != _hours[index]) continue;
                this.periodList.setSelectedIndex(index);
                break;
            }
        }
        this.curSearch = s;
    }

    private JPanel boxUp(Component a, Component b) {
        JPanel newBox = new JPanel();
        newBox.setLayout(new BoxLayout(newBox, 0));
        newBox.add(a);
        newBox.add(b);
        return newBox;
    }

    private void setupUI(JPasteListener pasteListener) {
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BorderLayout());
        panel3.add((Component)this.boxUp(this.getButtonOK(), this.getButtonCancel()), "East");
        this.getBasicContentPane().add((Component)panel3, "South");
        JLabel label1 = new JLabel("Search Name: ");
        this.searchNameField = new JTextField(12);
        this.searchNameField.addMouseListener(pasteListener);
        JLabel label2 = new JLabel(" Search Type: ");
        this.searchTypeBox = new JComboBox<String>(_search_types);
        this.periodList = new JComboBox<String>(_periods);
        this.periodEnabled = new JCheckBox("Enable Repeated Search");
        this.tabList = new JComboBox();
        this.buildTabList();
        this.currencyBox = new JComboBox();
        this.buildCurrencyList(this.currencyBox);
        JLabel searchLabel = new JLabel("Search: ");
        this.searchField = new JTextField(40);
        this.searchField.addMouseListener(pasteListener);
        JLabel tabLabel = new JLabel("Destination Tab: ");
        JLabel curLabel = new JLabel("Currency: ");
        JPanel form = new JPanel();
        form.setLayout(new SpringLayout());
        form.add(label1);
        form.add(this.boxUp(this.boxUp(this.searchNameField, label2), this.searchTypeBox));
        form.add(searchLabel);
        form.add(this.searchField);
        form.add(tabLabel);
        form.add(this.tabList);
        form.add(curLabel);
        form.add(this.currencyBox);
        form.add(new JLabel("Repeat every: "));
        form.add(this.boxUp(this.periodList, this.periodEnabled));
        SpringUtilities.makeCompactGrid(form, 5, 2, 6, 6, 6, 3);
        this.getBasicContentPane().add((Component)form, "Center");
    }

    private void buildCurrencyList(JComboBox cBox) {
        cBox.removeAllItems();
        cBox.setEditable(false);
        List<String> tmpList = JConfig.getMatching("ebay.currencySearch.");
        Collections.sort(tmpList);
        for (String o : tmpList) {
            String s;
            if (o == null || (s = JConfig.queryConfiguration("ebay.currencySearch." + o)) == null) continue;
            cBox.addItem(s);
            if (this.curToId == null) {
                this.curToId = new TreeMap<String, String>();
            }
            this.curToId.put(s, o);
        }
    }

    private void buildTabList() {
        this.tabList.removeAllItems();
        this.tabList.setEditable(true);
        List<String> tabs = this.listManager.allCategories();
        if (tabs != null) {
            tabs.remove("complete");
            tabs.remove("selling");
            for (String tabName : tabs) {
                this.tabList.addItem(tabName);
            }
        }
    }
}

