/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util;

import com.jbidwatcher.util.Externalized;
import com.jbidwatcher.util.config.JConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class TT {
    private static ClassLoader urlCL = TT.class.getClassLoader();
    private ResourceBundle sResource = ResourceBundle.getBundle("ebay_com");
    private Properties countryProperties = null;
    private String mBundle;
    private String mCountrySiteName = null;

    public int hashCode() {
        return this.mBundle.hashCode();
    }

    public TT(String countrySite) {
        this.setCountrySite(countrySite);
    }

    public boolean setBundle(String bundleName) {
        this.mBundle = bundleName;
        boolean successful = false;
        try {
            this.sResource = ResourceBundle.getBundle(bundleName);
            successful = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        InputStream is = JConfig.bestSource(urlCL, bundleName + ".properties");
        if (is != null) {
            this.countryProperties = new Properties();
            try {
                this.countryProperties.load(is);
                successful = true;
            }
            catch (IOException e) {
                JConfig.log().logDebug("Failed to load country property file for " + bundleName + ".");
            }
        }
        return successful;
    }

    public String s(String key) {
        String override = null;
        if (this.countryProperties != null) {
            override = this.countryProperties.getProperty(key);
        }
        if (override != null) {
            return override;
        }
        try {
            return this.sResource.getString(key);
        }
        catch (MissingResourceException e) {
            return Externalized.getString(key);
        }
    }

    public boolean setCountrySite(String country) {
        this.mCountrySiteName = country;
        String bundle = country.replace('.', '_');
        return this.setBundle(bundle);
    }

    public String getCountrySiteName() {
        return this.mCountrySiteName;
    }

    public String getBundle() {
        return this.mBundle;
    }
}

