/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util.config;

import com.DeskMetrics.DeskMetrics;
import java.io.File;

public class JConfig
extends com.cyberfox.util.config.JConfig {
    private static DeskMetrics metrics;

    public static boolean sendMetricsAllowed(String version) {
        return JConfig.queryConfiguration("metrics.optin", "false").equals("true") || JConfig.queryConfiguration("metrics.optin", "false").equals("pre") && JConfig.isPrerelease(version);
    }

    public static boolean isPrerelease(String version) {
        return version.matches(".*(pre|alpha|beta).*");
    }

    public static void stopMetrics(String version) {
        try {
            if (metrics != null && JConfig.sendMetricsAllowed(version)) {
                metrics.stop();
            }
        }
        catch (Exception e) {
            JConfig.log().handleDebugException("Failed to send metrics to the server", e);
        }
    }

    public static DeskMetrics getMetrics() {
        return metrics;
    }

    public static void fixupPaths(String homeDirectory) {
        String[][] s = new String[][]{{"auctions.savepath", "auctionsave"}, {"platform.path", "platform"}, {"savefile", "auctions.xml"}, {"search.savefile", "searches.xml"}};
        String sep = System.getProperty("file.separator");
        for (String[] pair : s) {
            JConfig.setConfiguration(pair[0], homeDirectory + sep + pair[1]);
        }
    }

    public static File getContentFile(String identifier) {
        File fp = null;
        String outPath = JConfig.queryConfiguration("auctions.savepath");
        if (outPath != null && outPath.length() != 0) {
            String filePath = outPath + System.getProperty("file.separator") + identifier + ".html.gz";
            fp = new File(filePath);
        }
        return fp;
    }

    static {
        JConfig.setBaseName("JBidWatch.cfg");
        metrics = DeskMetrics.getInstance();
        metrics.setEndpoint("https://my.jbidwatcher.com/report/usage");
        String version = null;
        Package pack = JConfig.class.getPackage();
        if (pack != null) {
            version = pack.getImplementationVersion();
        }
        if (version == null) {
            version = "debug";
        }
        metrics.start("4f4a195ca14ad72a1d000000", version);
    }
}

