/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util.db;

import com.jbidwatcher.util.HashBacked;
import com.jbidwatcher.util.Record;
import com.jbidwatcher.util.db.Database;
import com.jbidwatcher.util.db.Table;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public abstract class ActiveRecord
extends HashBacked {
    private static boolean sDBDisabled = false;
    private static ArrayList<Table> sTables = new ArrayList();

    public static void disableDatabase() {
        sDBDisabled = true;
    }

    public static Table openDB(String tableName) {
        Table db;
        if (sDBDisabled || tableName == null) {
            return null;
        }
        try {
            db = new Table(tableName);
            sTables.add(db);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't access the " + tableName + " database table", e);
        }
        return db;
    }

    public static void shutdown() {
        HashSet<Database> s = new HashSet<Database>();
        for (Table t : sTables) {
            s.add(t.shutdown());
        }
        for (Database db : s) {
            db.shutdown();
        }
    }

    protected static Table getTable(Object o) {
        ActiveRecord record = (ActiveRecord)o;
        return record.getDatabase();
    }

    protected abstract Table getDatabase();

    public static int count(Class klass) {
        if (sDBDisabled) {
            return 0;
        }
        return ActiveRecord.getExemplar(klass).getDatabase().count();
    }

    public void commit() {
        if (!sDBDisabled) {
            this.getDatabase().commit();
        }
    }

    private String classify(String className) {
        return String.valueOf(className.charAt(0)).toUpperCase() + className.substring(1);
    }

    public String saveDB() {
        if (sDBDisabled) {
            return "0";
        }
        Table db = this.getDatabase();
        if (db.hasColumn("currency")) {
            this.setString("currency", this.getDefaultCurrency().fullCurrencyName());
        }
        if (!this.isDirty() && this.get("id") != null && this.get("id").length() != 0) {
            return this.get("id");
        }
        String id = this.getDatabase().insertOrUpdate(this.getBacking());
        this.commit();
        if (id != null && id.length() != 0) {
            this.set("id", id);
        } else {
            id = this.get("id");
        }
        this.clearDirty();
        return id;
    }

    public static List<? extends ActiveRecord> findAllBy(Class klass, String key, String value) {
        return ActiveRecord.findAllBy(klass, key, value, null);
    }

    protected static List<? extends ActiveRecord> findAllMulti(Class klass, String[] keys, String[] values, String order) {
        if (sDBDisabled) {
            return new LinkedList();
        }
        ActiveRecord found = ActiveRecord.getExemplar(klass);
        List<Record> results = ActiveRecord.getTable(found).findAllMulti(keys, values, order);
        return ActiveRecord.convertResultsToList(klass, results);
    }

    protected static List<? extends ActiveRecord> findAllComparator(Class klass, String key, String comparator, String value, String order) {
        if (sDBDisabled) {
            return new LinkedList();
        }
        ActiveRecord found = ActiveRecord.getExemplar(klass);
        List<Record> results = ActiveRecord.getTable(found).findAllComparator(key, comparator, value, order);
        return ActiveRecord.convertResultsToList(klass, results);
    }

    protected static List<? extends ActiveRecord> findAllBy(Class klass, String key, String value, String order) {
        if (sDBDisabled) {
            return new LinkedList();
        }
        ActiveRecord found = ActiveRecord.getExemplar(klass);
        List<Record> results = ActiveRecord.getTable(found).findAll(key, value, order);
        return ActiveRecord.convertResultsToList(klass, results);
    }

    public static List<? extends ActiveRecord> findAllByPrepared(Class klass, String query, String ... parameters) {
        if (sDBDisabled) {
            return new LinkedList();
        }
        ActiveRecord found = ActiveRecord.getExemplar(klass);
        List<Record> results = ActiveRecord.getTable(found).findAllPrepared(query, 0, parameters);
        return ActiveRecord.convertResultsToList(klass, results);
    }

    public static List<? extends ActiveRecord> findAllBySQL(Class klass, String query) {
        return ActiveRecord.findAllBySQL(klass, query, 0);
    }

    public static List<? extends ActiveRecord> findAllBySQL(Class klass, String query, int count) {
        if (sDBDisabled) {
            return new LinkedList();
        }
        ActiveRecord found = ActiveRecord.getExemplar(klass);
        List<Record> results = ActiveRecord.getTable(found).findAll(query, count);
        return ActiveRecord.convertResultsToList(klass, results);
    }

    private static List<ActiveRecord> convertResultsToList(Class klass, List<Record> results) {
        ArrayList<ActiveRecord> rval = new ArrayList<ActiveRecord>();
        try {
            for (Record record : results) {
                ActiveRecord row = (ActiveRecord)klass.newInstance();
                row.setBacking(record);
                rval.add(row);
            }
            return rval;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected static ActiveRecord getExemplar(Class klass) {
        ActiveRecord found;
        try {
            found = (ActiveRecord)klass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't instantiate " + klass.getName(), e);
        }
        return found;
    }

    public Integer getId() {
        return this.getInteger("id");
    }

    public static String makeCommaList(List<? extends ActiveRecord> records) {
        StringBuffer ids = new StringBuffer("");
        boolean first = true;
        for (ActiveRecord activeRecord : records) {
            if (!first) {
                ids.append(", ");
            }
            ids.append(activeRecord.getId());
            first = false;
        }
        return ids.toString();
    }

    public boolean delete() {
        if (sDBDisabled) {
            return false;
        }
        String id = this.get("id");
        return id != null && this.getDatabase().delete(Integer.parseInt(id));
    }

    public static ActiveRecord findFirstBySQL(Class klass, String query) {
        if (sDBDisabled) {
            return null;
        }
        ActiveRecord found = ActiveRecord.getExemplar(klass);
        Table t = ActiveRecord.getTable(found);
        Record result = t.findFirstBy(query);
        if (result != null && !result.isEmpty()) {
            found.setBacking(result);
        } else {
            found = null;
        }
        return found;
    }

    protected static ActiveRecord findFirstByUncached(Class klass, String key, String value) {
        if (sDBDisabled) {
            return null;
        }
        ActiveRecord found = ActiveRecord.getExemplar(klass);
        Table t = ActiveRecord.getTable(found);
        Record result = t.findFirstBy(key, value);
        if (result != null && !result.isEmpty()) {
            found.setBacking(result);
        } else {
            found = null;
        }
        return found;
    }

    public static ActiveRecord findFirstBy(Class klass, String key, String value) {
        return ActiveRecord.findFirstByUncached(klass, key, value);
    }

    public String getUnique() {
        return this.get("id");
    }
}

