/*
 * Decompiled with CFR 0.152.
 */
package com.orbus.mahalo;

import com.orbus.mahalo.MahaloBroadcaster;
import com.orbus.mahalo.MahaloBrowser;
import com.orbus.mahalo.MahaloSocket;
import com.orbus.mahalo.ServiceInfo;
import com.orbus.mahalo.ServiceListener;
import com.orbus.mahalo.dns.DNSCache;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class Mahalo {
    private static final int REAP_INTERVAL = 10000;
    public static String VERSION = "0.5";
    private MahaloSocket _MahaloSocket;
    private MahaloBroadcaster _Broadcaster;
    private MahaloBrowser _Browser;
    private DNSCache _Cache = new DNSCache(100);

    public Mahalo() throws UnknownHostException, IOException {
        this(null, null);
    }

    public Mahalo(InetAddress aAddress) throws UnknownHostException, IOException {
        this(aAddress, null);
    }

    public Mahalo(InetAddress aAddress, String asName) throws UnknownHostException, IOException {
        if (aAddress == null) {
            aAddress = InetAddress.getLocalHost();
        }
        if (aAddress.isLoopbackAddress()) {
            aAddress = null;
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements() && aAddress == null) {
                NetworkInterface nic = nics.nextElement();
                Enumeration<InetAddress> addresses = nic.getInetAddresses();
                while (addresses.hasMoreElements() && aAddress == null) {
                    InetAddress address = addresses.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                    System.err.println("After searching, we are broadcasting on address " + address);
                    aAddress = address;
                }
            }
        }
        if (asName == null) {
            asName = aAddress.getHostName();
            if (aAddress.toString().contains(asName)) {
                asName = InetAddress.getLocalHost().getHostName();
            }
            System.err.println("Name not provided.  Using host name from address: " + asName);
        }
        System.err.println("Creating Mahalo socket at address " + aAddress);
        this._MahaloSocket = new MahaloSocket(aAddress);
        this._MahaloSocket.startListening();
        System.err.println("Creating broadcaster and browser with host name " + asName);
        this._Broadcaster = new MahaloBroadcaster(this._MahaloSocket, asName);
        this._Browser = new MahaloBrowser(this._MahaloSocket, this._Cache);
    }

    public void start() {
        this._Broadcaster.start();
    }

    public void addServiceListener(String asType, ServiceListener aListener) {
        this._Browser.addServiceListener(asType, aListener);
    }

    public void removeServiceListener(String asType, ServiceListener aListener) {
        this._Browser.addServiceListener(asType, aListener);
    }

    public void registerService(ServiceInfo aInfo) throws IOException {
        this._Broadcaster.registerService(aInfo);
    }

    public void unregisterService(ServiceInfo aInfo) {
        this._Broadcaster.unregisterService(aInfo);
    }

    public void unregisterAllServices() {
        this._Broadcaster.unregisterAllServices();
    }

    public void close() {
        this._Broadcaster.stop();
        this._MahaloSocket.close();
    }
}

