/*
 * Decompiled with CFR 0.152.
 */
package com.orbus.mahalo.tasks;

import com.orbus.mahalo.HostInfo;
import com.orbus.mahalo.MahaloSocket;
import com.orbus.mahalo.ServiceInfo;
import com.orbus.mahalo.dns.DNSEntry;
import com.orbus.mahalo.dns.DNSPacket;
import com.orbus.mahalo.dns.DNSRecord;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Announcer
extends TimerTask {
    public static final int INTERVAL = 1000;
    private MahaloSocket _Socket;
    private HostInfo _LocalInfo;
    private List<ServiceInfo> _AnnounceList;

    public Announcer(MahaloSocket aSocket, HostInfo aLocalInfo, List<ServiceInfo> aAnnounceList) {
        this._Socket = aSocket;
        this._LocalInfo = aLocalInfo;
        this._AnnounceList = aAnnounceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DNSPacket dnsMessage = new DNSPacket(true);
        dnsMessage.setAuthoritativeAnswer(true);
        LinkedList<ServiceInfo> removalList = new LinkedList<ServiceInfo>();
        boolean bannouncedLocalInfo = false;
        if (this._LocalInfo.getState().isAnnouncing()) {
            HostInfo hostInfo = this._LocalInfo;
            synchronized (hostInfo) {
                this.addLocalInfoRecord(dnsMessage);
            }
            bannouncedLocalInfo = true;
        }
        if (this._AnnounceList != null && this._AnnounceList.size() > 0) {
            Iterator<Object> i$ = this._AnnounceList.iterator();
            while (i$.hasNext()) {
                ServiceInfo info;
                ServiceInfo serviceInfo = info = (ServiceInfo)i$.next();
                synchronized (serviceInfo) {
                    dnsMessage.addAnswer(new DNSRecord.Pointer(info.getType(), DNSEntry.EntryType.PTR, DNSEntry.EntryClass.IN, 3600, info.getQualifiedName()));
                    dnsMessage.addAnswer(new DNSRecord.Service(info.getQualifiedName(), DNSEntry.EntryClass.IN, true, 3600, info.getPriority(), info.getWeight(), info.getPort(), this._LocalInfo.getName()));
                    if (info.getTextBytes() != null) {
                        dnsMessage.addAnswer(new DNSRecord.Text(info.getQualifiedName(), DNSEntry.EntryClass.IN, true, 3600, info.getTextBytes()));
                    }
                    info.advanceState();
                    if (info.getState().isAnnounced()) {
                        removalList.add(info);
                    }
                }
            }
            if (!bannouncedLocalInfo) {
                this.addLocalInfoRecord(dnsMessage);
            }
        }
        for (ServiceInfo info : removalList) {
            this._AnnounceList.remove(info);
        }
        if (dnsMessage.getAnswers().size() > 0) {
            this._Socket.send(dnsMessage);
        } else {
            this.cancel();
        }
    }

    private void addLocalInfoRecord(DNSPacket aMessage) {
        DNSRecord.Address answer = this._LocalInfo.getDNSAddressRecord(DNSEntry.EntryType.A);
        if (answer != null) {
            aMessage.addAnswer(answer);
        }
        if ((answer = this._LocalInfo.getDNSAddressRecord(DNSEntry.EntryType.AAAA)) != null) {
            aMessage.addAnswer(answer);
        }
        this._LocalInfo.advanceState();
    }
}

