/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tessboxeditor;

import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import net.sourceforge.tessboxeditor.GuiWithEdit;
import net.sourceforge.tessboxeditor.components.ImageIconScalable;
import net.sourceforge.tessboxeditor.datamodel.TessBox;

public class GuiWithSpinner
extends GuiWithEdit {
    private static final Logger logger = Logger.getLogger(GuiWithSpinner.class.getName());

    @Override
    void stateChanged(ChangeEvent changeEvent) {
        if (this.tableSelectAction) {
            return;
        }
        List<TessBox> list = this.boxes.getSelectedBoxes();
        if (list.size() <= 0) {
            return;
        }
        if (list.size() > 1) {
            return;
        }
        TessBox tessBox = list.get(0);
        int n = this.boxes.toList().indexOf(tessBox);
        tessBox.setChrs(this.jTextFieldCharacter.getText());
        this.tableModel.setValueAt(tessBox.getChrs(), n, 0);
        Rectangle rectangle = tessBox.getRect();
        JSpinner jSpinner = (JSpinner)changeEvent.getSource();
        if (jSpinner == this.jSpinnerX) {
            rectangle.x = (Integer)this.jSpinnerX.getValue();
            this.tableModel.setValueAt(String.valueOf(rectangle.x), n, 1);
        } else if (jSpinner == this.jSpinnerY) {
            rectangle.y = (Integer)this.jSpinnerY.getValue();
            this.tableModel.setValueAt(String.valueOf(rectangle.y), n, 2);
        } else if (jSpinner == this.jSpinnerW) {
            rectangle.width = (Integer)this.jSpinnerW.getValue();
            this.tableModel.setValueAt(String.valueOf(rectangle.width), n, 3);
        } else if (jSpinner == this.jSpinnerH) {
            rectangle.height = (Integer)this.jSpinnerH.getValue();
            this.tableModel.setValueAt(String.valueOf(rectangle.height), n, 4);
        }
        Icon icon = this.jLabelImage.getIcon();
        try {
            BufferedImage bufferedImage = this.getSubimage((BufferedImage)((ImageIcon)icon).getImage(), rectangle);
            ImageIconScalable imageIconScalable = new ImageIconScalable(bufferedImage);
            imageIconScalable.setScaledFactor(scaleFactor);
            this.jLabelSubimage.setIcon(imageIconScalable);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception.getMessage(), exception);
        }
        this.jLabelImage.repaint();
        this.updateSave(true);
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GuiWithSpinner().setVisible(true);
            }
        });
    }
}

