/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tessboxeditor;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.tess4j.util.ImageIOHelper;
import net.sourceforge.tessboxeditor.datamodel.TessBox;
import net.sourceforge.tessboxeditor.datamodel.TessBoxCollection;
import net.sourceforge.tessboxeditor.utilities.ImageUtils;
import net.sourceforge.vietocr.util.Utils;
import net.sourceforge.vietpad.utilities.TextUtilities;

public class TiffBoxGenerator {
    static final String EOL = System.getProperty("line.separator");
    private final HashMap<TextAttribute, Object> map = new HashMap();
    private final List<TessBoxCollection> boxPages = new ArrayList<TessBoxCollection>();
    private final String text;
    private final Font font;
    private final int width;
    private final int height;
    private int noiseAmount;
    private final int margin = 100;
    private final List<ArrayList<TextLayout>> layouts = new ArrayList<ArrayList<TextLayout>>();
    private final List<BufferedImage> pages = new ArrayList<BufferedImage>();
    private String fileName = "fontname.exp0";
    private File outputFolder;
    private final int COLOR_WHITE = Color.WHITE.getRGB();
    private float tracking = TextAttribute.TRACKING_LOOSE.floatValue();
    private boolean isAntiAliased;
    private final File baseDir = Utils.getBaseDir(this);
    private final Pattern pattern = Pattern.compile("chars:\"(.*?)\",");
    private static final Logger logger = Logger.getLogger(TiffBoxGenerator.class.getName());

    public TiffBoxGenerator(String string, Font font, int n, int n2) {
        this.text = string;
        this.font = font;
        this.width = n;
        this.height = n2;
    }

    public void create() {
        this.map.put(TextAttribute.FAMILY, this.font.getName());
        this.map.put(TextAttribute.SIZE, this.font.getSize());
        if (this.font.getStyle() == 3) {
            this.map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            this.map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else if (this.font.getStyle() == 1) {
            this.map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else if (this.font.getStyle() == 2) {
            this.map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        this.map.put(TextAttribute.TRACKING, Float.valueOf(this.tracking));
        this.breakLines();
        this.drawPages();
        this.saveMultipageTiff();
        this.saveBoxFile();
        this.updateFontPropertiesFile();
    }

    private String formatOutputString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.readCombiningSymbols();
        for (short s = 0; s < this.pages.size(); s = (short)((short)(s + 1))) {
            TessBoxCollection tessBoxCollection = this.boxPages.get(s);
            tessBoxCollection.setCombiningSymbols(string);
            tessBoxCollection.combineBoxes();
            for (TessBox tessBox : tessBoxCollection.toList()) {
                Rectangle rectangle = tessBox.getRect();
                stringBuilder.append(String.format("%s %d %d %d %d %d", tessBox.getChrs(), rectangle.x, this.height - rectangle.y - rectangle.height, rectangle.x + rectangle.width, this.height - rectangle.y, s)).append(EOL);
            }
        }
        return stringBuilder.toString();
    }

    private String readCombiningSymbols() {
        String string = null;
        try {
            File file = new File(this.baseDir, "data/combiningsymbols.txt");
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));){
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.length() > 0 && string.charAt(0) == '\ufeff') {
                        string = string.substring(1);
                    }
                    if (string.trim().length() <= 0 || string.trim().startsWith("#")) continue;
                    break;
                }
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception.getMessage(), exception);
        }
        if (string != null) {
            string = string.replaceAll("[ \\[\\]]", "");
            string = TextUtilities.convertNCR(string);
        }
        return string;
    }

    private void tightenBoundingBox(Rectangle rectangle, BufferedImage bufferedImage) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = rectangle.x + 2;
        block0: for (n5 = rectangle.x; n5 < n6; ++n5) {
            for (n4 = rectangle.y; n4 < rectangle.y + rectangle.height; ++n4) {
                n3 = bufferedImage.getRGB(n5, n4);
                if (n3 != this.COLOR_WHITE) break block0;
            }
            ++rectangle.x;
            --rectangle.width;
        }
        n6 = rectangle.x + rectangle.width - 4;
        block2: for (n5 = rectangle.x + rectangle.width - 1; n5 > n6; --n5) {
            for (n4 = rectangle.y; n4 < rectangle.y + rectangle.height; ++n4) {
                n3 = bufferedImage.getRGB(n5, n4);
                if (n3 != this.COLOR_WHITE) break block2;
            }
            --rectangle.width;
        }
        n5 = rectangle.y + 3;
        block4: for (n3 = n4 = rectangle.y - 1; n3 < n5; ++n3) {
            for (n2 = rectangle.x; n2 < rectangle.x + rectangle.width; ++n2) {
                n = bufferedImage.getRGB(n2, n3);
                if (n == this.COLOR_WHITE) continue;
                if (n3 != n4) break block4;
                --rectangle.y;
                ++rectangle.height;
                continue block4;
            }
            if (n3 == n4) continue;
            ++rectangle.y;
        }
        n5 = rectangle.y + rectangle.height - 4;
        block6: for (n3 = rectangle.y + rectangle.height - 1; n3 > n5; --n3) {
            for (n2 = rectangle.x; n2 < rectangle.x + rectangle.width; ++n2) {
                n = bufferedImage.getRGB(n2, n3);
                if (n != this.COLOR_WHITE) break block6;
            }
            --rectangle.height;
        }
    }

    private void saveBoxFile() {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.outputFolder, this.fileName + ".box")), "UTF8"));){
            bufferedWriter.write(this.formatOutputString());
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    void updateFontPropertiesFile() {
        int n = this.fileName.indexOf(".");
        File file = new File(this.outputFolder, this.fileName.substring(0, n) + ".font_properties");
        String string = this.fileName.substring(n + 1, this.fileName.lastIndexOf(".exp"));
        try {
            Object object;
            if (file.exists()) {
                object = Files.readAllLines(Paths.get(file.getPath(), new String[0]), Charset.defaultCharset());
                Iterator<String> iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string2 = iterator.next();
                    if (!string2.startsWith(string + " ")) continue;
                    return;
                }
            } else {
                file.createNewFile();
            }
            object = String.format("%s %s %s %s %s %s\n", string, this.font.isItalic() ? "1" : "0", this.font.isBold() ? "1" : "0", "0", "0", "0");
            Files.write(Paths.get(file.getPath(), new String[0]), ((String)object).getBytes(), StandardOpenOption.APPEND);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    private void breakLines() {
        float f = (float)(this.width - 200) - (float)(150.0 * ((double)this.tracking / 0.04));
        for (String string : this.text.split("\n")) {
            TextLayout textLayout;
            if (string.length() == 0) {
                string = " ";
            }
            AttributedString attributedString = new AttributedString(string, this.map);
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), new FontRenderContext(null, this.isAntiAliased, true));
            ArrayList<TextLayout> arrayList = new ArrayList<TextLayout>();
            while ((textLayout = lineBreakMeasurer.nextLayout(f)) != null) {
                arrayList.add(textLayout);
            }
            this.layouts.add(arrayList);
        }
    }

    private Graphics2D createGraphics(BufferedImage bufferedImage, Font font) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.white);
        graphics2D.clearRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setColor(Color.black);
        graphics2D.setFont(font);
        return graphics2D;
    }

    private void drawPages() {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, this.isAntiAliased ? 10 : 12);
        this.pages.add(bufferedImage);
        Graphics2D graphics2D = this.createGraphics(bufferedImage, this.font);
        TessBoxCollection tessBoxCollection = new TessBoxCollection();
        this.boxPages.add(tessBoxCollection);
        short s = 0;
        int n = 100;
        StringBuilder stringBuilder = new StringBuilder();
        for (ArrayList<TextLayout> arrayList : this.layouts) {
            for (TextLayout textLayout : arrayList) {
                n = (int)((float)n + textLayout.getAscent());
                float f = textLayout.isLeftToRight() ? 100.0f : (float)(this.width - 100) - textLayout.getAdvance();
                textLayout.draw(graphics2D, f, n);
                stringBuilder.setLength(0);
                Matcher matcher = this.pattern.matcher(textLayout.toString());
                while (matcher.find()) {
                    stringBuilder.append(matcher.group(1)).append(" ");
                }
                String[] stringArray = stringBuilder.toString().split("\\s+");
                int n2 = textLayout.getCharacterCount();
                for (int i = 0; i < n2; ++i) {
                    Shape shape = textLayout.getBlackBoxBounds(i, i + 1);
                    Rectangle rectangle = shape.getBounds();
                    if (rectangle.width == 0 || rectangle.height == 0) continue;
                    rectangle.x = (int)((float)rectangle.x + f);
                    rectangle.y += n;
                    try {
                        this.tightenBoundingBox(rectangle, bufferedImage);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        logger.log(Level.WARNING, arrayIndexOutOfBoundsException.getMessage(), arrayIndexOutOfBoundsException);
                    }
                    char c = (char)Integer.parseInt(stringArray[i], 16);
                    tessBoxCollection.add(new TessBox(String.valueOf(c), rectangle, s));
                }
                if ((n = (int)((float)n + (2.0f * textLayout.getDescent() + textLayout.getLeading()))) <= this.height - 100) continue;
                n = 100;
                bufferedImage = new BufferedImage(this.width, this.height, this.isAntiAliased ? 10 : 12);
                this.pages.add(bufferedImage);
                tessBoxCollection = new TessBoxCollection();
                this.boxPages.add(tessBoxCollection);
                s = (short)(s + 1);
                graphics2D.dispose();
                graphics2D = this.createGraphics(bufferedImage, this.font);
            }
        }
        graphics2D.dispose();
    }

    private void saveMultipageTiff() {
        try {
            File file = new File(this.outputFolder, this.fileName + ".tif");
            file.delete();
            BufferedImage[] bufferedImageArray = this.pages.toArray(new BufferedImage[this.pages.size()]);
            if (this.noiseAmount != 0) {
                for (int i = 0; i < bufferedImageArray.length; ++i) {
                    bufferedImageArray[i] = ImageUtils.addNoise(bufferedImageArray[i], this.noiseAmount);
                }
            }
            ImageIOHelper.mergeTiff(bufferedImageArray, file);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public void setFileName(String string) {
        if (string != null && string.length() > 0) {
            int n = string.lastIndexOf(".");
            this.fileName = n > -1 ? string.substring(0, n) : string;
        }
    }

    public void setTracking(float f) {
        this.tracking = f;
    }

    public void setOutputFolder(File file) {
        this.outputFolder = file;
    }

    public void setAntiAliasing(boolean bl) {
        this.isAntiAliased = bl;
    }

    public void setNoiseAmount(int n) {
        this.noiseAmount = n;
    }
}

